package com.cku.schools.mrschool.service;

import com.cku.core.ZAErrorCode;
import com.cku.core.ZAException;
import com.cku.oa.trainschool.dao.SchoolsTeacherDao;
import com.cku.oa.trainschool.entity.TeacherLecturer;
import com.cku.oa.trainschool.entity.TrainingInstitution;
import com.thinkgem.jeesite.common.service.CrudService;
import com.thinkgem.jeesite.modules.sys.utils.UserUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;

/**
 *user chaixueteng
 *2017年6月22日
 */
@Service
@Transactional
public class SchoolsTeacherService  extends CrudService<SchoolsTeacherDao, TeacherLecturer> {

	@Autowired
	private SchoolsTeacherDao schoolsTeacherDao;


	//查重
	public void ISrepeat(TeacherLecturer teacherLecturer){
		List<TeacherLecturer> list = this.findList(new TeacherLecturer());
		list.stream().filter((e)->{
			return e.getTeacherIndex().equals(teacherLecturer.getTeacherIndex());
		}).forEach(e->{
			if(e!=null){
				throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "教师编号不允许重复！");
			}
		});
	}

    public TeacherLecturer findTeacher(String teacherName) {
		TrainingInstitution trainingInstitution = (TrainingInstitution) UserUtils.getSession().getAttribute("trainingInstitution");
		TeacherLecturer teacherLecturer = dao.findTeacher(teacherName,trainingInstitution.getId());
		return teacherLecturer;
    }
}
