package com.cku.restful.v1.sys.web;

import java.io.IOException;
import java.net.URLEncoder;
import java.util.List;
import java.util.Objects;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;

import com.cku.core.RESTResponse;
import com.cku.core.ZAErrorCode;
import com.cku.core.ZAException;
import com.cku.oa.sys.entity.BaseFile;
import com.cku.oa.sys.service.FileService;
import com.cku.util.ServletUtils;
import com.google.common.collect.Lists;
import com.thinkgem.jeesite.common.utils.StringUtils;

import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import net.sf.json.JSONObject;

@Controller
@RequestMapping("/api/v1/file")
public class RestFileController extends BaseRestController {
	@Autowired
	private FileService fileService;

	private static final List<String> BREEDER_MODULE = Lists.newArrayList("studDogImg", "pupImg");

	@RequestMapping(value = "/uploadPage")
	public String uploadPage(HttpServletRequest request, HttpServletResponse response) {
		return "/uc/upload";
	}

	/**
	 * 上传用户的头像
	 *
	 * @param file
	 * @param module
	 * @param response
	 * @throws IOException
	 */
	@RequestMapping(value = "avatar")
	@ResponseBody
	public void avatar(MultipartFile file, @RequestParam(value = "module") String module, HttpServletResponse response)
			throws IOException {
		BaseFile baseFile = fileService.uploadFile(file, module, "0");
		JSONObject object = new JSONObject();
		object.put("fileName", baseFile.getName());
		object.put("id", baseFile.getId());
		// System.out.println("图片上传会返回的id>>>>>>>>>>>>>>>>>>>>>>>>："+baseFile.getId());
		RESTResponse result = new RESTResponse("data", object.toString());
		ServletUtils.writeResponse(response, result);
	}

	@ApiOperation(value = "文件上传-获取图片", tags = { "文件上传-zxy" })
	@ApiImplicitParams({ @ApiImplicitParam(name = "token", paramType = "query", value = "token") })
	@ApiResponses({ @ApiResponse(code = 0, message = "{}") })
	@RequestMapping(value = "image/{id}", method = RequestMethod.GET)
	@ResponseBody
	public void image(@ApiParam(name = "图片id", value = "id") @PathVariable String id,HttpServletRequest request, HttpServletResponse response) throws IOException {
		String download = request.getParameter("download");
		response.setContentType("image/jpeg");
		BaseFile baseFile = fileService.get(id);
		if (Objects.nonNull(download) && Boolean.valueOf(download)) {
			response.setHeader("Content-Disposition",
					"attachment;filename=" + URLEncoder.encode(baseFile.getName(), "UTF-8"));
		}
		fileService.fileDownload(baseFile, response.getOutputStream());
	}

	/**
	 * @Description：获取图片（宠爱王国使用） @author:
	 * @version: 2016年12月16日 下午2:21:15
	 */
	@RequestMapping(value = "image/cab")
	@ResponseBody
	public void image(HttpServletRequest request, HttpServletResponse response) throws IOException {
		String id = request.getParameter("id");
		response.setContentType("application/octet-stream");
		fileService.fileDownload(id, response.getOutputStream());
	}

	@RequestMapping(value = "studDogImg")
	public void studDogImg(MultipartFile file, HttpServletRequest request, HttpServletResponse response)
			throws IOException {
		BaseFile baseFile = fileService.watermarkImg(file, "studDogImg", "1", request.getParameter("type"));
		JSONObject object = new JSONObject();
		object.put("fileName", baseFile.getName());
		object.put("id", baseFile.getId());
		ServletUtils.writeResponse(response, new RESTResponse("data", object.toString()));
	}

	@RequestMapping(value = "breederImg")
	public void breederImg(MultipartFile file, HttpServletRequest request, HttpServletResponse response)
			throws IOException {
		String module = request.getParameter("module");
		if (StringUtils.isBlank(module) || !BREEDER_MODULE.contains(module)) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "module为空或者有误");
		}
		BaseFile baseFile = fileService.watermarkImg(file, module, "1", request.getParameter("type"));
		JSONObject object = new JSONObject();
		object.put("fileName", baseFile.getName());
		object.put("id", baseFile.getId());
		ServletUtils.writeResponse(response, new RESTResponse("data", object.toString()));
	}

	@RequestMapping(value = "dogActivation")
	public void dogActivation(MultipartFile file, HttpServletResponse response) throws IOException {
		BaseFile baseFile = fileService.watermarkImg(file, "dogActivation", "1", "1");
		JSONObject object = new JSONObject();
		object.put("fileName", baseFile.getName());
		object.put("id", baseFile.getId());
		ServletUtils.writeResponse(response, new RESTResponse("data", object.toString()));
	}

	@ApiOperation(value = "文件上传-获取视频", tags = { "文件上传-zxy" })
	@ApiImplicitParams({ @ApiImplicitParam(name = "token", paramType = "query", value = "token") })
	@ApiResponses({ @ApiResponse(code = 0, message = "{}") })
	@RequestMapping(value = "/vod/{id}", method = RequestMethod.GET)
	@ResponseBody
	public void vod(@ApiParam(name = "视频id", value = "id") @PathVariable String id, HttpServletResponse response)
			throws IOException {
		BaseFile file = fileService.get(id);
		if (file != null && !"1".equals(file.getOpenFlag())) {
			ServletUtils.writeResponse(response, new RESTResponse("1", "视频序号有误"));
			return;
		}
		response.setContentType("audio/mp4");
		fileService.fileDownload(file, response.getOutputStream());
	}

	@ApiOperation(value = "文件上传-上传图片", tags = { "文件上传-zxy" })
	@ApiResponses({ @ApiResponse(code = 0, message = "{}") })
	@RequestMapping(value = "/img", method = RequestMethod.POST)
	@ResponseBody
	public void upload(MultipartFile file, HttpServletRequest request, HttpServletResponse response)
			throws IOException {
		BaseFile baseFile = fileService.uploadFile(file, "appraisal/images", "1");
		JSONObject fileObject = new JSONObject();
		fileObject.put("id", baseFile.getId());
		fileObject.put("fileName", baseFile.getName());
		fileObject.put("realName", baseFile.getOrginalname());
		String path = request.getContextPath();
		String imgPath = request.getScheme() + "://" + request.getServerName() + ":" + request.getServerPort() + path
				+ "/api/v1/file/image/" + baseFile.getId();
		fileObject.put("url", imgPath);

		ServletUtils.writeResponse(response, new RESTResponse("data", fileObject));
	}

	@ApiOperation(value = "文件上传-上传视频", tags = { "文件上传-zxy" })
	@ApiImplicitParams({ @ApiImplicitParam(name = "token", paramType = "query", value = "token") })
	@ApiResponses({ @ApiResponse(code = 0, message = "{}") })
	@RequestMapping(value = "/vod", method = RequestMethod.POST)
	@ResponseBody
	public void uploadsVod(MultipartFile file, HttpServletRequest request, HttpServletResponse response)
			throws IOException {
		BaseFile baseFile = fileService.uploadFile(file, "appraisal/vod", "1");
		JSONObject fileObject = new JSONObject();
		fileObject.put("id", baseFile.getId());
		fileObject.put("fileName", baseFile.getName());
		fileObject.put("realName", baseFile.getOrginalname());
		String path = request.getContextPath();
		String imgPath = request.getScheme() + "://" + request.getServerName() + ":" + request.getServerPort() + path
				+ "/api/v1/file/vod/" + baseFile.getId();
		fileObject.put("url", imgPath);

		ServletUtils.writeResponse(response, new RESTResponse("data", fileObject));
	}
}
