package com.cku.restful.v1.sys.utils;

import java.util.concurrent.Executor;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.scheduling.annotation.EnableAsync;
import org.springframework.scheduling.concurrent.CustomizableThreadFactory;

/**
 * @ClassName PayCallBackThreadPool
 * @Description 支付回调线处理程池
 **/
@Configuration
@EnableAsync
public class PayCallBackThreadPool {

	private static final int CORE_POOL_SIZE = 10;
	private static final String PAY_CALLBACK_THREAD_NAME = "paycallback";
	private static final String SPLIT_ORDER_THREAD_NAME = "splitOrder";
	private static final int MAXI_NUM_SIZE = 10;
	private static final int KEEP_ALIVE_TIME = 30;
	private static final int LINK_BLOCK_QUEUE_SIZE = 1000;

	private LinkedBlockingQueue<Runnable> payCallBackLinkedBlockingQueue;

	private LinkedBlockingQueue<Runnable> splitOrderLinkedBlockingQueue;

	@Bean(name = "payCallBack")
	public Executor payCallBackExecutor() {
		payCallBackLinkedBlockingQueue = new LinkedBlockingQueue<Runnable>(LINK_BLOCK_QUEUE_SIZE);
		ThreadFactory factory = new CustomizableThreadFactory(PAY_CALLBACK_THREAD_NAME);
		ThreadPoolExecutor executor = new ThreadPoolExecutor(CORE_POOL_SIZE, MAXI_NUM_SIZE, KEEP_ALIVE_TIME,
				TimeUnit.SECONDS, payCallBackLinkedBlockingQueue, factory, new ThreadPoolExecutor.AbortPolicy());
		executor.allowCoreThreadTimeOut(true);
		return executor;
	}

	@Bean(name = "splitOrder")
	public Executor splitOrderExecutor() {
		splitOrderLinkedBlockingQueue = new LinkedBlockingQueue<Runnable>(LINK_BLOCK_QUEUE_SIZE);
		ThreadFactory factory = new CustomizableThreadFactory(SPLIT_ORDER_THREAD_NAME);
		ThreadPoolExecutor executor = new ThreadPoolExecutor(CORE_POOL_SIZE, MAXI_NUM_SIZE, KEEP_ALIVE_TIME,
				TimeUnit.SECONDS, splitOrderLinkedBlockingQueue, factory, new ThreadPoolExecutor.AbortPolicy());
		executor.allowCoreThreadTimeOut(true);
		return executor;
	}

}
