package com.cku.restful.v1.show.service;

import java.text.ParseException;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.cku.core.RESTResponse;
import com.cku.oa.show.dao.ShowJudgeCertificateDao;
import com.cku.oa.show.dao.ShowJudgeCertificateDogGroupDao;
import com.cku.oa.show.entity.ShowJudgeCertificate;
import com.cku.oa.show.entity.ShowJudgeCertificateDogGroup;
import com.thinkgem.jeesite.common.persistence.Page;
import com.thinkgem.jeesite.common.utils.DateUtils;
import com.thinkgem.jeesite.modules.sys.entity.Dict;
import com.thinkgem.jeesite.modules.sys.utils.DictUtils;

import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.springframework.util.CollectionUtils;

@Service
@Transactional(readOnly = true)
public class CkuShowJudgeCertificateService {

	@Autowired
	private ShowJudgeCertificateDao showJudgeCertificateDao;
	@Autowired
	private ShowJudgeCertificateDogGroupDao showJudgeCertificateDogGroupDao;

	public RESTResponse getAll() {
		JSONObject data = new JSONObject();
		data.put("allBreedJudges", getCertificateType1());
		data.put("qualifiedBestInShowJudges", getCertificateType2());
		data.put("groupJudges", getCertificateType3());
		data.put("singleBreedJudges", getCertificateType4());
		data.put("ckuBhJudges", getCertificateType5());
		data.put("ckuAgilityJudges", getCertificateType6());
		data.put("ckuIgpJudges", getCertificateType7());
		data.put("groomingJudges", getCertificateType8());
		data.put("cleanCareJudges", getCertificateType9());
		data.put("teacherCleanCareJudges", getCertificateType10());
		data.put("handlerJudges", getCertificateType11());
		return new RESTResponse("data", data);
	}

	private JSONArray getCertificateType1() {
		return getCertificateTypeByCertificateType("1",false);
	}

	private JSONArray getCertificateType2() {
		return getCertificateTypeByCertificateType("2",false);
	}

	private JSONArray getCertificateType3() {
		List<ShowJudgeCertificate> showJudgeCertificateList = getShowJudgeCertificateListByCertificateType("3",false);
		JSONArray array = new JSONArray();
		for (ShowJudgeCertificate po : showJudgeCertificateList) {
			JSONObject jo = new JSONObject();
			jo.put("name", po.getName());
			jo.put("nameEn", po.getNameEn());
			jo.put("judgeCertificate", po.getJudgeCertificate());
			List<ShowJudgeCertificateDogGroup> showJudgeCertificateDogGroupList = getShowJudgeCertificateDogGroupListByJudgeCertificateMian(
					po.getJudgeCertificate());
			JSONArray showJudgeCertificateDogGroup = new JSONArray();
			for (ShowJudgeCertificateDogGroup dogGroup : showJudgeCertificateDogGroupList) {
				JSONObject dogGroupJo = new JSONObject();
				dogGroupJo.put("judgeCertificate", dogGroup.getJudgeCertificate());
				ShowJudgeCertificateDogGroup fciShowGroup = showJudgeCertificateDogGroupDao
						.getFciShowGroupByGroupNo(dogGroup.getGroupNo());
				String groupNo = Integer.valueOf(dogGroup.getGroupNo()).toString();
				dogGroupJo.put("chineseGroupName", "第" + groupNo + "组：" + fciShowGroup.getJudgeCertificateMian());
				dogGroupJo.put("englishGroupName", "Group " + groupNo + "：" + fciShowGroup.getJudgeCertificate());
				showJudgeCertificateDogGroup.add(dogGroupJo);
			}
			jo.put("showJudgeCertificateDogGroup", showJudgeCertificateDogGroup);
			array.add(jo);
		}
		return array;
	}

	private JSONObject getCertificateType4() {
		List<ShowJudgeCertificate> showJudgeCertificateList = getShowJudgeCertificateListByCertificateType("4",false);
		JSONArray cku = new JSONArray();
		JSONArray csv = new JSONArray();
		JSONArray ckurk = new JSONArray();
		for (ShowJudgeCertificate po : showJudgeCertificateList) {
			JSONObject jsonObject = new JSONObject();
			jsonObject.put("name", po.getName());
			jsonObject.put("nameEn", po.getNameEn());
			jsonObject.put("judgeCertificate", po.getJudgeCertificate());
			jsonObject.put("dogBreedCode", po.getDogBreedCode());
			jsonObject.put("dogBreedName", po.getDogBreedName());
			if ("166".equals(po.getDogBreedCode())) {
				csv.add(jsonObject);
			} else if ("147".equals(po.getDogBreedCode())) {
				ckurk.add(jsonObject);
			} else {
				cku.add(jsonObject);
			}
		}
		JSONObject jo = new JSONObject();
		jo.put("CKU", cku);
		jo.put("CSV", csv);
		jo.put("CKURK", ckurk);
		return jo;
	}

	private JSONArray getCertificateType5() {
		return getCertificateTypeByCertificateType("5",false);
	}

	private JSONArray getCertificateType6() {
		return getCertificateTypeByCertificateType("6",false);
	}

	private JSONArray getCertificateType7() {
		return getCertificateTypeByCertificateType("7",false);
	}

	@SuppressWarnings("unchecked")
	private JSONArray getCertificateType8() {
		List<ShowJudgeCertificate> showJudgeCertificateList = getShowJudgeCertificateListByCertificateType("8",true);
		JSONArray array = new JSONArray();
		if (!CollectionUtils.isEmpty(showJudgeCertificateList)) {
			List<Dict> groupDict = DictUtils.getDictList("grooming_judge_dog_group");
			final Map<String, String> groupDictMap = new HashMap<>();
			if (!CollectionUtils.isEmpty(groupDict)) {
				groupDictMap.putAll(groupDict.stream().collect(Collectors.toMap(Dict::getValue, Dict::getLabel)));
			}
			Date nowDate;
			String format = DateUtils.sdf.format(new Date());
			try {
				nowDate = DateUtils.sdf.parse(format);
			} catch (ParseException e) {
				throw new RuntimeException(e);
			}
			//过滤掉证书时间过期的
			List<ShowJudgeCertificate> judgeCertificateList = showJudgeCertificateList.stream()
					.filter(item -> item.getEndDate() != null && item.getEndDate().compareTo(nowDate) >= 0)
					.collect(Collectors.toList());

			Map<String, List<ShowJudgeCertificate>> judgeMap = judgeCertificateList.stream()
					.collect(Collectors.groupingBy(ShowJudgeCertificate::getName));
			
			judgeMap.forEach((name, judgeList) -> {
				JSONObject jsonObj = new JSONObject();
				//美容审查员则默认显示 选中的
				List<ShowJudgeCertificate> showJudgeCertificates = judgeList.stream().filter(item -> "1".equals(item.getExpirationDateVisibleFlag())).collect(Collectors.toList());
				ShowJudgeCertificate po = null;
				if (!CollectionUtils.isEmpty(showJudgeCertificates)) {
					po = showJudgeCertificates.get(0);
					jsonObj.put("endDate", DateUtils.formatDate(po.getEndDate()));
				} else {
					po = judgeList.get(0);
				}
				jsonObj.put("name", po.getName());
				jsonObj.put("nameEn", po.getNameEn());
				jsonObj.put("judgeCertificate", "");
				//排序用 
				Integer [] maxSort = new Integer[1] ;
				Long [] minSignDate =  new Long[1];
				JSONArray dogGroupArr = new JSONArray();
				judgeList.forEach(j -> {
					JSONObject dogGroup = new JSONObject();
					dogGroup.put("groupName", groupDictMap.get(j.getGroomingDogGroup()));
					dogGroup.put("judgeCertificate", j.getJudgeCertificate());
					dogGroupArr.add(dogGroup);
					int sort = Objects.isNull(j.getSort())?0:j.getSort();
					maxSort[0] = maxSort[0]==null?sort:(maxSort[0]<sort?sort:maxSort[0]);
					long timel = Objects.isNull(j.getSignDate())?0:j.getSignDate().getTime();
					minSignDate[0] =  minSignDate[0]==null?timel:(minSignDate[0]> timel?timel:minSignDate[0]);
				});

				jsonObj.put("maxSort", maxSort[0]);
				jsonObj.put("minSignDate", minSignDate[0]);
				
				jsonObj.put("judgeCertificateList", dogGroupArr);
				array.add(jsonObj);
			});
		}
        // 排序 sort倒序 signDate正序
		Collections.sort(array, new Comparator<JSONObject>() {
	            @Override
	            public int compare(JSONObject o1, JSONObject o2) {
	            	int result = o2.getInt("maxSort") - o1.getInt("maxSort");
	            	if (result == 0) {
	            		result = o1.getLong("minSignDate")> o2.getLong("minSignDate")?1:-1;
	            	}
	                return result;
	            }
	        });
		return array;
	}

	private JSONArray getCertificateType9() {
		List<ShowJudgeCertificate> showJudgeCertificateList = getShowJudgeCertificateListByCertificateType("9",true);
		JSONArray array = new JSONArray();
		if (!CollectionUtils.isEmpty(showJudgeCertificateList)) {
			Date nowDate;
			String format = DateUtils.sdf.format(new Date());
			try {
				nowDate = DateUtils.sdf.parse(format);
			} catch (ParseException e) {
				throw new RuntimeException(e);
			}
			//过滤掉证书时间过期的
			List<ShowJudgeCertificate> judgeCertificateList = showJudgeCertificateList.stream()
					.filter(item -> item.getEndDate() != null && item.getEndDate().compareTo(nowDate) >= 0)
					.collect(Collectors.toList());

			for (ShowJudgeCertificate po : judgeCertificateList) {
				JSONObject jo = new JSONObject();
				jo.put("name", po.getName());
				jo.put("nameEn", po.getNameEn());
				if ("1".equals(po.getExpirationDateVisibleFlag())) {
					jo.put("endDate", DateUtils.formatDate(po.getEndDate()));
				}
				jo.put("judgeCertificate", po.getJudgeCertificate());
				array.add(jo);
			}
		}
		return array;
	}

	private JSONArray getCertificateType10() {
		return getCertificateTypeByCertificateType("10",false);
	}

	private JSONArray getCertificateType11() {
		return getCertificateTypeByCertificateType("11",true);
	}

	private List<ShowJudgeCertificate> getShowJudgeCertificateListByCertificateType(String certificateType,boolean isSort) {
		ShowJudgeCertificate showJudgeCertificate = new ShowJudgeCertificate();
		showJudgeCertificate.setCertificateType(certificateType);
		showJudgeCertificate.setVisibleFlag("1");
		if ("1".equals(certificateType)) {
			showJudgeCertificate.setIsExpire(1);
		}
		Page page = new Page();
		if(isSort) {
			page.setOrderBy("a.sort desc ,ifnull(a.sign_date,a.create_date)");
		}else {
			page.setOrderBy("a.create_date");
		}
		showJudgeCertificate.setPage(page);
		return showJudgeCertificateDao.findList(showJudgeCertificate);
	}

	private List<ShowJudgeCertificateDogGroup> getShowJudgeCertificateDogGroupListByJudgeCertificateMian(
			String judgeCertificateMian) {
		ShowJudgeCertificateDogGroup showJudgeCertificateDogGroup = new ShowJudgeCertificateDogGroup();
		showJudgeCertificateDogGroup.setJudgeCertificateMian(judgeCertificateMian);
		showJudgeCertificateDogGroup.setVisibleFlag("1");
		Page page = new Page();
		page.setOrderBy("a.group_no");
		showJudgeCertificateDogGroup.setPage(page);
		return showJudgeCertificateDogGroupDao.findList(showJudgeCertificateDogGroup);
	}

	private JSONArray getCertificateTypeByCertificateType(String certificateType,boolean isSort) {
		List<ShowJudgeCertificate> showJudgeCertificateList = getShowJudgeCertificateListByCertificateType(
				certificateType,isSort);
		JSONArray array = new JSONArray();
		for (ShowJudgeCertificate po : showJudgeCertificateList) {
			JSONObject jo = new JSONObject();
			jo.put("name", po.getName());
			jo.put("nameEn", po.getNameEn());
			if ("1".equals(certificateType)) {
				jo.put("endDate", DateUtils.formatDate(po.getEndDate()));
			}
			jo.put("judgeCertificate", po.getJudgeCertificate());
			array.add(jo);
		}
		return array;
	}
}
