/**
 * Copyright &copy; 2012-2014 <a href="https://github.com/thinkgem/jeesite">JeeSite</a> All rights reserved.
 */
package com.cku.restful.v1.open;

import com.cku.core.RESTResponse;
import com.cku.restful.v1.sys.web.BaseRestController;
import com.cku.restful.v1.trainschool.service.RestTrainingInstitutionService;
import com.cku.util.ServletUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;

/**
 * 培训机构管理Controller
 *
 * @author yuanshuai
 * @version 2018-10-15
 */
@Controller
@RequestMapping(value = "/api/v1/open/school")
public class OpenTrainingInstitutionController extends BaseRestController {

    @Autowired
    private RestTrainingInstitutionService restTrainingInstitutionService;

    @RequestMapping(value = "/trainingInstitution", method = RequestMethod.GET)
    @ResponseBody
    public void getList(HttpServletRequest request, HttpServletResponse response)
            throws IOException {
        RESTResponse result = restTrainingInstitutionService.getList(request);
        ServletUtils.writeResponse(response, result);
    }
}