package com.cku.restful.v1.open;

import static com.cku.oa.sys.service.SMSRemindService.TYPE_SMS_REGISTER;
import static com.cku.oa.sys.service.SMSRemindService.TYPE_SMS_RESET_PASSWORD;

import java.io.IOException;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

import org.apache.commons.lang3.StringUtils;
import org.apache.shiro.SecurityUtils;
import org.apache.shiro.session.Session;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

import com.cku.core.RESTResponse;
import com.cku.core.ResultDto;
import com.cku.core.ZAErrorCode;
import com.cku.core.ZAException;
import com.cku.oa.dog.service.DogBirthCertificateService;
import com.cku.oa.dog.service.DogService;
import com.cku.oa.ipaddress.service.IpAddressService;
import com.cku.oa.kennel.entity.Kennel;
import com.cku.oa.kennel.service.KennelService;
import com.cku.oa.sys.dao.FciDogDao;
import com.cku.oa.sys.entity.BaseFile;
import com.cku.oa.sys.entity.LoginServer;
import com.cku.oa.sys.entity.RestShareRegister;
import com.cku.oa.sys.entity.SMSChangePassword;
import com.cku.oa.sys.entity.user.Member;
import com.cku.oa.sys.service.FileService;
import com.cku.oa.sys.service.LoginServerService;
import com.cku.oa.sys.service.OrgService;
import com.cku.oa.sys.service.SMSRemindService;
import com.cku.oa.sys.service.SysUserLoginLogService;
import com.cku.oa.sys.service.UserService;
import com.cku.oa.sys.service.user.MemberService;
import com.cku.oa.sys.util.IPLimitUtil;
import com.cku.oa.sys.util.PinYinUtil;
import com.cku.restful.v1.dog.service.RestDogColorMarkService;
import com.cku.restful.v1.dog.service.RestDogService;
import com.cku.restful.v1.groomer.service.RestGroomerDiplomaService;
import com.cku.restful.v1.kennel.service.RestKennelService;
import com.cku.restful.v1.open.CaptchaFactory.CaptchaFactory;
import com.cku.restful.v1.open.response.ExportDogMsgResponse;
import com.cku.restful.v1.sys.model.RestMember;
import com.cku.restful.v1.sys.model.RestUser;
import com.cku.restful.v1.sys.service.CkuMemberServide;
import com.cku.restful.v1.sys.service.RestIDCardService;
import com.cku.restful.v1.sys.utils.BeanUtil;
import com.cku.restful.v1.sys.web.BaseRestController;
import com.cku.util.DateUtils;
import com.cku.util.ServletUtils;
import com.thinkgem.jeesite.common.config.Global;
import com.thinkgem.jeesite.common.servlet.ValidateCodeServlet;
import com.thinkgem.jeesite.common.utils.CacheUtils;
import com.thinkgem.jeesite.common.utils.EhCacheUtils;
import com.thinkgem.jeesite.modules.sys.entity.User;
import com.thinkgem.jeesite.modules.sys.utils.UserUtils;
import com.wf.captcha.base.Captcha;
import com.wf.captcha.utils.CaptchaUtil;

import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import net.sf.json.JSONObject;

@Controller
@RequestMapping(value = "/api/v1/open")
public class OpenController extends BaseRestController {

	private Logger logger = LoggerFactory.getLogger(getClass());

	private static final String CACHE_NAME = "smsCache";
	private static final String NEW_CACHE_NAME = "newSmsCache";

	@Autowired
	private UserService userService;
	@Autowired
	private MemberService memberService;
	@Autowired
	private OrgService orgService;
	@Autowired
	private FciDogDao fciDogDao;
	@Autowired
	private RestDogColorMarkService restDogColorMarkService;
	@Autowired
	private RestDogService restDogService;
	@Autowired
	private KennelService kennelService;
	@Autowired
	private CkuMemberServide ckuMemberServide;
	@Autowired
	private SMSRemindService smsRemindService;
	@Autowired
	private RestIDCardService restIDCardService;
	@Autowired
	private RestGroomerDiplomaService restGroomerDiplomaService;
	@Autowired
	private FileService fileService;
	@Autowired
	private LoginServerService loginServerService;
	@Autowired
	private DogService dogService;
	@Autowired
	private SysUserLoginLogService userLoginLogService;
	@Autowired
	private DogBirthCertificateService dogBirthCertificateService;

//	private String captchaArray [] = {"gif","arithmetic","chineseGif"};

	private String captchaArray[] = { "gif" };

	@Autowired
	private IpAddressService ipAddressService;

	@Autowired
	private RestKennelService restKennelService;

	@RequestMapping(value = "/logout", method = RequestMethod.GET)
	public String logout(HttpServletRequest request, HttpServletResponse response) throws IOException {
		User loginUser = UserUtils.getLoginUser();
		String url = request.getScheme() + "://" + request.getServerName() + ":" + request.getServerPort();
		if (loginUser != null) {
			url += "/oa-web/" + loginServerService.getShortNameByUrl(request) + "/login.html";
		}
		try {
			SecurityUtils.getSubject().logout();
		} catch (Exception e) {
			e.printStackTrace();
		}
		return "redirect:" + url;
	}

	/**
	 *
	 * @description: 获取验证码
	 * @author: laiguanglong
	 * @date: 2016年9月26日 下午6:27:34
	 */
	@RequestMapping(value = "/validateCode", method = RequestMethod.GET)
	public void getHospital(HttpServletRequest request, HttpServletResponse response)
			throws IOException, ServletException {
		String ip = IPLimitUtil.getIpAddr(request);
		logger.info("get validate date:{},ip:{}", DateUtils.getStringDate(), ip);
		ValidateCodeServlet servlet = new ValidateCodeServlet();
		servlet.doGet(request, response);
	}

	@RequestMapping(value = "/validateCodeNew", method = RequestMethod.GET)
	public void getHospitalNew(HttpServletRequest request, HttpServletResponse response)
			throws IOException, ServletException {
		String ip = IPLimitUtil.getIpAddr(request);
		logger.info("get validate new date:{},ip:{}", DateUtils.getStringDate(), ip);

		CaptchaFactory captchaFactory = new CaptchaFactory();
		Captcha captcha = captchaFactory.getCaptcha(this.getCaptchaString());
		CaptchaUtil.out(captcha, request, response);
	}

	private String getCaptchaString() {
		int random = new Random().nextInt(captchaArray.length);
		return captchaArray[random];
	}

	/**
	 *
	 * @description: 校验验证码
	 * @author: zhangxiang
	 * @date: 2019年9月09日 下午6:27:34
	 */
	@RequestMapping(value = "/checkValidateCodeNew", method = RequestMethod.POST)
	@ResponseBody
	public Object checkValidateCodeNew(@RequestBody String json, HttpServletRequest request,
			HttpServletResponse response) throws IOException {
		JSONObject object = JSONObject.fromObject(json);
		Map<String, Object> map = new HashMap<String, Object>();
		String validateCode = object.getString("validateCode");
		// 验证码校验
		Session session = UserUtils.getSession();
		if (org.apache.commons.lang.StringUtils.isBlank(validateCode)) {
			map.put("rc", "1");
			map.put("msg", "验证码为空,请输入验证码。");
			return map;
		}

		String code = (String) session.getAttribute("captcha");
		if (code == null) {
			map.put("rc", "1");
			map.put("msg", "验证码无效，请刷新验证码。");
			return map;
		}
		if (!validateCode.toLowerCase().equals(code)) {
			map.put("rc", "1");
			map.put("msg", "验证码错误，请重新输入。");
			return map;
		}
		// 重置验证码
		// session.setAttribute(ValidateCodeServlet.VALIDATE_CODE,null);
		map.put("rc", "0");

		return map;
	}

	/**
	 *
	 * @description: 校验验证码
	 * @author: zhangxiang
	 * @date: 2019年9月09日 下午6:27:34
	 */
	@RequestMapping(value = "/checkValidateCode", method = RequestMethod.POST)
	@ResponseBody
	public Object checkValidateCode(@RequestBody String json, HttpServletRequest request, HttpServletResponse response)
			throws IOException {
		JSONObject object = JSONObject.fromObject(json);
		Map<String, Object> map = new HashMap<String, Object>();
		String validateCode = object.getString("validateCode");
		// 验证码校验
		Session session = UserUtils.getSession();
		if (org.apache.commons.lang.StringUtils.isBlank(validateCode)) {
			map.put("rc", "1");
			map.put("msg", "验证码为空,请输入验证码。");
			return map;
		}

		String code = (String) session.getAttribute(ValidateCodeServlet.VALIDATE_CODE);
		if (code == null) {
			map.put("rc", "1");
			map.put("msg", "验证码无效，请刷新验证码。");
			return map;
		}
		if (!validateCode.toLowerCase().equals(code)) {
			map.put("rc", "1");
			map.put("msg", "验证码错误，请重新输入。");
			return map;
		}
		// 重置验证码
		// session.setAttribute(ValidateCodeServlet.VALIDATE_CODE,null);
		map.put("rc", "0");

		return map;
	}
//	旧注册，停止使用	yuanshuai-2017.12.14
//	/**
//	 *
//	 * @description: 注册
//	 * @author: laiguanglong
//	 * @date: 2016年9月26日 下午6:28:47
//	 */
//	@RequestMapping(value = "/register", method = RequestMethod.POST)
//	@ResponseBody
//	public void register(@RequestBody String json, HttpServletRequest request,
//			HttpServletResponse response) throws IOException {
//		JSONObject object = JSONObject.fromObject(json);
//		String email = object.getString("email");
//		String newPassword = object.getString("newPassword");
//		String name = object.getString("name");
//		String loginName = object.getString("loginName");
//		String validateCode = object.getString("validateCode");
//		String mobile = object.getString("mobile");
//		String mailType = "";
//		if(object.has("mailType")){
//			mailType = object.getString("mailType");
//		}
//		LoginServer loginServer = loginServerService.getLoginServerByUrl(request);
//		userService.Regist(email, newPassword, name, loginName, validateCode, mobile, mailType, loginServer);
//		RESTResponse result = new RESTResponse();
//		ServletUtils.writeResponse(response, result);
//	}

	/**
	 *
	 * @description: 激活
	 * @author: laiguanglong
	 * @date: 2016年9月26日 下午6:28:56
	 */
	@RequestMapping(value = "/activeUser", method = RequestMethod.GET)
	public String activeUser(HttpServletRequest request, HttpServletResponse response) throws IOException {
		String loginName = request.getParameter("loginName");
		String ticket = request.getParameter("ticket");
		String type = request.getParameter("type");
		userService.activeUser(loginName, ticket, type);
		return "redirect:http://vip.chongaibao.com/oa-web/uc/login.html#/login/activatesuccess";
	}

	/**
	 *
	 * @description: 登录
	 * @author: laiguanglong
	 * @date: 2016年9月26日 下午6:29:03
	 */
	@RequestMapping(value = "/login", method = RequestMethod.POST)
	@ResponseBody
	public void login(@RequestBody String json, HttpServletRequest request, HttpServletResponse response)
			throws IOException {
		JSONObject object = JSONObject.fromObject(json);
		String loginName = object.getString("loginName");
		String password = object.getString("password");
		String validateCode = object.getString("validateCode");
		LoginServer loginServer = loginServerService.getLoginServerByUrl(request);
		String host = IPLimitUtil.getIpAddr(request);
		userService.login(loginName, password, validateCode, host, null, loginServer);
		// 保存登录日志 2018年12月7日17:30:25 --yuanshuai
		userLoginLogService.saveLoginLog(request);
		RESTResponse result = new RESTResponse("shortName", loginServer.getUserShortName());
		ServletUtils.writeResponse(response, result);
	}

	/**
	 *
	 * @description: 犬舍评选登录
	 * @author:
	 * @date:
	 */
	@RequestMapping(value = "/kennelLogin", method = RequestMethod.GET)
	@ResponseBody
	public void kennelLogin(HttpServletRequest request, HttpServletResponse response) throws IOException {
		String loginName = request.getParameter("loginName");
		String password = request.getParameter("password");
		RESTResponse result = userService.kennelLogin(loginName, password);
		ServletUtils.writeResponse(response, result);
	}

	/**
	 *
	 * @description: 微信登录
	 * @author: laiguanglong
	 * @date: 2016年9月26日 下午6:29:03
	 */
	@RequestMapping(value = "/loginWX", method = RequestMethod.POST)
	@ResponseBody
	public void loginWX(@RequestBody String json, HttpServletRequest request, HttpServletResponse response)
			throws IOException {
		JSONObject object = JSONObject.fromObject(json);
		String loginName = object.getString("loginName");
		String password = object.getString("password");
		String validateCode = object.getString("validateCode");
		String weixinId = object.getString("weixinId");
		String host = IPLimitUtil.getIpAddr(request);
		userService.login(loginName, password, validateCode, host, weixinId, null);
		RESTResponse result = new RESTResponse();
		ServletUtils.writeResponse(response, result);
	}

	/**
	 *
	 * @description: 手机token登录
	 * @author: lyy
	 */
	@RequestMapping(value = "/loginMobile", method = RequestMethod.POST)
	@ResponseBody
	public void loginMobile(@RequestBody String json, HttpServletRequest request, HttpServletResponse response)
			throws IOException {
		JSONObject object = JSONObject.fromObject(json);
		String token = object.getString("token");
		String key = object.getString("key");
		String host = IPLimitUtil.getIpAddr((HttpServletRequest) request);
		userService.loginMobile(token, key, host);
		RESTResponse result = new RESTResponse();
		ServletUtils.writeResponse(response, result);
	}

	@RequestMapping(value = "/applyChangePassword", method = RequestMethod.GET)
	@ResponseBody
	public void applyChangePassword(HttpServletRequest request, HttpServletResponse response) throws IOException {
		RESTResponse result = userService.applyChangePassword(request);
		ServletUtils.writeResponse(response, result);
	}

	/**
	 * @date:20170504
	 * @description: 手机端 电子会员卡，通过用户token 获取当前用户信息
	 * @author: lyy
	 */
	@RequestMapping(value = "/getMemberInfoByToken", method = RequestMethod.GET)
	@ResponseBody
	public void getMemberInfoByToken(HttpServletRequest request, HttpServletResponse response) throws IOException {
		String token = request.getParameter("token");
		User user = UserUtils.getUserByToken(token, request.getHeader("club"));
		Member member = new Member();
		member.setUser(user);
		List<Member> list = memberService.findList(member);
		if (list != null && list.size() > 0) {
			member = list.get(0);
		}
		JSONObject jsonObject = new JSONObject();
		JSONObject data = new JSONObject();
		// 初始化都为null，以防止缺失该节点
		// data.put("member", JSONObject.fromObject(null));
		// data.put("user", JSONObject.fromObject(null));
		RestMember restMember = new RestMember();
		BeanUtil.copyProperties(restMember, member, "yyyy-MM-dd");
		RestUser restUser = new RestUser();
		BeanUtil.copyProperties(restUser, user, "yyyy-MM-dd");
		data.put("user", JSONObject.fromObject(restUser));
		data.put("member", JSONObject.fromObject(restMember));
		jsonObject.put("data", data);
		RESTResponse result = new RESTResponse(jsonObject);
		ServletUtils.writeResponse(response, result);
	}

	/**
	 * 修改密码
	 *
	 * @param request
	 * @param response
	 * @throws IOException
	 */
	@RequestMapping(value = "/rePassword", method = RequestMethod.PUT)
	@ResponseBody
	public void rePassword(@RequestBody String json, HttpServletRequest request, HttpServletResponse response)
			throws IOException {
		JSONObject object = JSONObject.fromObject(json);
		String ticket = object.getString("ticket");
		String newPassword = object.getString("password");
		String loginName = object.getString("loginName");
		String type = object.getString("type");
		RESTResponse result = new RESTResponse();
		userService.confirmChangePassword(loginName, type, newPassword, ticket);
		ServletUtils.writeResponse(response, result);
	}

	@RequestMapping(value = "/getFciGroup", method = RequestMethod.GET)
	@ResponseBody
	public void getClubNameByChip(HttpServletResponse response) throws IOException {
		List<HashMap<String, Object>> list = fciDogDao.getFciGroup();
		RESTResponse result = new RESTResponse("0", list);
		ServletUtils.writeResponse(response, result);
	}

	@RequestMapping(value = "/getFciSectionByGroupId/{groupId}", method = RequestMethod.GET)
	@ResponseBody
	public void getFciSectionByGroupId(@PathVariable String groupId, HttpServletResponse response) throws IOException {
		List<HashMap<String, Object>> list = fciDogDao.getFciSectionByGroupId(groupId);
		RESTResponse result = new RESTResponse("0", list);
		ServletUtils.writeResponse(response, result);
	}

	@RequestMapping(value = "/getFciDogBySectionId/{sectionId}", method = RequestMethod.GET)
	@ResponseBody
	public void getFciDogBySectionId(@PathVariable String sectionId, HttpServletResponse response) throws IOException {
		List<HashMap<String, Object>> list = fciDogDao.getFciDogBySectionId(sectionId);
		RESTResponse result = new RESTResponse("0", list);
		ServletUtils.writeResponse(response, result);
	}

	@RequestMapping(value = "/getFciDogAll", method = RequestMethod.GET)
	@ResponseBody
	public void getFciDogAll(HttpServletResponse response) throws IOException {
		List<HashMap<String, Object>> list = fciDogDao.getFciDogAll();
		RESTResponse result = new RESTResponse("0", list);
		ServletUtils.writeResponse(response, result);
	}

	@RequestMapping(value = "/getFciDogById/{dogId}", method = RequestMethod.GET)
	@ResponseBody
	public void getFciDogAll(@PathVariable String dogId, HttpServletResponse response) throws IOException {
		HashMap<String, Object> list = fciDogDao.getFciDogById(dogId);
		if (list == null ) 
			throw new ZAException(1001, "此犬种信息不全");
		RESTResponse result = null;
		Object origin = list.get("origin");
		if (origin == null || "".equals(origin.toString())) {
			result = new RESTResponse(1001, "此犬种信息不全");
		} else {
			String date_of_acceptance_on_a_definitive_basis_by_the_fci = com.thinkgem.jeesite.common.utils.DateUtils
					.formatDateTime((Date) list.get("date_of_acceptance_on_a_definitive_basis_by_the_fci"));
			String date_of_publication_of_the_official_validstandard = com.thinkgem.jeesite.common.utils.DateUtils
					.formatDateTime((Date) list.get("date_of_publication_of_the_official_validstandard"));
			list.put("date_of_acceptance_on_a_definitive_basis_by_the_fci",
					date_of_acceptance_on_a_definitive_basis_by_the_fci);
			list.put("date_of_publication_of_the_official_validstandard",
					date_of_publication_of_the_official_validstandard);
			result = new RESTResponse("0", list);
		}

		ServletUtils.writeResponse(response, result);
	}

	/**
	 *
	 * @Description：根据芯片号获取上传该芯片的合作机构名称
	 * @author: zhuoHeng
	 * @version: 2017年1月4日 下午3:12:19
	 */
	@RequestMapping(value = "/getClubNameByChip/{chip}", method = RequestMethod.GET)
	@ResponseBody
	public void getClubNameByChip(@PathVariable("chip") String chip, HttpServletResponse response) throws IOException {
		RESTResponse result = orgService.getClubNameByChip(chip);
		ServletUtils.writeResponse(response, result);
	}

	/**
	 *
	 * @Description：根据犬种获取毛色列表
	 * @author: zhuoHeng
	 * @version: 2017年1月4日 下午3:17:50
	 */
	@RequestMapping(value = "/getColorMessageByBreedCode/{breedCode}", method = RequestMethod.GET)
	@ResponseBody
	public void getColorMessageByBreedCode(@PathVariable("breedCode") String breedCode, HttpServletResponse response)
			throws IOException {
		RESTResponse result = restDogColorMarkService.getList(breedCode);
		ServletUtils.writeResponse(response, result);
	}

	/**
	 *
	 * @description: CKU官网根据血统证书号或芯片号进行查询
	 * @author: laiguanglong
	 * @date: 2016年9月28日 下午5:26:13
	 */
	@RequestMapping(value = "/getDogByKeyWithCaptcha", method = RequestMethod.GET)
	@ResponseBody
	public void getDogByKeyWithCaptcha(HttpServletRequest request, HttpServletResponse response) throws IOException {
		String validateCode = request.getParameter("validateCode");
		if (StringUtils.isBlank(validateCode)) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "验证码为空");
		}
		Session session = UserUtils.getSession();
		String code = (String) session.getAttribute(ValidateCodeServlet.VALIDATE_CODE);
		if (code == null) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "验证码无效，请从新获取验证码");
		}
		if (!validateCode.toLowerCase().equals(code)) {
			// 重置验证码
			session.setAttribute(ValidateCodeServlet.VALIDATE_CODE, null);
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "验证码有误");
		}
		// 重置验证码
		session.setAttribute(ValidateCodeServlet.VALIDATE_CODE, null);
		RESTResponse result = restDogService.getByKey(request);
		if (result.getData() != null && result.getData().get("data") != null) {
			restDogService.desensitize((JSONObject) result.getData().get("data"));
		}
		ServletUtils.writeResponse(response, result);
	}

	/**
	 * CKU官网根据芯片号查询犬只等级
	 *
	 * @param request
	 * @param response
	 * @throws IOException
	 */
	@RequestMapping(value = "/getDogClassByKeyWithCaptcha", method = RequestMethod.GET)
	@ResponseBody
	public void getDogClassByKeyWithCaptcha(HttpServletRequest request, HttpServletResponse response)
			throws IOException {
		String validateCode = request.getParameter("validateCode");
		if (StringUtils.isBlank(validateCode)) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "验证码为空");
		}
		Session session = UserUtils.getSession();
		String code = (String) session.getAttribute(ValidateCodeServlet.VALIDATE_CODE);
		if (code == null) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "验证码无效，请从新获取验证码");
		}
		if (!validateCode.toLowerCase().equals(code)) {
			// 重置验证码
			session.setAttribute(ValidateCodeServlet.VALIDATE_CODE, null);
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "验证码有误");
		}
		// 重置验证码
		session.setAttribute(ValidateCodeServlet.VALIDATE_CODE, null);

		RESTResponse result = restDogService.getDogClassByKeyWithCaptcha(request);
		ServletUtils.writeResponse(response, result);
	}

	/**
	 * 根据芯片号护照号验证激活
	 *
	 * @param request
	 * @param response
	 * @throws IOException
	 */
	@RequestMapping(value = "/checkActivite", method = RequestMethod.GET)
	@ResponseBody
	public void checkActivite(HttpServletRequest request, HttpServletResponse response) throws IOException {
		RESTResponse result = restDogService.checkActivite(request);
		ServletUtils.writeResponse(response, result);
	}

	/**
	 * 保存激活信息
	 *
	 * @param request
	 * @param response
	 * @throws IOException
	 */
	@RequestMapping(value = "/saveActivite", method = RequestMethod.POST)
	@ResponseBody
	public void saveActivite(HttpServletRequest request, HttpServletResponse response) throws IOException {
		RESTResponse result = restDogService.saveActivite(request);
		ServletUtils.writeResponse(response, result);
	}

	/**
	 *
	 * @Description：根据会员号返回对应犬舍信息
	 * @author: zhuoHeng
	 * @version: 2017年5月15日 上午10:52:34
	 * @throws IOException
	 */
	@RequestMapping(value = "/getKennelMessageByMemberCode", method = RequestMethod.GET)
	@ResponseBody
	public void getKennelMessageByMemberCode(HttpServletRequest request, HttpServletResponse response)
			throws IOException {
		String memberCode = request.getParameter("memberCode");
		if (StringUtils.isBlank(memberCode)) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "会员号为空");
		}
		Kennel kennel = kennelService.getKennelByMemberCode(memberCode);
		Map<String, String> map = new HashMap<>();
		if (kennel != null) {
			map.put("name", kennel.getName());
			map.put("nameEn", kennel.getNameEn());
			map.put("memberName", kennel.getMember().getName());
		} else {
			map.put("name", "");
			map.put("nameEn", "");
			map.put("memberName", "");
		}
		ServletUtils.writeResponse(response, new RESTResponse("data", map));
	}

	/**
	 *
	 * @Description：验证输入的手机号是否存在会员
	 * @author: zhuoHeng
	 * @version: 2017年5月16日 下午6:13:38
	 */
	@RequestMapping(value = "/isMember", method = RequestMethod.GET)
	@ResponseBody
	public void isMember(HttpServletRequest request, HttpServletResponse response) throws IOException {
		Map<String, Boolean> map = ckuMemberServide.validateIsMemberByMobile(request);
		ServletUtils.writeResponse(response, new RESTResponse("data", map));
	}

	/**
	 *
	 * @Description：获取缓存中的手机号
	 * @author: zhuoHeng
	 * @version: 2017年5月20日 下午2:15:42
	 */
	@RequestMapping(value = "/getCacheMobile", method = RequestMethod.GET)
	public void getCacheMobile(HttpServletRequest request, HttpServletResponse response) throws IOException {
		EhCacheUtils.put("register", "mobile", "13501176610");
		Map<String, String> map = new HashMap<>();
		map.put("mobile", (String) EhCacheUtils.get("register", "mobile"));
		ServletUtils.writeResponse(response, new RESTResponse("data", map));
	}

	/**
	 *
	 * @Description：获取注册手机号
	 * @author: zhuoHeng
	 * @version: 2017年5月20日 下午3:54:06
	 */
	@RequestMapping(value = "/getSessionMobile", method = RequestMethod.POST)
	@ResponseBody
	public void getSessionMobile(@RequestBody String json, HttpServletRequest request, HttpServletResponse response)
			throws IOException {
		HttpSession session = request.getSession();
		JSONObject object = JSONObject.fromObject(json);
		String realName = object.getString("realName");
		String idCard = object.getString("idCard");
		Map<String, String> map = new HashMap<>();
		LoginServer loginServer = loginServerService.getLoginServerByUrl(request);
		Integer i = restIDCardService.validateIDCard(request, idCard, realName, loginServer.getMemberSite(), true);
		if (i == 1) {
			map.put("mobile", (String) session.getAttribute("mobile"));
		} else {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "身份信息验证失败");
		}
		ServletUtils.writeResponse(response, new RESTResponse("data", map));
	}
	
	/**
	 *
	 * @Description：发送手机验证码(注册使用) @author: zhuoHeng
	 * @version: 2017年5月22日 上午10:58:15
	 */
	@RequestMapping(value = "/sendVerificationCode", method = RequestMethod.GET)
	@ResponseBody
	public void sendVerification(HttpServletRequest request, HttpServletResponse response) throws IOException {
		String mobile = request.getParameter("mobile");

		String ip = IPLimitUtil.getIpAddr(request);
		// 添加到ipAddress
		ipAddressService.addIpAddress(ip);
		// 验证ip是否在黑名单
		if (ipAddressService.isBlackList(ip)) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "该ip已列为黑名单，请联系客服，致电400-660-7000");
		}
		String client = request.getParameter("client");
		if ( !"ios".equals(client) && !"android".equals(client)) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "client不能为空");
		}
		smsRemindService.sendVerifyCode(request, mobile, true, TYPE_SMS_REGISTER);
		request.getSession().setAttribute("cacheMobile", mobile);
		ServletUtils.writeResponse(response, new RESTResponse());
	}

	/**
	 *
	 * @Description：发送手机验证码(注册使用) @author: zhuoHeng
	 * @version: 2017年5月22日 上午10:58:15
	 */
	@RequestMapping(value = "/sendVerificationCode/two", method = RequestMethod.GET)
	@ResponseBody
	public void sendVerificationCode(HttpServletRequest request, HttpServletResponse response) throws IOException {
		String mobile = request.getParameter("mobile");
		String validateCode = request.getParameter("validateCode");

		String ip = IPLimitUtil.getIpAddr(request);
		// 添加到ipAddress
		ipAddressService.addIpAddress(ip);
		// 验证ip是否在黑名单
		if (ipAddressService.isBlackList(ip)) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "该ip已列为黑名单，请联系客服，致电400-660-7000");
		}
		logger.info("send sms code two date:{},ip:{},mobile:{},validateCode:{}", DateUtils.getStringDate(), ip, mobile,
				validateCode);
		String client = request.getParameter("client");
		if (StringUtils.isBlank(validateCode) && !"ios".equals(client) && !"android".equals(client)) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "验证码不能为空");
		}
		smsRemindService.sendVerifyCode(request, mobile, true, TYPE_SMS_REGISTER);
		request.getSession().setAttribute("cacheMobile", mobile);
		ServletUtils.writeResponse(response, new RESTResponse());
	}

	@RequestMapping(value = "/sendVerificationCode/new", method = RequestMethod.GET)
	@ResponseBody
	public void sendVerificationCodeNew(HttpServletRequest request, HttpServletResponse response) throws IOException {
		String mobile = request.getParameter("mobile");
		String validateCode = request.getParameter("validateCode");

		String ip = IPLimitUtil.getIpAddr(request);
		logger.info("send sms code new date:{},ip:{},mobile:{},validateCode:{}", DateUtils.getStringDate(), ip, mobile,
				validateCode);

		// 添加到ipAddress
		ipAddressService.addIpAddress(ip);
		// 验证ip是否在黑名单
		if (ipAddressService.isBlackList(ip)) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "该ip已列为黑名单，请联系客服，致电400-660-7000");
		}
//        if(StringUtils.isBlank(validateCode)) {
//        	throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "验证码不能为空");
//        }
//		smsRemindService.sendVerifyCode(request, mobile, true, TYPE_SMS_REGISTER);
//		request.getSession().setAttribute("cacheMobile", mobile);
//		ServletUtils.writeResponse(response, new RESTResponse());

	}

	/**
	 * 第二繁殖人校验
	 * @param request
	 * @param response
	 * @throws IOException
	 */
	@RequestMapping(value = "/checkSecondBreeder", method = RequestMethod.GET)
	@ResponseBody
	public void checkSecondBreeder(HttpServletRequest request, HttpServletResponse response) throws IOException {
		RESTResponse result = dogBirthCertificateService.getSecondBreeder(request);
		ServletUtils.writeResponse(response, result);
	}

	/**
	 *
	 * @Description：验证手机验证码并缓存手机号(注册使用) @author: zhuoHeng
	 * @version: 2017年5月22日 下午2:43:47
	 */
	@RequestMapping(value = "/smsValidate", method = RequestMethod.POST)
	@ResponseBody
	public void validateSMS(@RequestBody String json, HttpServletRequest request, HttpServletResponse response)
			throws IOException {
		JSONObject object = JSONObject.fromObject(json);
		String mobile = object.getString("mobile");
		String key = object.getString("key");
		String password = object.getString("password");
		HttpSession session = request.getSession();

		if (smsRemindService.checkVerifyCode(mobile, key)) {
			RESTResponse result = new RESTResponse();
			session.setAttribute("mobile", mobile);
			session.setAttribute("validate", "yes");
			session.setAttribute("password", password);
			ServletUtils.writeResponse(response, result);
		} else {
			session.setAttribute("mobile", "");
			session.setAttribute("validate", "no");
			RESTResponse result = new RESTResponse(1, "验证短信失败");
			ServletUtils.writeResponse(response, result);
		}

	}

	/**
	 *
	 * @Description：基于手机号注册宠爱王国账号和会员基本信息
	 * @author: zhuoHeng
	 * @version: 2017年5月23日 上午10:25:43
	 */
	@RequestMapping(value = "/newRegister", method = RequestMethod.POST)
	@ResponseBody
	public void newRegister(@RequestBody String json, HttpServletRequest request, HttpServletResponse response)
			throws IOException {
		JSONObject object = JSONObject.fromObject(json);
		HttpSession session = request.getSession();
		// 密码
		String newPassword = (String) session.getAttribute("password");
		// 手机号
		String name = object.getString("name");
		// 手机号
		String loginName = object.getString("loginName");
		// 手机号
		String mobile = object.getString("mobile");
		// 犬舍中文名称
		String cnKennelName = (String) object.get("cnKennelName");
		// 犬舍英文名称
		String enKennelName = (String) object.get("enKennelName");
		// 推荐人
		String referee = (String) object.get("referee");
		if (StringUtils.isNotBlank(referee)) {
			memberService.getReferee(referee);
		}

		Kennel kennel = new Kennel();
		kennel.setName(cnKennelName);
		kennel.setNameEn(enKennelName);

		Member member = new Member();
		member.setName(object.getString("realName"));
		member.setGender("male");
		member.setNameEn(PinYinUtil.getFullSpell(object.getString("realName")));
		member.setCardNo(object.getString("cardNo"));
		member.setPhone(object.getString("phone"));
		member.setMobile(object.getString("mobile"));
		String birthday = "1900-01-01";
		Date date = com.thinkgem.jeesite.common.utils.DateUtils.parseDate(birthday);
		member.setBirthday(date);
		member.setProvince(object.getString("province"));
		member.setCity(object.getString("city"));
		member.setArea(object.get("area") == null ? "" : object.getString("area"));
		member.setStreet(object.getString("street"));
		member.setMemberType(object.getString("memberType"));
		member.setDeliveryCertified(object.getString("deliveryCertified"));
		member.setDeliveryNotice("到付快递");
		member.setReferee(referee); // 推荐人
		member.setKennel(kennel); // 犬舍信息
		if (member.getKennel() != null && StringUtils.isNotBlank(member.getKennel().getName())) {
			// 注册繁育专业会员添加注册标示
			member.setRegisterFlag("1");
			Kennel checkKennel = new Kennel();
			checkKennel.setIsCheckType("name");
			checkKennel.setName(member.getKennel().getName());
			restKennelService.checkKennelName(member, checkKennel);
			checkKennel.setIsCheckType("nameEn");
			checkKennel.setNameEn(member.getKennel().getNameEn());
			restKennelService.checkKennelName(member, checkKennel);
		}
		LoginServer loginServer = loginServerService.getLoginServerByUrl(request);
		User user = userService.newRegistMember(newPassword, name, loginName, mobile, member, loginServer);
		String host = IPLimitUtil.getIpAddr(request);
		userService.internalLogin(loginName, newPassword, host, null, loginServer);
		JSONObject jo = new JSONObject();
		jo.put("id", user.getId());
		RESTResponse result = new RESTResponse(jo);
		ServletUtils.writeResponse(response, result);
	}

	/**
	 *
	 * @Description：基于手机号注册宠爱王国账号
	 * @author: zhuoHeng
	 * @version: 2017年5月23日 下午4:22:44
	 */
	@RequestMapping(value = "/registerAccount", method = RequestMethod.POST)
	@ResponseBody
	public void registerAccount(@RequestBody String json, HttpServletRequest request, HttpServletResponse response)
			throws IOException {
		JSONObject object = JSONObject.fromObject(json);
		String key = object.getString("key");
		// 密码
		String newPassword = object.getString("password");
		// 手机号
		String name = object.getString("mobile");
		// 手机号
		String loginName = object.getString("mobile");
		// 手机号
		String mobile = object.getString("mobile");
		SMSChangePassword sms = (SMSChangePassword) CacheUtils.get(CACHE_NAME, "newSms" + mobile);
		if (sms == null) {
			RESTResponse result = new RESTResponse(1, "短信验证码验证失败");
			ServletUtils.writeResponse(response, result);
			return;
		}
		String realkey = sms.getKey();
		boolean smsValid = realkey.equals(key);
		if (Global.isDevMode()) {
			smsValid = realkey.equals(key) || "6666".equals(key);
			;
		}
		if (smsValid) {
			LoginServer loginServer = loginServerService.getLoginServerByUrl(request);
			User user = userService.newRegist(newPassword, name, loginName, mobile, loginServer);
			String host = IPLimitUtil.getIpAddr(request);
			userService.internalLogin(loginName, newPassword, host, null, loginServer);
			JSONObject jo = new JSONObject();
			jo.put("id", user.getId());
			RESTResponse result = new RESTResponse(jo);
			ServletUtils.writeResponse(response, result);
		} else {
			RESTResponse result = new RESTResponse(1, "短信验证码验证失败");
			ServletUtils.writeResponse(response, result);
		}
	}

	/**
	 *
	 * @Description：校验用户名是否符合选择的密码找回方式
	 * @author: zhuoHeng
	 * @version: 2017年5月26日 上午11:03:57
	 * @throws IOException
	 */
	@RequestMapping(value = "/validateLoginName", method = RequestMethod.GET)
	@ResponseBody
	public void validateLoginName(HttpServletRequest request, HttpServletResponse response) throws IOException {
		String loginName = request.getParameter("loginName");
		String type = request.getParameter("type");
		LoginServer loginServer = loginServerService.getLoginServerByUrl(request);
		RESTResponse rest = userService.validateLoginName(loginName, type, loginServer);
		ServletUtils.writeResponse(response, rest);
	}

	/**
	 *
	 * @Description：session存储找回密码的手机号
	 * @author: zhuoHeng
	 * @version: 2017年5月26日 下午5:12:01
	 * @throws IOException
	 */
	@RequestMapping(value = "/cacheMobile", method = RequestMethod.GET)
	@ResponseBody
	public void cacheMobile(HttpServletRequest request, HttpServletResponse response) throws IOException {
		String loginName = request.getParameter("loginName");
		userService.cacheMobile(loginName, request);
		ServletUtils.writeResponse(response, new RESTResponse());
	}

	/**
	 *
	 * @Description：获取session中存储的手机号（通过手机号找回密码使用） @author: zhuoHeng
	 * @version: 2017年5月26日 下午5:22:45
	 * @throws IOException
	 */
	@RequestMapping(value = "/getBindMobile", method = RequestMethod.GET)
	@ResponseBody
	public void getBindMobile(HttpServletRequest request, HttpServletResponse response) throws IOException {
		HttpSession session = request.getSession();
		String cacheMobile = (String) session.getAttribute("cacheMobile");
		if (StringUtils.isBlank(cacheMobile)) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "页面已过期，请重新找回密码");
		} else {
			cacheMobile = cacheMobile.substring(0, 3) + "****"
					+ cacheMobile.substring(cacheMobile.length() - 4, cacheMobile.length());
		}
		ServletUtils.writeResponse(response, new RESTResponse("mobile", cacheMobile));
	}

	/**
	 *
	 * @Description：发送验证码（找回密码使用） @author: zhuoHeng
	 * @version: 2017年5月31日 下午2:18:24
	 */
	@RequestMapping(value = "/verificationCode", method = RequestMethod.GET)
	@ResponseBody
	public void verificationCode(HttpServletRequest request, HttpServletResponse response) throws IOException {
		HttpSession session = request.getSession();
		String mobile = (String) session.getAttribute("cacheMobile");
		if (StringUtils.isBlank(mobile)) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "页面已过期，请重新找回密码");
		}
		smsRemindService.sendVerifyCode(request, mobile, false, TYPE_SMS_RESET_PASSWORD);
		ServletUtils.writeResponse(response, new RESTResponse());
	}

	/**
	 *
	 * @Description：获取缓存中上次发送验证码的时间（倒计时用） @author: zhuoHeng
	 * @version: 2017年5月31日 下午4:05:23
	 * @throws IOException
	 */
	@RequestMapping(value = "/getCacheTime", method = RequestMethod.GET)
	@ResponseBody
	public void getCacheTime(HttpServletRequest request, HttpServletResponse response) throws IOException {
		HttpSession session = request.getSession();
		String mobile = (String) session.getAttribute("cacheMobile");
		int time = 0;
		Date date = (Date) CacheUtils.get(NEW_CACHE_NAME, "newSmsDate" + mobile);
		if (date != null) {
			time = (int) (60 - (System.currentTimeMillis() - date.getTime()) / 1000);
		}
		Map<String, Integer> map = new HashMap<>();
		map.put("time", time < 0 ? 0 : time);
		ServletUtils.writeResponse(response, new RESTResponse("data", map));
	}

	/**
	 *
	 * @Description：验证短信验证码并存储验证结果(找回密码使用) @author: zhuoHeng
	 * @version: 2017年5月31日 下午5:54:59
	 */
	@RequestMapping(value = "/validateSms", method = RequestMethod.GET)
	@ResponseBody
	public void validateSms(HttpServletRequest request, HttpServletResponse response) throws IOException {
		HttpSession session = request.getSession();
		String mobile = (String) session.getAttribute("cacheMobile");
		String key = request.getParameter("key");
		if (StringUtils.isBlank(mobile)) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "页面已过期，请重新找回密码");
		}
		SMSChangePassword sms = (SMSChangePassword) CacheUtils.get(CACHE_NAME, "newSms" + mobile);
		if (sms == null) {
			RESTResponse result = new RESTResponse(1, "短信验证码验证失败");
			ServletUtils.writeResponse(response, result);
			return;
		}
		String realkey = sms.getKey();
		if (realkey.equals(key)) {
			RESTResponse result = new RESTResponse();
			CacheUtils.remove(CACHE_NAME, "newSms" + mobile);// 短信验证码验证通过后，移除该号码的缓存验证码
			session.setAttribute("mobile", mobile);
			session.setAttribute("validate", "yes");
			ServletUtils.writeResponse(response, result);
		} else {
			session.setAttribute("mobile", "");
			session.setAttribute("validate", "no");
			RESTResponse result = new RESTResponse(1, "验证码错误");
			ServletUtils.writeResponse(response, result);
		}
	}

	/**
	 *
	 * @Description：手机验证修改密码
	 * @author: zhuoHeng
	 * @version: 2017年6月1日 下午4:55:59
	 */
	@RequestMapping(value = "/resetPassword", method = RequestMethod.POST)
	@ResponseBody
	public void resetPassword(@RequestBody String json, HttpServletRequest request, HttpServletResponse response)
			throws IOException {
		HttpSession session = request.getSession();
		String id = (String) session.getAttribute("cacheId");
		String validate = (String) session.getAttribute("validate");// 验证码验证通过标识
		if (StringUtils.isBlank(id) || StringUtils.isBlank(validate)) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "页面已过期，请重新找回密码");
		}
		if ("yes".equals(validate)) {
			JSONObject object = JSONObject.fromObject(json);
			// 密码
			String password = object.getString("password");
			// 确认密码
			String confirm = object.getString("confirm");
			if (StringUtils.isNotBlank(password) && StringUtils.isNotBlank(confirm) && password.equals(confirm)) {
				userService.resetNewPassword(id, confirm);
			} else {
				throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "两次输入的密码不一致");
			}
		} else {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "验证码验证未通过，请重新找回密码");
		}
		session.setAttribute("id", "");
		session.setAttribute("validate", "");
		ServletUtils.writeResponse(response, new RESTResponse());
	}

	/**
	 *
	 * @Description：根据缓存获取验证码（临时接口） @author: zhuoHeng
	 * @version: 2017年6月2日 下午1:49:30
	 */
	/*
	 * @RequestMapping(value="/getTempCode" , method=RequestMethod.GET)
	 *
	 * @ResponseBody public void getTempCode(HttpServletRequest
	 * request,HttpServletResponse response) throws IOException{ String mobile =
	 * request.getParameter("mobile"); SMSChangePassword sms = (SMSChangePassword)
	 * CacheUtils.get(NEW_CACHE_NAME,"newSms"+mobile); if(sms == null){ RESTResponse
	 * result = new RESTResponse(1,"无验证码"); ServletUtils.writeResponse(response,
	 * result); return; } String realkey = sms.getKey();
	 * ServletUtils.writeResponse(response, new RESTResponse("data",realkey)); }
	 */
	/**
	 *
	 * @Description：验证用户名是否有效（找回密码校验） @author: zhuoHeng
	 * @version: 2017年6月5日 下午3:03:32
	 */
	@RequestMapping(value = "/findPasswordValidate", method = RequestMethod.GET)
	@ResponseBody
	public void findPasswordValidate(HttpServletRequest request, HttpServletResponse response) throws IOException {
		RESTResponse result = userService.validateLoginName(request);
		ServletUtils.writeResponse(response, result);
	}

	/**
	 *
	 * @Description：根据缓存获取验证码（临时接口） @author: zhuoHeng
	 * @version: 2017年6月2日 下午1:49:30
	 */
	/*
	 * @RequestMapping(value="/bindUser" , method=RequestMethod.GET)
	 *
	 * @ResponseBody public void bindUser(HttpServletRequest
	 * request,HttpServletResponse response) throws IOException{ SMSChangePassword
	 * change = (SMSChangePassword)smsRemindService.getBindMemberCache();
	 * Map<String, String> map = new HashMap<>(); map.put("yzm", change.getKey());
	 * RESTResponse result = new RESTResponse("data",map);
	 * ServletUtils.writeResponse(response, result); }
	 */

	/**
	 * CKU官网 美容及培训 相关的证书(搜索维度:证书号/会员号)
	 *
	 * @Author chaixueteng
	 * @2017年7月4日下午3:11:12
	 */
	@RequestMapping(value = "/getGroomerAndHandlerMsg", method = RequestMethod.GET)
	@ResponseBody
	public void getGroomerAndHandlerMsg(HttpServletRequest request, HttpServletResponse response) throws IOException {
		String validateCode = request.getParameter("validateCode");
		if (StringUtils.isBlank(validateCode)) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "验证码为空");
		}
		Session session = UserUtils.getSession();
		String code = (String) session.getAttribute(ValidateCodeServlet.VALIDATE_CODE);
		if (code == null) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "验证码无效，请从新获取验证码");
		}
		if (!validateCode.toLowerCase().equals(code)) {
			// 重置验证码
			session.setAttribute(ValidateCodeServlet.VALIDATE_CODE, null);
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "验证码有误");
		}
		// 重置验证码
		session.setAttribute(ValidateCodeServlet.VALIDATE_CODE, null);
		RESTResponse result = restGroomerDiplomaService.getGroomerAndHandlerMsgByKey(request);
		ServletUtils.writeResponse(response, result);
	}

	/**
	 * 根据图片id 查看图片
	 *
	 * @Author chaixueteng
	 * @2017年3月17日下午3:16:06
	 */
	@RequestMapping(value = "/image/{id}")
	@ResponseBody
	public void image(@PathVariable String id, HttpServletResponse response) throws IOException {
		BaseFile file = fileService.get(id);
		if (file == null || !"1".equals(file.getOpenFlag())) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "图片id有误");
		}
		response.setContentType("image/jpeg");
		fileService.fileDownload(file,response.getOutputStream());
	}
	@RequestMapping(value = "/image2/{id}")
	@ResponseBody
	public void image2(@PathVariable String id, HttpServletResponse response) throws IOException {
		BaseFile file = fileService.get(id);
		if (file == null) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "图片id有误");
		}
		response.setContentType("image/jpeg");
		fileService.fileDownload(file,response.getOutputStream());
	}

	/**
	 * 国际宠物美容师打印、查找照片
	 *
	 * @param id
	 * @param response
	 * @throws IOException
	 */
	@RequestMapping(value = "/groomerImage/{id}")
	@ResponseBody
	public void groomerImage(@PathVariable String id, HttpServletResponse response) throws IOException {
		response.setContentType("image/jpeg");
		fileService.fileDownload(id,response.getOutputStream());
	}

	/**
	 * @Description： 判断是否手机访问
	 *
	 * @author: yuanshuai
	 * @date: 2018/3/5 14:21
	 */
	@RequestMapping(value = "/isMoblie", method = RequestMethod.GET)
	@ResponseBody
	public void isMoblie(HttpServletRequest request, HttpServletResponse response) throws IOException {
		boolean isMobile = false;
		String[] mobileAgents = { "iphone", "android" };
		if (request.getHeader("User-Agent") != null) {
			for (String mobileAgent : mobileAgents) {
				if (request.getHeader("User-Agent").toLowerCase().contains(mobileAgent)) {
					isMobile = true;
				}
			}
		}
		ServletUtils.writeResponse(response, new RESTResponse("data", isMobile));
	}

	/**
	 * 新版血统证书二维码扫描接口
	 *
	 * @Author chaixueteng
	 * @2018年03月08日下午4:04:53
	 */
	@RequestMapping(value = "scanMsgByDogKey", method = RequestMethod.GET)
	@ResponseBody
	public void scanMsgByDogKey(HttpServletRequest request, HttpServletResponse response) throws IOException {
		RESTResponse result = restDogService.scanMsgByDogKey(request);
		ServletUtils.writeResponse(response, result);
	}

	@RequestMapping(value = "/getDogF", method = RequestMethod.GET)
	@ResponseBody
	public void getDogF(HttpServletRequest request, HttpServletResponse response) throws IOException {
		String dogCode = request.getParameter("dogCode");
		restDogService.getDogGeneration(dogCode);
		ServletUtils.writeResponse(response, new RESTResponse());
	}

	@RequestMapping(value = "/getDogGeneration", method = RequestMethod.GET)
	@ResponseBody
	public void getDogGeneration(HttpServletRequest request, HttpServletResponse response) throws IOException {
		String dogCode = request.getParameter("dogCode");
		int dogGeneration = restDogService.getDogGeneration(dogCode);
		ServletUtils.writeResponse(response, new RESTResponse("dogGeneration", dogGeneration));
	}

	// 屏蔽修改犬只代数部分代码--不上线
//	@RequestMapping(value = "/updateDogGeneration", method = RequestMethod.GET)
//	@ResponseBody
//	public void updateDogGeneration(HttpServletRequest request,HttpServletResponse response) throws IOException{
//	    //43.227.252.141
//		if (!IPLimitUtil.getIpAddr(request).equals("43.227.252.141")) {
//			throw new ZAException(ZAErrorCode.ZA_ERROR, "非法IP禁止访问");
//		}
//		String startDateStr = request.getParameter("startDate");
//		String endDateStr = request.getParameter("endDate");
//		SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
//		Map<String, String> map = Maps.newHashMap();
//		int count = 0;
//		Date startDate = null, endDate = null;
//		try {
//			if (!StringUtils.isBlank(startDateStr) || !StringUtils.isBlank(endDateStr)) {
//				startDate = simpleDateFormat.parse(startDateStr);
//				endDate = simpleDateFormat.parse(endDateStr);
//			}
//		} catch (Exception e) {
//			throw new ZAException(ZAErrorCode.ZA_ERROR, "时间错误");
//		}
//		List<Dog> allList = dogDao.findAllListByDate(startDate, endDate);
//		Date startTime = new Date();
//		for (int i = 0; i < allList.size(); i++) {
//			Dog dog = allList.get(i);
//			if (dog != null && !StringUtils.isBlank(dog.getPedigreeCertifiedCode())) {
//				int generation = restDogService.getDogGeneration(dog.getPedigreeCertifiedCode());
//				try {
//					if (Integer.valueOf(dog.getDogGeneration()) != generation) {
//						dog.setDogGeneration(String.valueOf(generation));
//						dogDao.updateDogGeneration(dog);
//						count++;
//					}
//				} catch (Exception e) {
//					e.printStackTrace();
//				}
//			}
//		}
//		Date endTime = new Date();
//		map.put("startDate", startDateStr);
//		map.put("endDate", endDateStr);
//		map.put("totalCount", String.valueOf(allList.size()));
//		map.put("updateCount", String.valueOf(count));
//		map.put("interval", String.valueOf((endTime.getTime() - startTime.getTime()) / 1000));
//		ServletUtils.writeResponse(response, new RESTResponse("data", map));
//	}

	@RequestMapping(value = "/getDogGenerationByParents", method = RequestMethod.GET)
	public void getDogGenerationByParents(HttpServletRequest request, HttpServletResponse response) throws IOException {
		String fatherPedigreeCertified = request.getParameter("fatherPedigreeCertified");
		String motherPedigreeCertified = request.getParameter("motherPedigreeCertified");
		if (StringUtils.isBlank(fatherPedigreeCertified) || StringUtils.isBlank(motherPedigreeCertified)) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "父血统证书号或母血统证书号为空");
		}
		int dogGeneration = dogService.getDogGeneration(fatherPedigreeCertified, motherPedigreeCertified);
		JSONObject data = new JSONObject();
		data.put("dogGeneration", dogGeneration + "");
		RESTResponse result = new RESTResponse("data", data);
		ServletUtils.writeResponse(response, result);
	}

	@RequestMapping(value = "/nosesms")
	public void nosesms(HttpServletRequest request, HttpServletResponse response) throws IOException {
		smsRemindService.sendNoseLine(request);
		ServletUtils.writeResponse(response, new RESTResponse());
	}

	/**
	 * 注册分享
	 */
	@RequestMapping(value = "/shareRegister", method = RequestMethod.GET)
	@ResponseBody
	public void shareRegister(HttpServletRequest request, HttpServletResponse response) throws IOException {
		Member member = UserUtils.getLoginMember();
//		String source = request.getParameter("source");
		LoginServer loginServer = loginServerService.getLoginServerByUrl(request);
		RestShareRegister shareResult = memberService.shareRegister(member, loginServer);
		RESTResponse result = new RESTResponse("data", shareResult);
		ServletUtils.writeResponse(response, result);
	}

	/**
	 * 注册分享朋友圈回调
	 */
	@RequestMapping(value = "/shareRegister/return", method = RequestMethod.GET)
	@ResponseBody
	public void shareRegisterReturn(HttpServletRequest request, HttpServletResponse response) throws IOException {
		Member member = UserUtils.getLoginMember();
		RESTResponse result = memberService.shareRegisterReturn(member);
		ServletUtils.writeResponse(response, result);
	}

	@ApiOperation(value = "查询用户地址", tags = { "通用支付" })
	@ApiImplicitParams({})
	@ApiResponses({ @ApiResponse(code = 0, message = "safeMobile,phone ,province + city + area + street") })
	@RequestMapping(value = "/getUserAddress/{memberCode}", method = RequestMethod.GET)
	@ResponseBody
	public ResultDto<Member> shareRegisterReturn(
			@ApiParam(name = "memberCode", value = "memberCode") @PathVariable String memberCode,
			HttpServletRequest request, HttpServletResponse response) throws IOException {
		Member member = memberService.getByMemberCode(memberCode);
//		ServletUtils.writeResponse(response, new RESTResponse("data", member));
		return ResultDto.success(member);
	}
	
	
	@GetMapping(value = "/scanExportMsgByDogKey")
	@ApiOperation("出口证书二维码的扫描信息")
	@ResponseBody
	public ResultDto<ExportDogMsgResponse>  scanExportMsgByDogKey(@RequestParam("key") String key) throws IOException {
		ExportDogMsgResponse result = restDogService.scanExportMsgByDogKey(key);
		return ResultDto.success(result);
	}
}