package com.cku.restful.v1.open;

import com.cku.core.RESTResponse;
import com.cku.core.ZAErrorCode;
import com.cku.core.ZAException;
import com.cku.oa.sys.entity.MemberMobileLog;
import com.cku.oa.sys.entity.user.Member;
import com.cku.oa.sys.entity.user.MemberLimitCount;
import com.cku.oa.sys.service.MemberMobileLogService;
import com.cku.oa.sys.service.SMSRemindService;
import com.cku.oa.sys.service.UserService;
import com.cku.oa.sys.service.user.MemberLimitCountService;
import com.cku.oa.sys.service.user.MemberService;
import com.cku.restful.v1.sys.service.RestIDCardService;
import com.cku.restful.v1.sys.web.BaseRestController;
import com.cku.util.ServletUtils;
import com.thinkgem.jeesite.common.utils.CacheUtils;
import com.thinkgem.jeesite.modules.sys.entity.User;
import com.thinkgem.jeesite.modules.sys.utils.UserUtils;
import net.sf.json.JSONObject;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;

import static com.cku.oa.sys.service.SMSRemindService.TYPE_SMS_BIND_MOBILE;

@Controller
@RequestMapping(value = "/api/v1/safe")
public class BindMobileController extends BaseRestController {
	
	
	@Autowired
	private UserService userService;
	@Autowired
	private MemberService memberService;
	@Autowired
	private SMSRemindService smsRemindService;
	@Autowired
	private RestIDCardService restIDCardService;
	@Autowired
	private MemberLimitCountService memberLimitCountService;
	@Autowired
	private MemberMobileLogService memberMobileLogService;

	/**
	 * @Description： 校验输入的后6位是否与会员数据一致
	 * @author: yuanshuai
	 * @date: 2017/12/20 14:58
	 */
	@RequestMapping(value="/checkIDCard" , method= RequestMethod.POST)
	@ResponseBody
	public void checkUserIDCard(@RequestBody String json, HttpServletResponse response) throws IOException {
		JSONObject object = JSONObject.fromObject(json);
		String idCard = object.getString("idCard");
		if (StringUtils.isBlank(idCard)) {
			throw new ZAException(ZAErrorCode.ZA_ERROR, "校验身份证失败，参数错误请重试");
		}
		Member member = UserUtils.getLoginMember();
		MemberLimitCount memberLimitCount = memberLimitCountService.findByMemberCode(member.getMemberCode());
		if (memberLimitCount != null && memberLimitCount.getCheckIDCardLimit() >= 4) {
			throw new ZAException(ZAErrorCode.ZA_ERROR, "您的错误输入已累计达到4次，无法继续完成安全认证，请联系客服，致电400-660-7000");
		}
		int length = member.getCardNo().length();
		if (!member.getCardNo().substring(length - 6, length).toUpperCase().equals(idCard.toUpperCase())) {
			//匹配失败，记录错误次数
			if (memberLimitCount == null) {
				memberLimitCount = new MemberLimitCount(member.getMemberCode(),1,0);
			}else {
				memberLimitCount.setCheckIDCardLimit(memberLimitCount.getCheckIDCardLimit() + 1);
			}
			memberLimitCountService.save(memberLimitCount);
            String msg = "身份证号码补充错误，请重新输入（还有" + (4 - memberLimitCount.getCheckIDCardLimit()) + "次机会）";
            throw new ZAException(ZAErrorCode.ZA_ERC_LIMIT_COUNT, msg);
		}
		//匹配成功,判断是否实名认证过
		//存缓存，5分钟过期
		CacheUtils.put("fiveMinuteCache", "bindMobile" + member.getMemberCode(), member.getName());
		int flag = 1;
		if (StringUtils.isBlank(member.getAuthentication()) || member.getAuthentication().equals("0")) {
			//进行实名认证
			try {
				flag = restIDCardService.validateIDCard(null, member.getCardNo(), member.getName(),member.getMemberSite(), false);
				if (flag == 1) {
					//修改为已实名认证
					memberService.updateMemberAuthentication(member, "1");
				}
			} catch (Exception e) {
				if (e instanceof ZAException) {
					flag = 0;
				}
			}
		}
		ServletUtils.writeResponse(response, new RESTResponse("authentication", flag));
	}

	/**
	 * @Description： 实名认证身份号
	 * @author: yuanshuai
	 * @date: 2017/12/20 14:58
	 */
	@RequestMapping(value="/validateIDCard" , method=RequestMethod.POST)
	@ResponseBody
	public void validateUserIDCard(@RequestBody String json, HttpServletResponse response) throws IOException {
		JSONObject object = JSONObject.fromObject(json);
		String idCard = object.getString("idCard");
		if (StringUtils.isBlank(idCard)) {
			throw new ZAException(ZAErrorCode.ZA_ERROR, "身份证实名认证失败，参数错误请重试");
		}
		Member member = UserUtils.getLoginMember();
        MemberLimitCount memberLimitCount = memberLimitCountService.findByMemberCode(member.getMemberCode());
        if (memberLimitCount != null && memberLimitCount.getValidateIDCardLimit() >= 4) {
            throw new ZAException(ZAErrorCode.ZA_ERROR, "您的错误输入已累计达到4次，无法继续完成安全认证，请联系客服，致电400-660-7000");
        }
		//取缓存，5分钟过期,判断时间
		String name = (String) CacheUtils.get("fiveMinuteCache", "bindMobile" + member.getMemberCode());
		if (StringUtils.isBlank(name)) {
			throw new ZAException(ZAErrorCode.ZA_ERROR, "页面已过期，请重新进行绑定手机操作");
		}
		//进行实名认证
		int flag = restIDCardService.validateIDCard(null, idCard, member.getName(),member.getMemberSite(), false);
		if (flag == 0) {
            //匹配失败，记录错误次数
            if (memberLimitCount == null) {
                memberLimitCount = new MemberLimitCount(member.getMemberCode(),0,1);
			} else {
				memberLimitCount.setValidateIDCardLimit(memberLimitCount.getValidateIDCardLimit() + 1);
			}
			memberLimitCountService.save(memberLimitCount);
			String msg = "实名认证失败，请核对姓名或身份证号是否正确（还有" + (4 - memberLimitCount.getValidateIDCardLimit()) + "次机会）";
            throw new ZAException(ZAErrorCode.ZA_ERC_LIMIT_COUNT, msg);
		} else {
			//修改为已实名认证
			memberService.updateCardNo(member, idCard, "1");
		}
		ServletUtils.writeResponse(response, new RESTResponse("authentication", flag));
	}

	/**
	 * @Description： 根据当前登录人获取身份证(截取后六位)和姓名
	 * @author: chaixueteng
	 * @date: 2017/12/20 14:58
	 */
	@RequestMapping(value="/memberCardInfo" , method=RequestMethod.GET)
	@ResponseBody
	public void memberCardInfo(HttpServletRequest request, HttpServletResponse response) throws IOException{
		Member member = UserUtils.getLoginMember();
		JSONObject object = new JSONObject();
		object.put("name",member.getName());
		if(StringUtils.isBlank(member.getCardNo())){
			throw new ZAException(ZAErrorCode.ZA_ERROR, "身份证信息不存在!");
		}
		int cardlenth=member.getCardNo().length();
		if(cardlenth<6){
			throw new ZAException(ZAErrorCode.ZA_ERROR, "身份证信息有误!");
		}
		object.put("cardNo",member.getCardNo().substring(0,cardlenth-6));
		ServletUtils.writeResponse(response,new RESTResponse("memberCardInfo", object));
	}

	/**
	 * @Description： 获取短信验证码(绑定手机)
	 * @author: yuanshuai
	 * @date: 2017/12/22 16:00
	 */
	@RequestMapping(value="/sms/bindMobile" , method=RequestMethod.GET)
	@ResponseBody
	public void getSmsCode(HttpServletRequest request, HttpServletResponse response) throws IOException{
		String mobile = request.getParameter("mobile");
		//取缓存，5分钟过期,判断时间
		Member member = UserUtils.getLoginMember();
		String name = (String) CacheUtils.get("fiveMinuteCache", "bindMobile" + member.getMemberCode());
		if (StringUtils.isBlank(name)) {
			throw new ZAException(ZAErrorCode.ZA_ERROR, "页面已过期，请重新进行绑定手机操作");
		}
		//如果未实名认证先实名
		if (StringUtils.isBlank(member.getAuthentication()) || member.getAuthentication().equals("0")) {
			throw new ZAException(ZAErrorCode.ZA_ERROR, "尚未进行实名认证，请先进行实名认证");
		}
		smsRemindService.sendVerifyCode(request, mobile, true, TYPE_SMS_BIND_MOBILE);
		ServletUtils.writeResponse(response, new RESTResponse());
	}

	/**
	 * @Description： 绑定手机号，验证短信验证码
	 * @author: yuanshuai
	 * @date: 2017/12/22 16:01
	 */
	@RequestMapping(value="/smsValidate/bindMobile" , method=RequestMethod.POST)
	@ResponseBody
	public void validateSMS(@RequestBody String json, HttpServletRequest request,HttpServletResponse response) throws IOException{
		JSONObject object = JSONObject.fromObject(json);
		String mobile = object.getString("mobile");
		String key = object.getString("key");
		if (StringUtils.isBlank(mobile) || StringUtils.isBlank(key)) {
			throw new ZAException(ZAErrorCode.ZA_ERROR, "验证码错误，请重试");
		}
		//取缓存，5分钟过期,判断时间
		Member member = UserUtils.getLoginMember();
		String name = (String) CacheUtils.get("fiveMinuteCache", TYPE_SMS_BIND_MOBILE + member.getMemberCode());
		if (StringUtils.isBlank(name)) {
			throw new ZAException(ZAErrorCode.ZA_ERROR, "页面已过期，请重新进行绑定手机操作");
		}
		//如果未实名认证先实名
		if (StringUtils.isBlank(member.getAuthentication()) || member.getAuthentication().equals("0")) {
			throw new ZAException(ZAErrorCode.ZA_ERROR, "尚未进行实名认证，请先进行实名认证");
		}
		User user = UserUtils.getLoginUser();
		//获取缓存的验证码
		if (smsRemindService.checkVerifyCode(mobile,key)) {
			//验证成功
			//绑定安全手机
			//修改绑定手机和安全手机
			userService.updateBindMobile(user, mobile);
			memberService.updateMemberSafeMobile(member, mobile);
			//记录会员手机变更日志
			memberMobileLogService.saveMobileLog(member.getMemberCode(), MemberMobileLog.MOBILE_TYPE_BIND, null, mobile);
			RESTResponse result = new RESTResponse();
			ServletUtils.writeResponse(response, result);
		} else {
			//验证失败
			RESTResponse result = new RESTResponse(ZAErrorCode.ZA_ERROR, "验证短信失败");
			ServletUtils.writeResponse(response, result);
		}
	}

}