package com.cku.restful.v1.groomer.service;

import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.cku.core.PageBeanResult;
import com.cku.core.RESTResponse;
import com.cku.core.ZAErrorCode;
import com.cku.core.ZAException;
import com.cku.oa.finance.entity.PaymentCart;
import com.cku.oa.finance.entity.PaymentChargingItem;
import com.cku.oa.finance.service.PaymentCartService;
import com.cku.oa.finance.service.PaymentChargingItemService;
import com.cku.oa.groomer.entity.GroomerPackage;
import com.cku.oa.groomer.service.GroomerPackageService;
import com.cku.oa.sys.entity.user.CardTypeEnum;
import com.cku.oa.sys.entity.user.Member;
import com.cku.restful.v1.groomer.model.RestGroomerPackage;
import com.cku.restful.v1.groomer.vo.GroomerPackageVO;
import com.cku.restful.v1.sys.utils.BeanUtil;
import com.thinkgem.jeesite.common.persistence.Page;
import com.thinkgem.jeesite.common.utils.IdGen;
import com.thinkgem.jeesite.modules.sys.utils.UserUtils;

@Service
@Transactional(readOnly = true)

public class RestGroomerPackageService {

	@Autowired
	private PaymentChargingItemService paymentChargingItemService;
	@Autowired
	private GroomerPackageService groomerPackageService;
	@Autowired
	private PaymentCartService paymentCartService;

	private static final String PAYMENTCHARGINGITEM_GROOMER_PACKAGE = "groomer_package@0";

	@Transactional(readOnly = false)
	public RESTResponse post(String json) {
		// 获取参数
		RestGroomerPackage vo = BeanUtil.toBean(json, RestGroomerPackage.class);
		// 参数校验
		validateParameter(vo);
		// 构造持久对象
		GroomerPackage po = buildPo(vo);
		// 业务校验
		// 0:"普卡" 10: "银卡" 20:"金卡" 30:"铂金卡" 40:"紫金卡"
		if (CardTypeEnum.DEFAULT_CARD.code() == UserUtils.getMemberCardType(UserUtils.getLoginMember().getMemberCode()))
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "CKU宠爱银卡及以上会员才可以办理！");

		// 写入业务表
		groomerPackageService.save(po);
		// 写入购物车
		String businessOrderCode = IdGen.uuid();
		PaymentCart paymentCart = buildPaymentCart(po);
		paymentCart.setBusinessOrderCode(businessOrderCode);
		paymentCartService.addToCart(paymentCart, "1080");
		return new RESTResponse("data", paymentCart.getId());
	}

	private void validateParameter(RestGroomerPackage vo) {
		if (StringUtils.isBlank(vo.getName()) || StringUtils.isBlank(vo.getMobile())
		// || StringUtils.isBlank(vo.getProvince()) || StringUtils.isBlank(vo.getCity())
		// || StringUtils.isBlank(vo.getArea()) || StringUtils.isBlank(vo.getStreet())
		// || StringUtils.isBlank(vo.getAddress())
				|| StringUtils.isBlank(vo.getCardNo())) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "会员信息全部必填");
		}
		// 正则判断身份证号是否符合规则
		if (!isIDcard(vo.getCardNo())) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "身份证号码格式错误！");
		}
		if (StringUtils.isBlank(vo.getAvatar())) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "照片未上传");
		}
		if (StringUtils.isBlank(vo.getDogBreed())) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "种类未填");
		}
		if (StringUtils.isBlank(vo.getSchoolNameCn())) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "培训机构未填");
		}
	}

	/**
	 * 验证输入身份证号
	 *
	 * @param str
	 *            待验证的字符串
	 * @return 如果是符合格式的字符串, 返回true, 否则为false
	 */
	public boolean isIDcard(String str) {
		String regex = "(^[1-9]\\d{5}(18|19|([23]\\d))\\d{2}((0[1-9])|(10|11|12))(([0-2][1-9])|10|20|30|31)\\d{3}[0-9Xx]$)|(^[1-9]\\d{5}\\d{2}((0[1-9])|(10|11|12))(([0-2][1-9])|10|20|30|31)\\d{2}$)";
		Pattern pattern = Pattern.compile(regex);
		Matcher matcher = pattern.matcher(str);
		return matcher.matches();
	}

	private GroomerPackage buildPo(RestGroomerPackage vo) {
		Member member = UserUtils.getLoginMember();
		PaymentChargingItem paymentChargingItem = paymentChargingItemService
				.getByShortName(PAYMENTCHARGINGITEM_GROOMER_PACKAGE);
		GroomerPackage po = new GroomerPackage();
		po.setMobile(vo.getMobile());
		po.setName(vo.getName());
		po.setCardNo(vo.getCardNo());
		po.setProvince(vo.getProvince());
		po.setCity(vo.getCity());
		po.setArea(vo.getArea());
		po.setStreet(vo.getStreet());
		po.setAddress(vo.getAddress());
		po.setDogBreed(vo.getDogBreed());
		po.setAvatar(vo.getAvatar());
		po.setMemberCode(member.getMemberCode());
		po.setSchoolNameCn(vo.getSchoolNameCn());
		po.setOrderPrice(paymentChargingItem.getPrice());
		po.setPaymentState("1");
		po.setShowLevel("CKU ONLINE C级");
		po.setPaymentChargingItemId(paymentChargingItem.getId());
		Integer a = groomerPackageService.getMaxApplyCode();
		StringBuffer applyCode = new StringBuffer("OL-");
		if (a == null)
			applyCode.append("00001");
		else {
			a += 1;
			for (int i = 0; i < 5 - a.toString().length(); i++) {
				applyCode.append("0");
			}
			applyCode.append(a.toString());
		}
		po.setApplyCode(applyCode.toString());
		return po;
	}

	private PaymentCart buildPaymentCart(GroomerPackage po) {
		PaymentCart paymentCart = new PaymentCart();
		PaymentChargingItem paymentChargingItem = paymentChargingItemService.get(po.getPaymentChargingItemId());
		paymentCart.setChargingItemId(paymentChargingItem.getId());
		paymentCart.setChargingItemName(paymentChargingItem.getName());
		paymentCart.setNum("1");
		paymentCart.setPrice(po.getOrderPrice());
		paymentCart.setTotalPrice(po.getOrderPrice());
		paymentCart.setBusinessTable("groomer_package");
		paymentCart.setBusinessIds(po.getId());
		return paymentCartService.addBusinessManage(paymentCart, "1080");// 所属业务类型
	}

	@Transactional(readOnly = false)
	public RESTResponse myList(HttpServletRequest request, HttpServletResponse response) {
		Page<GroomerPackage> page = new Page<GroomerPackage>(request, response);
		Member member = UserUtils.getLoginMember();
		GroomerPackage groomerPackage = new GroomerPackage();
		groomerPackage.setMemberCode(member.getMemberCode());
		groomerPackage.setDelFlag("0");
		groomerPackage.setPaymentState("2");
		groomerPackage.setPage(page);
		Page<GroomerPackage> result = groomerPackageService.findPage(page, groomerPackage);
		List<GroomerPackageVO> list = result.getList().stream().map(a -> {
			GroomerPackageVO vo = new GroomerPackageVO();
			BeanUtils.copyProperties(a, vo);
			return vo;
		}).collect(Collectors.toList());
		return new RESTResponse("data", new PageBeanResult<GroomerPackageVO>(list, result.getCount()));
	}
}
