/**
 * Copyright &copy; 2012-2014 <a href="https://github.com/thinkgem/jeesite">JeeSite</a> All rights reserved.
 */
package com.cku.restful.v1.groomer.model;

import org.hibernate.validator.constraints.Length;

/**
 * 美容师资格证书Entity
 * @author cxt
 * @version 2016-07-22
 */
public class RestGroomerQualificationCertificate {
	
	private String memberCode;		// 会员号
	private String name;		// 姓名
	private String levelCn;		// 级别中文
	private String levelEn;		// 级别英文
	private String certificateCode;		// 证书编号
	private String corsage; //胸花
	
	private String takeCertificateDate;		// 取证日期



	@Length(min=1, max=100, message="会员号长度必须介于 1 和 100 之间")
	public String getMemberCode() {
		return memberCode;
	}

	public void setMemberCode(String memberCode) {
		this.memberCode = memberCode;
	}
	
	@Length(min=0, max=64, message="姓名长度必须介于 0 和 64 之间")
	public String getName() {
		return name;
	}

	public void setName(String name) {
		this.name = name;
	}
	


	

	@Length(min=0, max=64, message="级别中文长度必须介于 0 和 64 之间")
	public String getLevelCn() {
		return levelCn;
	}

	public void setLevelCn(String levelCn) {
		this.levelCn = levelCn;
	}
	
	@Length(min=0, max=64, message="级别英文长度必须介于 0 和 64 之间")
	public String getLevelEn() {
		return levelEn;
	}

	public void setLevelEn(String levelEn) {
		this.levelEn = levelEn;
	}
	
	@Length(min=0, max=64, message="证书编号长度必须介于 0 和 64 之间")
	public String getCertificateCode() {
		return certificateCode;
	}

	public void setCertificateCode(String certificateCode) {
		this.certificateCode = certificateCode;
	}
	

	
	@Length(min=0, max=64, message="胸花长度必须介于 0 和 64 之间")
	public String getCorsage() {
		return corsage;
	}

	public void setCorsage(String corsage) {
		this.corsage = corsage;
	}

	public String getTakeCertificateDate() {
		return takeCertificateDate;
	}

	public void setTakeCertificateDate(String takeCertificateDate) {
		this.takeCertificateDate = takeCertificateDate;
	}
	

}