package com.cku.restful.v1.earnest.web;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.cku.core.RESTResponse;
import com.cku.oa.earnest.vo.entity.EarnestList;
import com.cku.oa.earnest.vo.entity.EarnestListItem;
import com.cku.oa.earnest.vo.entity.EarnestMoney;
import com.cku.oa.finance.entity.PaymentChargingItem;
import com.cku.oa.finance.service.PaymentChargingItemService;
import com.cku.oa.sys.entity.user.Member;
import com.cku.restful.v1.earnest.service.RestEarnestMoneyService;
import com.cku.restful.v1.earnest.vo.EarnestListItemVo;
import com.cku.restful.v1.earnest.vo.EarnestListVo;
import com.cku.util.ServletUtils;
import com.thinkgem.jeesite.common.web.BaseController;
import com.thinkgem.jeesite.modules.sys.utils.UserUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;

@Controller
@RequestMapping(value = "/api/v1/earnest")
public class RestEarnestMoneyController  extends BaseController {

    @Autowired
    RestEarnestMoneyService restEarnestMoneyService;
    @Autowired
    PaymentChargingItemService paymentChargingItemService;


    @RequestMapping(value = "list", method = RequestMethod.GET)
    @ResponseBody
    public RESTResponse getList(HttpServletResponse response){
        List<EarnestListVo> result = new ArrayList<>();
        List<EarnestList> listByGroup = restEarnestMoneyService.findListByGroup();
        listByGroup.stream().forEach(e->{
            EarnestListVo earnestListVo = new EarnestListVo();
            BeanUtils.copyProperties(e, earnestListVo);
            //查询
            List<EarnestListItem> list = restEarnestMoneyService.findList(e.getBrand());
            List<EarnestListItemVo> earnestListItemVos = new ArrayList<>();
            list.forEach(a ->{
                EarnestListItemVo earnestListItemVo = new EarnestListItemVo();
                BeanUtils.copyProperties(a, earnestListItemVo);
                earnestListItemVos.add(earnestListItemVo);
            });
            earnestListVo.setEarnestListItemVos(earnestListItemVos);
            result.add(earnestListVo);
        });
        String imgurl = "http://upyun.chongaibao.com/cab_test/image/avatar/1305695318112768001.jpg";
        PaymentChargingItem paymentChargingItem = paymentChargingItemService.getByShortName(RestEarnestMoneyService.EARNESTMONEY);
        return new RESTResponse("rel",result,"img",imgurl,"price",paymentChargingItem.getPrice());
    }



    /**
     * 诚意金表单接口
     * @param response
     * @throws IOException
     */
    @RequestMapping(value = "", method = RequestMethod.POST)
    @ResponseBody
    public void post(HttpServletResponse response,@RequestBody  String json) throws IOException, ParseException {

        //判断系统时间
//        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
//        Date parse = simpleDateFormat.parse("2020-09-22 00:00:00");
//        Calendar begin = Calendar.getInstance();
//        begin.setTime(parse);
//        Calendar end = Calendar.getInstance();
//        end.setTime(new Date());
//        if (end.after(begin)) {
//            throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "诚意金活动以关闭，无法提交！！！");
//        }
        //解析数据
        JSONArray earnestArray = JSON.parseArray(json);
        List<EarnestMoney> list = new ArrayList<>();
        //会员号
        Member loginMember = UserUtils.getLoginMember();
        //封装数据
        for(int i=0;i<earnestArray.size();i++){
            EarnestMoney earnestMoney = new EarnestMoney();
            String brand = earnestArray.getJSONObject(i).getString("brand");
            String number = earnestArray.getJSONObject(i).getString("number");
            String product = earnestArray.getJSONObject(i).getString("product");
            String follow = earnestArray.getJSONObject(i).getString("follow");
            earnestMoney.preInsert();
            earnestMoney.setBrand(brand);
            earnestMoney.setFollow(follow);
            earnestMoney.setProduct(product);
            earnestMoney.setNumber(number);
            earnestMoney.setMemberCode(loginMember.getMemberCode());
            list.add(earnestMoney);
        }

        //生成订单
        JSONObject jsonObject = restEarnestMoneyService.toOrder(list, loginMember);

        ServletUtils.writeResponse(response, new RESTResponse("data", jsonObject));
    }


}
