package com.cku.restful.v1.dog.web;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.validation.Valid;

import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

import com.cku.core.PageBeanResult;
import com.cku.core.RESTResponse;
import com.cku.core.ResultDto;
import com.cku.core.ZAErrorCode;
import com.cku.core.ZAException;
import com.cku.oa.dog.dao.DogTypeDao;
import com.cku.oa.dog.entity.DogType;
import com.cku.oa.sys.service.LoginServerService;
import com.cku.restful.v1.dog.model.RestDogType;
import com.cku.restful.v1.dog.service.RestDogColorMarkService;
import com.cku.restful.v1.dog.vo.DogTypeCheckRequset;
import com.cku.restful.v1.dog.vo.DogTypeCheckResponse;
import com.cku.restful.v1.sys.web.BaseRestController;
import com.cku.util.ServletUtils;
import com.google.common.collect.Lists;

import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;

/**
 * 犬种Controller
 *
 * @author fanhuibin
 * @version 2016-08-22
 */
@Controller
@RequestMapping(value = "/api/v1/dog/dogtype")
public class RestDogTypeController extends BaseRestController {

	@Autowired
	private DogTypeDao dogTypeDao;
	@Autowired
	public LoginServerService loginServerService;
	@Autowired
	private RestDogColorMarkService restDogColorMarkService;

	@RequestMapping(value = "", method = RequestMethod.GET)
	@ResponseBody
	public void getList(HttpServletResponse response) throws IOException {
		List<DogType> result = dogTypeDao.findAllList(new DogType());
		List<RestDogType> list = Lists.newArrayList();
		result.forEach(dogType -> {
			list.add(new RestDogType(dogType));
		});
		Long totalCount = (long) list.size();
		ServletUtils.writeResponse(response,
				new RESTResponse("list", new PageBeanResult<RestDogType>(list, totalCount)));
	}

	@ApiOperation(value = "视频鉴定-品种列表", tags = { "视频鉴定-zxy" })
	@ApiImplicitParams({
			@ApiImplicitParam(name = "memberCode", paramType = "query", value = "memberCode"),
			@ApiImplicitParam(name = "breedCnName", paramType = "query", value = "中文名")
	})
	@ApiResponses({ @ApiResponse(code = 0, message = "{\n" + "    \"rc\":0,\n" + "    \"msg\":\"OK\",\n"
			+ "    \"list\":[\n" + "        {\n" + "            \"dogBreedCode\":\"NB04\",\n"
			+ "            \"pinyin\":\"zhong4\",\n" + "            \"breedCnName\":\"重庆犬\",\n"
			+ "            \"id\":\"5ceba89afbba42a9bd729eb3e40526c7\"\n" + "        }\n" + "    ],\n"
			+ "    \"total\":367\n" + "}") })
	@RequestMapping(value = "getListByMemberCode", method = RequestMethod.GET)
	@ResponseBody
	public void getListByMemberCode(HttpServletResponse response, HttpServletRequest reuqest) throws IOException {
		String memberCode = reuqest.getParameter("memberCode");
		String breedCnName = reuqest.getParameter("breedCnName");

		DogType  param = new DogType();
//		if (StringUtils.isEmpty(memberCode)) {
//			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "memberCode为空");
//		}
		param.setBreedCnName(breedCnName);
		if (StringUtils.isNotBlank(memberCode) && memberCode.toUpperCase().contains("MC")) {
			param.setMemberCodeFlag("MC");
		} else if (StringUtils.isNotBlank(memberCode) && memberCode.toUpperCase().contains("DC")) {
			param.setMemberCodeFlag("DC");
		} else if(StringUtils.isNotBlank(memberCode)){
			param.setMemberCodeFlag("UC");
		}
		List<DogType> result = dogTypeDao.findFormalAndNBList(param);
		List<RestDogType> list = Lists.newArrayList();
		result.forEach(dogType -> {
			list.add(new RestDogType(dogType));
		});
		Long totalCount = (long) list.size();
		ServletUtils.writeResponse(response,
				new RESTResponse("list", new PageBeanResult<RestDogType>(list, totalCount)));
	}

	/**
	 *
	 * @Description：根据犬种获取毛色列表
	 * @author: zhuoHeng
	 * @version: 2017年1月4日 下午3:17:50
	 */

	@ApiOperation(value = "视频鉴定-毛色列表", tags = { "视频鉴定-zxy" })
	@ApiResponses({ @ApiResponse(code = 0, message = "") })
	@RequestMapping(value = "/getColorMessageByBreedCode/{breedCode}", method = RequestMethod.GET)
	@ResponseBody
	public void getColorMessageByBreedCode(
			@ApiParam(name = "犬种code", value = "breedCode") @PathVariable("breedCode") String breedCode,
			HttpServletResponse response) throws IOException {
		RESTResponse result = restDogColorMarkService.getList(breedCode);
		ServletUtils.writeResponse(response, result);
	}

	@ApiOperation(value = "验证犬只", tags = { "验证犬只-zxy" })
	@RequestMapping(value = "/checkDogType", method = RequestMethod.POST)
	@ResponseBody
	public ResultDto<DogTypeCheckResponse> getColorMessageByBreedCode(@Valid @RequestBody DogTypeCheckRequset req,
			HttpServletResponse response) throws IOException {
		String memberCode = req.getMemberCode();
		boolean matching = true;
		if (StringUtils.isNotEmpty(memberCode) ) {
			String dogCode = req.getDogCode();
			if(memberCode.contains("DC") && !dogCode.equals("292")) {
				throw new ZAException(ZAErrorCode.ZA_ERC_UNKNOWN, "犬种类型和会员类型不匹配");
			} else if(memberCode.contains("MC") && !dogCode.equals("15C")) {
				throw new ZAException(ZAErrorCode.ZA_ERC_UNKNOWN, "犬种类型和会员类型不匹配");
			} else if (isNumeric(memberCode)) {
				if (dogCode.equals("292") || dogCode.equals("15C")) {
					throw new ZAException(ZAErrorCode.ZA_ERC_UNKNOWN, "犬种类型和会员类型不匹配");
				}
			}
		}
		DogTypeCheckResponse resp = new DogTypeCheckResponse();
		resp.setMatching(matching);

		return  ResultDto.success(resp);
	}

	public boolean isNumeric(String str){
        Pattern pattern = Pattern.compile("[0-9]*");
        Matcher isNum = pattern.matcher(str);
        if( !isNum.matches() ){
            return false;
        }
        return true;
	}


	@RequestMapping(value = "/fci", method = RequestMethod.GET)
	@ResponseBody
	public void getFciList(HttpServletResponse response) throws IOException {
		DogType example = new DogType();
		example.setBreedClassList(Arrays.asList("formal", "temp","country"));
		// 根据当前登录是否杜高会员来判断个人狗列表是杜高犬还是CKU犬
		if (StringUtils.isBlank(example.getDogBreedCode())) {
			// 根据当前登录端查询犬种
			example.getSqlMap().put("dogBreedMap", loginServerService.dataScopeFilter());
		} else {
			example.getSqlMap().put("dogBreedMap", " ='" + example.getDogBreedCode() + "'");
		}
		List<DogType> result = dogTypeDao.findList(example);
		List<RestDogType> list = Lists.newArrayList();
		result.forEach(dogType -> {
			list.add(new RestDogType(dogType));
		});
		Long totalCount = (long) list.size();
		ServletUtils.writeResponse(response,
				new RESTResponse("list", new PageBeanResult<RestDogType>(list, totalCount)));
	}

}