package com.cku.restful.v1.dog.web;

import com.cku.core.RESTResponse;
import com.cku.restful.v1.dog.service.RestDogActivationService;
import com.cku.restful.v1.sys.web.BaseRestController;
import com.cku.util.ServletUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;

/**
 * 犬只激活Controller
 *
 * @author lgl
 * @version 2018-06-12
 */
@Controller
@RequestMapping(value = "/api/v1/dog")
public class RestDogActivationController extends BaseRestController {

    @Autowired
    private RestDogActivationService service;

    @RequestMapping(value = "/dogActivation/getDogInfo/{birthCode}", method = RequestMethod.GET)
    public void getDogInfo(@PathVariable("birthCode") String birthCode, HttpServletResponse response)
            throws IOException {
        RESTResponse result = service.getDogInfo(birthCode);
        ServletUtils.writeResponse(response, result);
    }

    @RequestMapping(value = "/dogActivation", method = RequestMethod.GET)
    public void get(HttpServletRequest request, HttpServletResponse response)
            throws IOException {
        RESTResponse result = service.get(request);
        ServletUtils.writeResponse(response, result);
    }

    @RequestMapping(value = "/dogActivation", method = RequestMethod.POST)
    public void post(@RequestBody String json, HttpServletResponse response)
            throws IOException {
        RESTResponse result = service.post(json);
        ServletUtils.writeResponse(response, result);
    }
    @RequestMapping(value = "/dogActivation", method = RequestMethod.PUT)
    public void put(@RequestBody String json, HttpServletResponse response)
            throws IOException {
        RESTResponse result = service.put(json);
        ServletUtils.writeResponse(response, result);
    }
    @RequestMapping(value = "/dogActivation/isHaveOrder", method = RequestMethod.GET)
    public void isHaveOrder(String birthCode, HttpServletResponse response)
            throws IOException {
        RESTResponse result = service.isHaveOrder(birthCode);
        ServletUtils.writeResponse(response, result);
    }

    /**
     * 上架下架
     * @param
     * @param response
     * @throws IOException
     */
    @RequestMapping(value = "/dogActivation/upDown", method = RequestMethod.POST)
    @ResponseBody
    public void upDown(@RequestBody String json, HttpServletResponse response) throws IOException {
        RESTResponse result = null;
        try {
            result = service.upDown(json);
        } catch (Exception e) {
            result = new RESTResponse(-1,e.getMessage());
        }
        ServletUtils.writeResponse(response, result);
    }
}
