package com.cku.restful.v1.customer.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;

import net.sf.json.JSONObject;

import com.cku.restful.v1.customer.entity.Button;
import com.cku.restful.v1.customer.entity.CommonButton;
import com.cku.restful.v1.customer.entity.ComplexButton;
import com.cku.restful.v1.customer.entity.Menu;
import com.cku.restful.v1.customer.entity.ViewButton;
import com.cku.restful.v1.customer.web.TokenController;

public class MenuUtil {
	/**
	 * 	创建自定义菜单(每天限制1000次)
	 * */
	public static int createMenu(Menu menu){
		String jsonMenu=JSONObject.fromObject(menu).toString();
		System.out.println(jsonMenu);
		int status=0;
		JSONObject accessToken = TokenController.getAccessToken(TokenController.appID, TokenController.appScret);
		String token = accessToken.getString("access_token");
		String path="https://api.weixin.qq.com/cgi-bin/menu/create?access_token="+token;
		try {
			URL url=new URL(path);
			HttpURLConnection http = (HttpURLConnection)url.openConnection();
			http.setDoOutput(true);
			http.setDoInput(true);
			http.setRequestMethod("POST");
			http.setRequestProperty("Content-Type","application/x-www-form-urlencoded");
			http.connect();
			OutputStream os = http.getOutputStream();
			os.write(jsonMenu.getBytes("UTF-8"));
			os.close();

			InputStream is = http.getInputStream();
			int size = is.available();
			byte[] bt = new byte[size];
			is.read(bt);
			String message=new String(bt,"UTF-8");
			JSONObject jsonMsg = JSONObject.fromObject(message);
			status = Integer.parseInt(jsonMsg.getString("errcode"));
		} catch (MalformedURLException e) {
			e.printStackTrace();
		} catch (IOException e) {
			e.printStackTrace();
		}
		return status;
	}



	/**
	 * 		封装菜单数据
	 * */
	public static Menu getMenu(){
		//往期精选
		String wqjx="http://mp.weixin.qq.com/mp/homepage?__biz=MzIwMzI5Mjk5NQ==&hid=1&sn=16c034095130eefc08e896693ae6191b#wechat_redirect";
		//照片征集
		//String zpzj="http://mp.weixin.qq.com/s/6uLcMF1sRVSFq0hvQb1ohQ";
		//关于我们
		//String gywm="http://mp.weixin.qq.com/s/PnRSSw4Nkzwl3zSZDau4BA";
		//宠爱王国官网
		String cku="http://cku.org.cn/";
		//猫协官网
		String catUrl="http://www.icat.org.cn/ccca/";
		//CSV官网
		String csvUrl="http://www.csvclub.org/";
		//宠物保险
		//String cwbx="http://vip.chongaibao.com/wx/pay/wxLoginSimple.php?type=insurance&dir=insurance/wxLogin";
		//宠物保险
		String cwbx="http://insurance.chongaibao.com/insurance/insurancewx/query.html";
		//号内搜
		String hns="http://data.newrank.cn/m/s.html?s=OygrPSw/Ojs_";




		ViewButton cb_1 = new ViewButton();
		cb_1.setName("CSV官网");
		cb_1.setType("view");
		cb_1.setUrl(csvUrl);
		ViewButton cb_2 = new ViewButton();
		cb_2.setName("猫协官网");
		cb_2.setType("view");
		cb_2.setUrl(catUrl);
		ViewButton cb_3 = new ViewButton();
		cb_3.setName("CKU官网");
		cb_3.setType("view");
		cb_3.setUrl(cku);
		ComplexButton cx_1 = new ComplexButton();
		cx_1.setName("官方合作");
		cx_1.setSub_button(new Button[]{cb_3,cb_1,cb_2});

		CommonButton vb = new CommonButton();
		vb.setName("APP下载");
		vb.setType("click");
		vb.setKey("APP");
		ViewButton vb_4 = new ViewButton();
		vb_4.setName("保险查询");
		vb_4.setType("view");
		vb_4.setUrl(cwbx);
		ComplexButton cx_2 = new ComplexButton();
		cx_2.setName("宠爱王国");
		cx_2.setSub_button(new Button[]{vb,vb_4});

		ViewButton cb_6 = new ViewButton();
		cb_6.setName("号内搜");
		cb_6.setType("view");
		cb_6.setUrl(hns);
		ViewButton cb_7 = new ViewButton();
		cb_7.setName("往期精选");
		cb_7.setType("view");
		cb_7.setUrl(wqjx);
		ComplexButton cx_3 = new ComplexButton();
		cx_3.setName("历史文章");
		cx_3.setSub_button(new Button[]{cb_6,cb_7});

		Menu menu=new Menu();
		menu.setButton(new ComplexButton[]{cx_1,cx_2,cx_3});

		return menu;
	}
}
