package com.cku.oa.timedtask.entity;

import java.io.Serializable;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;

import org.apache.commons.lang3.StringUtils;

import com.cku.format.LocalDateTimeDeserializer;
import com.cku.format.LocalDateTimeSerializer;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;

import lombok.Data;

@Data
public class EmployeeLeaveInfo implements Serializable {

	private static final long serialVersionUID = -6933879478020623008L;

	private String name;

	@JsonSerialize(using = LocalDateTimeSerializer.class)
	@JsonDeserialize(using = LocalDateTimeDeserializer.class)
	private LocalDateTime startTime;

	@JsonSerialize(using = LocalDateTimeSerializer.class)
	@JsonDeserialize(using = LocalDateTimeDeserializer.class)
	private LocalDateTime endTime;

	private String userId;

	public String assembleMsg() {
		// 年假 上午/下午 区分时段 从 12:00 调整到 13:45 
		LocalDateTime noon = LocalDateTime.of(LocalDate.now(), LocalTime.of(13, 45));
		String period = null;
		if (startTime.isBefore(noon) && endTime.isAfter(noon)) {
			period = "全天";
		} else if (startTime.isBefore(noon) && (endTime.isBefore(noon) || endTime.isEqual(noon))) {
			period = "上午";
		} else if ((startTime.isAfter(noon) || startTime.isEqual(noon)) && endTime.isAfter(noon)) {
			period = "下午";
		}
		if (StringUtils.isNotEmpty(period)) {
			return String.format("%s：%s %s\n", name, LocalDate.now(), period);
		} else {
			return String.format("%s:%s-%s %s:%s至%s-%s %s:%s\n", name,
					StringUtils.rightPad(String.valueOf(startTime.getMonthValue()), 2, "0"),
					StringUtils.rightPad(String.valueOf(startTime.getDayOfMonth()), 2, "0"),
					StringUtils.rightPad(String.valueOf(startTime.getHour()), 2, "0"),
					StringUtils.rightPad(String.valueOf(startTime.getMinute()), 2, "0"),
					StringUtils.rightPad(String.valueOf(endTime.getMonthValue()), 2, "0"),
					StringUtils.rightPad(String.valueOf(endTime.getDayOfMonth()), 2, "0"),
					StringUtils.rightPad(String.valueOf(endTime.getHour()), 2, "0"),
					StringUtils.rightPad(String.valueOf(endTime.getMinute()), 2, "0"));
		}

	}

}
