package com.cku.oa.sys.request;

import java.io.Serializable;

import javax.validation.constraints.Pattern;

import org.hibernate.validator.constraints.NotEmpty;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

@Data
@ApiModel
public class MemberRestPwdRequest implements Serializable {

	private static final long serialVersionUID = 8826640510807599274L;

	@NotEmpty(message = "会员ID不能为空")
	@ApiModelProperty(value = "会员ID")
	private String id;

	@NotEmpty(message = "登录账号ID不能为空")
	@ApiModelProperty(value = "登录账号ID")
	private String userId;

	@NotEmpty(message = "会员编号不能为空")
	@ApiModelProperty(value = "会员编号")
	private String memberCode;

	@NotEmpty(message = "是否发送短信不能为空")
	@ApiModelProperty(value = "是否发送短信")
	private String sendSmsFlag;

	@Pattern(regexp = "^[1]{1}[0-9]{10}$", message = "手机号格式错误")
	@ApiModelProperty(value = "接收号码")
	private String receiveMobile;

}
