package com.cku.oa.sys.coupon.service;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.cku.oa.sys.coupon.dao.SysGiftDao;
import com.cku.oa.sys.coupon.entity.SysGift;
import com.cku.oa.sys.entity.user.Member;
import com.thinkgem.jeesite.common.persistence.Page;
import com.thinkgem.jeesite.common.service.CrudService;
import com.thinkgem.jeesite.common.utils.DateUtils;

/**
 */
@Service
@Transactional(readOnly = true)
public class SysGiftService extends CrudService<SysGiftDao, SysGift> {

	public SysGift get(String id) {
		return super.get(id);
	}

	public List<SysGift> findList(SysGift sysGift) {
		return super.findList(sysGift);
	}

	public Page<SysGift> findPage(Page<SysGift> page, SysGift sysGift) {
		return super.findPage(page, sysGift);
	}

	public void save(SysGift sysGift) {
		super.save(sysGift);
	}

	@Transactional(readOnly = false)
	public void save(String memberCode,String giftName,BigDecimal facePrice,String url,String source,
			Date effDate,Date validDate,String giftType) {
		SysGift sysGift = new SysGift();
		sysGift.setMemberCode(memberCode);
		sysGift.setGiftName(giftName);
		sysGift.setFacePrice(facePrice);
		sysGift.setUrl(url);
		sysGift.setSource(source);
		sysGift.setEffectiveDate(effDate);
		sysGift.setValidDate(validDate);
		sysGift.setGiftType(giftType);
		sysGift.setUsestate("0");
		super.save(sysGift);
	}

	/**
	 * 获取一个未赠送的礼包
	 */
//	public SysGift getNext() {
//		return dao.getNext();
//	}

	/**
	 * 赠送礼包
	 */
//	@Transactional(readOnly = false)
//	public int giveGift(SysGift sysGift) {
//		return dao.giveGift(sysGift);
//	}

}