package com.cku.oa.statistics.dao;

import java.util.Date;
import java.util.List;
import java.util.Map;

import org.apache.ibatis.annotations.Param;

import com.thinkgem.jeesite.common.persistence.annotation.MyBatisDao;

/**
 * 狗信息统计的数据库查询
 * @author fanhuibin
 *
 */
@MyBatisDao
public interface DogStatisticsDao {
	
	/**
	 * 查询全国的犬只总数
	 */
	public List<Map> countByRegion(@Param("province") String province,@Param("startDate") String startdate, @Param("endDate") String enddate, @Param("pageSize") int pageSize, @Param("startNum") int startNum);
	
	/**
	 * 查询单个地区的犬只总数
	 */
	public List<Map> countByRegionBreed(@Param("province") String province,@Param("startDate") String startdate, @Param("endDate") String enddate);
	
	/**
	 * 查询单个地区的单犬种会员犬只总数
	 */
	public List<Map> countByRegionBreedOwner(@Param("province") String province,@Param("breed") String breed,@Param("startDate") String startdate, @Param("endDate") String enddate);

	/**
	 * 犬只信息统计地区，时间，跟个统计 按会员号
	 */
	public List<Map> countByRegionTypeOwner(@Param("province") String province,@Param("type") String type,@Param("startDate") String startdate, @Param("endDate") String enddate);
	/**
	 * 查询各个地区配种证明
	 */
	public List<Map> countBreedCertified(@Param("province") String province,@Param("startDate") String startdate, @Param("endDate") String enddate);
	
	/**
	 * 查询全国地区出生证明
	 */	
	public List<Map> countBirthCertificate(@Param("province") String province,@Param("startDate") String startdate, @Param("endDate") String enddate);
	
	/**
	 * 查询单一地区会员出生证明
	 */	
	public List<Map> countBirthCertificateOwner(@Param("province") String province,@Param("startDate") String startdate, @Param("endDate") String enddate);

}
