package com.cku.oa.showRefereeDelegate.entity;

import java.util.Arrays;

/**
 * @author yuanshuai
 * @date 2021/2/3 14:19
 */
public enum ShowRegionEnum {

	/**
	 * 无大区
	 */
	NONE("无", 0),
	/**
	 * 华南
	 */
	SouthChina("华南", 1),
	/**
	 * 东北
	 */
	NorthEast("东北", 2),
	/**
	 * 华西
	 */
	WestChina("华西", 3),
	/**
	 * 华北
	 */
	NorthChina("华北", 4),
	/**
	 * 华东
	 */
	EastChina("华东", 5),
	/**
	 * 华中
	 */
	CentralChina("华中", 6);

	/**
	 * 名称
	 */
	private String name;
	/**
	 * 编号
	 */
	private Integer code;

	ShowRegionEnum(String name, Integer code) {
		this.name = name;
		this.code = code;
	}

	/**
	 * 根据名称获取大区枚举
	 *
	 * @author yuanshuai
	 * @date 2021/2/25 17:47
	 */
	public static ShowRegionEnum getShowRegionByNameCn(String name) {
		for (ShowRegionEnum showRegionEnum : values()) {
			if (showRegionEnum.name.equals(name)) {
				return showRegionEnum;
			}
		}
		return null;
	}

	/**
	 * 根据编号获取枚举对象
	 *
	 * @param code 大区编号
	 * @return
	 */
	public static ShowRegionEnum getShowRegionByCode(Integer code) {
		return Arrays.stream(values()).filter(regionEnum -> regionEnum.code.equals(code)).findFirst().orElse(null);
	}

	public String getName() {
		return name;
	}

	public Integer getCode() {
		return code;
	}
}
