package com.cku.oa.showRefereeDelegate.entity;

import com.thinkgem.jeesite.common.utils.excel.annotation.ExcelField;

import java.util.Date;
import java.util.stream.Collectors;

/**
 * @author yuanshuai
 * @date 2021/2/26 15:53
 */
public class ShowExport {
	/**
	 * 赛事编号
	 */
	@ExcelField(title = "犬展编号", align = 2, sort = 1)
	private String code;
	/**
	 * 赛事场次
	 */
	@ExcelField(title = "犬展场次", align = 2, sort = 7)
	private Integer count;
	/**
	 * 大区字符串
	 */
	@ExcelField(title = "所属片区", align = 2, sort = 2)
	private String regionStr;
	/**
	 * 赛事开始日期
	 */
	@ExcelField(title = "犬展开始日期", align = 2, sort = 5)
	private Date startDate;
	/**
	 * 赛事结束日期
	 */
	@ExcelField(title = "犬展结束日期", align = 2, sort = 6)
	private Date endDate;
	/**
	 * 城市
	 */
	@ExcelField(title = "城市", align = 2, sort = 4)
	private String city;
	/**
	 * 省份
	 */
	@ExcelField(title = "省份", align = 2, sort = 3)
	private String province;
	/**
	 * 裁判
	 */
	@ExcelField(title = "裁判", align = 2, sort = 8)
	private String refereeStr;

	public ShowExport() {
	}

	public ShowExport(Show show) {
		this.code = show.getCode();
		this.count = show.getCount();
		this.regionStr = show.getRegionStr();
		this.startDate = show.getStartDate();
		this.endDate = show.getEndDate();
		this.city = show.getCity();
		this.province = show.getProvince();
		this.refereeStr = show.getRefereeList()
				.stream()
				.map(Referee::getName)
				.collect(Collectors.joining(","));
	}

	public String getCode() {
		return code;
	}

	public void setCode(String code) {
		this.code = code;
	}

	public Integer getCount() {
		return count;
	}

	public void setCount(Integer count) {
		this.count = count;
	}

	public String getRegionStr() {
		return regionStr;
	}

	public void setRegionStr(String regionStr) {
		this.regionStr = regionStr;
	}

	public Date getStartDate() {
		return startDate;
	}

	public void setStartDate(Date startDate) {
		this.startDate = startDate;
	}

	public Date getEndDate() {
		return endDate;
	}

	public void setEndDate(Date endDate) {
		this.endDate = endDate;
	}

	public String getCity() {
		return city;
	}

	public void setCity(String city) {
		this.city = city;
	}

	public String getProvince() {
		return province;
	}

	public void setProvince(String province) {
		this.province = province;
	}

	public String getRefereeStr() {
		return refereeStr;
	}

	public void setRefereeStr(String refereeStr) {
		this.refereeStr = refereeStr;
	}
}
