/**
 * Copyright &copy; 2012-2014 <a href="https://github.com/thinkgem/jeesite">JeeSite</a> All rights reserved.
 */
package com.cku.oa.show.entity;

import java.util.Date;
import java.util.List;

import org.hibernate.validator.constraints.Length;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.google.common.collect.Lists;
import com.thinkgem.jeesite.common.persistence.DataEntity;

/**
 * 赛事裁判证书Entity
 *
 * @author lgl
 * @version 2018-09-20
 */
public class ShowJudgeCertificate extends DataEntity<ShowJudgeCertificate> {

	private static final long serialVersionUID = 1L;
	private String name; // 名称
	private String nameEn; // 英文名称
	private String certificateType; // 证书类型:1全犬种;2全场总冠军;3犬种组;4单犬种;
	private String judgeCertificate; // 裁判证书号
	private String visibleFlag; // 是否可见。0不可见；1可见
	private Date signDate; // 签发日期
	private Date endDate; // 结束日期
	private String dogBreedCode; // 犬种代码
	private String dogBreedName; // 犬种名称
	// 美容审查员犬种组
	private String groomingDogGroup;
	private Integer sort;//排序

	// 查询参数
	private Integer isExpire; // 官网显示过期校验,0为不校验，1为校验

	private String expirationDateVisibleFlag; // 证书过期时间是否可见。0不可见；1可见 (美容专用)
	private List<ShowJudgeCertificateDogGroup> showJudgeCertificateDogGroupList = Lists.newArrayList();

	public List<ShowJudgeCertificateDogGroup> getShowJudgeCertificateDogGroupList() {
		return showJudgeCertificateDogGroupList;
	}

	public void setShowJudgeCertificateDogGroupList(
			List<ShowJudgeCertificateDogGroup> showJudgeCertificateDogGroupList) {
		this.showJudgeCertificateDogGroupList = showJudgeCertificateDogGroupList;
	}

	public ShowJudgeCertificate() {
		super();
	}

	public ShowJudgeCertificate(String id) {
		super(id);
	}

	@Length(min = 1, max = 20, message = "名称长度必须介于 1 和 20 之间")
	public String getName() {
		return name;
	}

	public void setName(String name) {
		this.name = name;
	}
	
	public Integer getSort() {
		return sort;
	}

	public void setSort(Integer sort) {
		this.sort = sort;
	}

	@Length(min = 1, max = 50, message = "英文名称长度必须介于 1 和 50 之间")
	public String getNameEn() {
		return nameEn;
	}

	public void setNameEn(String nameEn) {
		this.nameEn = nameEn;
	}

	@Length(min = 1, max = 2, message = "证书类型长度必须介于 1 和 2 之间")
	public String getCertificateType() {
		return certificateType;
	}

	public void setCertificateType(String certificateType) {
		this.certificateType = certificateType;
	}

	@Length(min = 1, max = 20, message = "裁判证书号长度必须介于 1 和 20 之间")
	public String getJudgeCertificate() {
		return judgeCertificate;
	}

	public void setJudgeCertificate(String judgeCertificate) {
		this.judgeCertificate = judgeCertificate;
	}

	@Length(min = 1, max = 1, message = "是否可见。0不可见；1可见长度必须介于 1 和 1 之间")
	public String getVisibleFlag() {
		return visibleFlag;
	}

	public void setVisibleFlag(String visibleFlag) {
		this.visibleFlag = visibleFlag;
	}

	@JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
	public Date getSignDate() {
		return signDate;
	}

	public void setSignDate(Date signDate) {
		this.signDate = signDate;
	}

	@JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
	public Date getEndDate() {
		return endDate;
	}

	public void setEndDate(Date endDate) {
		this.endDate = endDate;
	}

	@Length(min = 0, max = 10, message = "犬种代码长度必须介于 0 和 10 之间")
	public String getDogBreedCode() {
		return dogBreedCode;
	}

	public void setDogBreedCode(String dogBreedCode) {
		this.dogBreedCode = dogBreedCode;
	}

	public String getDogBreedName() {
		return dogBreedName;
	}

	public void setDogBreedName(String dogBreedName) {
		this.dogBreedName = dogBreedName;
	}

	public Integer getIsExpire() {
		return isExpire;
	}

	public void setIsExpire(Integer isExpire) {
		this.isExpire = isExpire;
	}

	public String getGroomingDogGroup() {
		return groomingDogGroup;
	}

	public void setGroomingDogGroup(String groomingDogGroup) {
		this.groomingDogGroup = groomingDogGroup;
	}


	public String getExpirationDateVisibleFlag() {
		return expirationDateVisibleFlag;
	}

	public void setExpirationDateVisibleFlag(String expirationDateVisibleFlag) {
		this.expirationDateVisibleFlag = expirationDateVisibleFlag;
	}
}