/**
 * Copyright &copy; 2012-2014 <a href="https://github.com/thinkgem/jeesite">JeeSite</a> All rights reserved.
 */
package com.cku.oa.show.dao;

import java.util.List;

import org.apache.ibatis.annotations.Param;

import com.cku.oa.show.entity.ChildShows;
import com.cku.oa.show.entity.ShowResults;
import com.cku.oa.show.entity.ShowResultsExportVo;
import com.cku.restful.v1.dog.model.CkuShowsResults;
import com.thinkgem.jeesite.common.persistence.CrudDao;
import com.thinkgem.jeesite.common.persistence.annotation.MyBatisDao;

/**
 * 赛事成绩DAO接口
 *
 * @author lgl
 * @version 2016-07-13
 */
@MyBatisDao
public interface ShowResultsDao extends CrudDao<ShowResults> {

	public void initShowResult(String showCode);

	public void updateResultBPBOB(String showCode);

	public void updateResultPBOB(String showCode);

	public void updateResultBOB(String showCode);

	public List<String> findBIGDogBreedGroup(@Param("showCode")String showCode,@Param("resultBig")String resultBig);

	public Long countByDogBreedGroup(ShowResults showResults);

	public List<ShowResults> findFciCode(ShowResults showResults);

	public void updateShowResultById(ShowResults showResults);

	public Long countByFciCode(ShowResults showResults);

	public void updateResultBPBIG(@Param("showCode") String showCode, @Param("index") Integer index);

	public void updateResultPBIG(@Param("showCode") String showCode, @Param("index") Integer index);

	public void updateResultBIG(@Param("showCode") String showCode, @Param("index") Integer index);

	public Long countBIS(@Param("showCode") String showCode, @Param("index") Integer index);

	public Long countBPBIS(@Param("showCode") String showCode, @Param("index") Integer index);

	public Long countPBIS(@Param("showCode") String showCode, @Param("index") Integer index);

	public Long countSumBIS(String showCode);

	public Long countSumBPBIS(String showCode);

	public Long countSumPBIS(String showCode);

	public void updateResultBIS(@Param("showCode") String showCode, @Param("showResult") String showResult,
			@Param("resultBis") String resultBis);

	public void amendShowResult(String showCode);

	public void updateCancelResult(String showCode);

	public List<CkuShowsResults> getShowsResult(@Param("pedigreeCertifiedCode") String pedigreeCertifiedCode,
			@Param("pageNo") Integer pageNo, @Param("pageSize") Integer pageSize, @Param("ageGroup") String ageGroup,
			@Param("annual") String annual);

	// <!-- CKU官网根据血统证书号或芯片号进行查询 -->
	public List<ShowResults> getByKey(@Param("key") String key);

	public List<ShowResults> getByKeyAndIsOwner(@Param("key") String key, @Param("isOwner") String isOwner);

	/**
	 *
	 * @description: 根据赛事编号和血统证书号查询条数
	 * @author: laiguanglong
	 * @date: 2016年10月19日 下午2:41:56
	 */
	int countByShowCodeAndPedigreeCertified(@Param("showCode") String showCode,
			@Param("pedigreeCertified") String pedigreeCertified);

	/**
	 * @description: 根据血统证书号查询获得的BIS成绩数量
	 * @author: laiguanglong
	 * @date: 2017/10/11 17:23
	 */
	int getBisCountByPedigreeCertified(@Param("pedigreeCertified") String pedigreeCertified);

	/**
	 * @description: 根据血统证书号查询获得的BIG成绩数量
	 * @author: laiguanglong
	 * @date: 2017/10/11 17:23
	 */
	int getBigCountByPedigreeCertified(@Param("pedigreeCertified") String pedigreeCertified);

	/**
	 * @description: 根据血统证书号查询获得的BOB成绩数量
	 * @author: laiguanglong
	 * @date: 2017/10/11 17:23
	 */
	int getBobCountByPedigreeCertified(@Param("pedigreeCertified") String pedigreeCertified);

	// 根据赛事编号查询此赛事所有犬
	public List<ShowResults> findAllListByCode(String showCode);

	/**
	 * @Description: 更新此报名信息赛事年份
	 * @author: zhangxiang
	 * @date: 2019/10/16 15:52
	 */
	int updateShowResultYear(ShowResults showResults);

	void updateShowResultBIG(ShowResults show);

	List<ShowResults> getByShowCode(@Param("showCode") String showCode);

	void updateBbeScore(@Param("pedigreeCertified") String pedigreeCertified, @Param("bbeScore") String bbeScore);

	void updateOhcScore(@Param("pedigreeCertified") String pedigreeCertified, @Param("ohcScore") String ohcScore);

	List<ShowResults> getBBEScore(@Param("year") String year, @Param("name") String name,
			@Param("pageSize") Integer pageSize, @Param("flag") String flag);

	List<ShowResults> getOHCScore(@Param("year") String year, @Param("name") String name,
			@Param("pageSize") Integer pageSize);

	List<ShowResults> getDogGradeList(@Param("pedigreeNum") String pedigreeNum, @Param("charTime") String charTime);

	List<ShowResults> getDogGradeListIsOwner(@Param("pedigreeNum") String pedigreeNum,
			@Param("charTime") String charTime);

    List getDogAgeGroups();

	List<ShowResults> findAllBISByShowCode(@Param("showCode")String showCode);

	List<ShowResults> findAllResultByAgeGroup(@Param("showCode")String showCode, @Param("groupType")String groupType);
	
    void updateBreedResutlBOB(String showCode);
    
    List<ChildShows> refreshHm(@Param("showCodes") List<String> showCodes );
    
    int updateResultBISSWithBOV(String showCode);
    
    int updateResultBISSWithoutBOV(String showCode);
    
    int countBIG(@Param("showCode") String showCode, @Param("resultBig") String resultBig);
    
    List<Long> countByFciCodeForBIS(@Param("showCode") String showCode, @Param("resultBis") String resultBis);
    
    List<Long> countByDogBreedGroupForBIS(@Param("showCode") String showCode, @Param("resultBis") String resultBis);

	List<ShowResults> getRangeResultList(@Param("begin") String begin, @Param("end") String end);
    
	List<ShowResultsExportVo> getRangeExportResultList(@Param("begin") String begin, @Param("end") String end , @Param("qusCode") String qusCode);

    int updateQusResult(ShowResults showResults);
}