package com.cku.oa.sampling.entity;

import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotNull;
import java.util.Date;

import com.fasterxml.jackson.annotation.JsonFormat;

import com.thinkgem.jeesite.common.persistence.DataEntity;

/**
 * 采样包Entity
 *
 * @author yuanshuai
 * @version 2023-05-22
 */
public class Sampling extends DataEntity<Sampling> {

	private static final long serialVersionUID = 1L;
	private String samplingCode;        // 采样包编号
	private String dogId;        // 犬只ID
	/**
	 * 犬只来源（0证书号，1出生纸编号，2国外证书号）
	 * 请使用SamplingDogSourceTypeEnum
	 */
	private Integer dogSourceType;
	private String dogCode;        // 犬只编号（证书号、出生纸编号、国外证书号）
	private String chipCode;        // 芯片号（显示用）
	/**
	 * 分发渠道（0会员，1俱乐部）
	 * 请使用SamplingDistributionChannelEnum
	 */
	private Integer distributionChannel;
	private String memberCode;        // 会员号
	private String memberName;        // 会员姓名
	private Integer bindType;        // 绑定状态（0未绑定，1已绑定）
	private String bindBy;        // 绑定人
	private String bindMemberCode;        // 绑定人会员号
	private String bindUserName;        // 绑定人用户名
	private Date bindTime;        // 绑定时间
	private Date sendTime;        // 送检时间
	/**
	 * 流程状态（0待邮寄，1已邮寄，2已送检，3检测成功，4检测失败，5已注销）
	 * 请使用com.cku.oa.sampling.enums.SamplingFlowStateEnum
	 */
	private Integer flowState;

	// 送检时间-查询用
	private Date beginSendTime;
	private Date endSendTime;
	// 绑定时间-查询用
	private Date beginBindTime;
	private Date endBindTime;
	//补寄时间
	private Date reissueTime;
	

	public Sampling() {
		super();
	}

	public Sampling(String id) {
		super(id);
	}


	@Override
	public String toString() {
		return "{" +
				"\"samplingCode : \"" + samplingCode + '\"' +
				", \"dogId : \"" + dogId + '\"' +
				", \"dogSourceType=" + dogSourceType +
				", \"dogCode : \"" + dogCode + '\"' +
				", \"chipCode : \"" + chipCode + '\"' +
				", \"distributionChannel : \"" + distributionChannel + '\"' +
				", \"memberCode : \"" + memberCode + '\"' +
				", \"memberName : \"" + memberName + '\"' +
				", \"bindType=" + bindType + '\"' +
				", \"bindBy : \"" + bindBy + '\"' +
				", \"bindMemberCode : \"" + bindMemberCode + '\"' +
				", \"bindUserName : \"" + bindUserName + '\"' +
				", \"bindTime : \"" + bindTime + '\"' +
				", \"sendTime : \"" + sendTime + '\"' +
				", \"flowState : \"" + flowState + '\"' +
				'}';
	}

	@Length(min = 1, max = 32, message = "采样包编号长度必须介于 1 和 32 之间")
	public String getSamplingCode() {
		return samplingCode;
	}

	public void setSamplingCode(String samplingCode) {
		this.samplingCode = samplingCode;
	}


	public String getDogId() {
		return dogId;
	}

	public void setDogId(String dogId) {
		this.dogId = dogId;
	}

	public Integer getDogSourceType() {
		return dogSourceType;
	}

	public void setDogSourceType(Integer dogSourceType) {
		this.dogSourceType = dogSourceType;
	}

	@Length(min = 0, max = 64, message = "犬只编号（证书号、出生纸编号、国外证书号）长度必须介于 0 和 64 之间")
	public String getDogCode() {
		return dogCode;
	}

	public void setDogCode(String dogCode) {
		this.dogCode = dogCode;
	}

	public String getChipCode() {
		return chipCode;
	}

	public void setChipCode(String chipCode) {
		this.chipCode = chipCode;
	}

	public Integer getDistributionChannel() {
		return distributionChannel;
	}

	public void setDistributionChannel(Integer distributionChannel) {
		this.distributionChannel = distributionChannel;
	}

	@Length(min = 0, max = 16, message = "会员号长度必须介于 0 和 16 之间")
	public String getMemberCode() {
		return memberCode;
	}

	public void setMemberCode(String memberCode) {
		this.memberCode = memberCode;
	}

	public String getMemberName() {
		return memberName;
	}

	public void setMemberName(String memberName) {
		this.memberName = memberName;
	}

	@NotNull(message = "绑定状态（0未绑定，1已绑定）不能为空")
	public Integer getBindType() {
		return bindType;
	}

	public void setBindType(Integer bindType) {
		this.bindType = bindType;
	}

	@Length(min = 0, max = 32, message = "绑定人长度必须介于 0 和 32 之间")
	public String getBindBy() {
		return bindBy;
	}

	public void setBindBy(String bindBy) {
		this.bindBy = bindBy;
	}

	public String getBindMemberCode() {
		return bindMemberCode;
	}

	public void setBindMemberCode(String bindMemberCode) {
		this.bindMemberCode = bindMemberCode;
	}

	public String getBindUserName() {
		return bindUserName;
	}

	public void setBindUserName(String bindUserName) {
		this.bindUserName = bindUserName;
	}

	@JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
	public Date getBindTime() {
		return bindTime;
	}

	public void setBindTime(Date bindTime) {
		this.bindTime = bindTime;
	}

	@JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
	public Date getSendTime() {
		return sendTime;
	}

	public void setSendTime(Date sendTime) {
		this.sendTime = sendTime;
	}

	@NotNull(message = "流程状态（0待邮寄，1已邮寄，2已送检，3检测成功，4检测失败，5已注销）不能为空")
	public Integer getFlowState() {
		return flowState;
	}

	public void setFlowState(Integer flowState) {
		this.flowState = flowState;
	}

	public Date getBeginSendTime() {
		return beginSendTime;
	}

	public void setBeginSendTime(Date beginSendTime) {
		this.beginSendTime = beginSendTime;
	}

	public Date getEndSendTime() {
		return endSendTime;
	}

	public void setEndSendTime(Date endSendTime) {
		this.endSendTime = endSendTime;
	}

	public Date getBeginBindTime() {
		return beginBindTime;
	}

	public void setBeginBindTime(Date beginBindTime) {
		this.beginBindTime = beginBindTime;
	}

	public Date getEndBindTime() {
		return endBindTime;
	}

	public void setEndBindTime(Date endBindTime) {
		this.endBindTime = endBindTime;
	}

	public Date getReissueTime() {
		return reissueTime;
	}

	public void setReissueTime(Date reissueTime) {
		this.reissueTime = reissueTime;
	}
}