/**
 * Copyright &copy; 2012-2014 <a href="https://github.com/thinkgem/jeesite">JeeSite</a> All rights reserved.
 */
package com.cku.oa.report.dao;

import java.util.List;

import org.apache.ibatis.annotations.Param;

import com.cku.oa.report.entity.ReportMemberArea;
import com.cku.oa.report.entity.ReportRule;
import com.thinkgem.jeesite.common.persistence.CrudDao;
import com.thinkgem.jeesite.common.persistence.annotation.MyBatisDao;

/**
 * 会员统计报表DAO接口
 * 
 * @author Sunny
 * @version 2022-04-15
 */
@MyBatisDao
public interface ReportMemberAreaDao extends CrudDao<ReportMemberArea> {

	List<ReportMemberArea> findTotal(@Param("officeName") String officeName, @Param("periodYear") String periodYear,
			@Param("periodType") String periodType, @Param("periodNo") String periodNo);

	ReportRule findReportRule(@Param("officeName") String officeName, @Param("periodYear") String periodYear,
			@Param("periodType") String periodType, @Param("periodNo") String periodNo);

}