package com.cku.oa.order.service.impl;

import com.cku.core.ZAErrorCode;
import com.cku.core.ZAException;
import com.cku.logUtil.JSONObjectUtils;
import com.cku.oa.common.SKUIDConstants;
import com.cku.oa.groomer.entity.GroomerQualificationCertificate;
import com.cku.oa.groomer.enums.QualificationCertificateLevelEnum;
import com.cku.oa.groomer.service.GroomerQualificationCertificateService;
import com.cku.oa.order.service.BaseSkuBusinessService;
import com.cku.oa.order.service.IOrderBusinessService;
import com.cku.oa.order.vo.ChargingItemVo;
import com.cku.oa.order.vo.OrderSkuVo;
import com.cku.oa.order.vo.SingleIdOrderBusinessVo;
import com.cku.oa.order.vo.request.SingleIdRequest;
import com.cku.oa.sys.entity.user.Member;
import com.cku.restful.v2.order.vo.request.OrderApplyRequest;
import com.google.common.collect.Lists;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;

/**
 * pdg美容资格证书处理类
 *
 * @author hujiaxin
 * @date 2024年7月30日
 */
@Service("pdgGroomerQualificationCertificateOrderServiceImpl")
public class PdgGroomerQualificationCertificateOrderServiceImpl extends BaseSkuBusinessService<SingleIdOrderBusinessVo> implements IOrderBusinessService<SingleIdRequest> {

    @Autowired
    private GroomerQualificationCertificateService groomerQualificationCertificateService;

    /**
     * 日志对象
     */
    protected Logger logger = LoggerFactory.getLogger(getClass());
    @Override
    public void businessValidate(OrderApplyRequest orderRequest, SingleIdRequest businessRequest, Member member) {
        if (StringUtils.isBlank(businessRequest.getId())) {
            throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "参数为空");
        }
        GroomerQualificationCertificate gqc = groomerQualificationCertificateService.get(businessRequest.getId());
        if (Objects.isNull(gqc)) {
            throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "查询不到资格证书信息");
        }
        if (!"6".equals(gqc.getCertificateType())) {
            throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "该证书类型不是派多格资格证书");
        }
        if (!"1".equals(gqc.getPaymentState())) {
            throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "该资格证书信息已经缴费");
        }
        if (!Stream.of( QualificationCertificateLevelEnum.A.code()
                        , QualificationCertificateLevelEnum.B.code(), QualificationCertificateLevelEnum.C.code())
                .collect(Collectors.toList())
                .contains(gqc.getLevelEn())) {
            throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "派多格只有A、B、C级资格证书可以缴费");
        }
    }

    @Override
    public List<OrderSkuVo> preOrder(OrderApplyRequest orderRequest, SingleIdRequest businessRequest, Member member) {
        GroomerQualificationCertificate gqc = groomerQualificationCertificateService.get(businessRequest.getId());
        logger.info("preOrder param:{}", JSONObjectUtils.toJsonString(gqc));
        String skuId;
       /* if (QualificationCertificateLevelEnum.A.code().equals(gqc.getLevelEn())) {
            skuId = SKUIDConstants.GROOMER_QUALIFICATION_CERTIFICATE_A;
        } else if (QualificationCertificateLevelEnum.B.code().equals(gqc.getLevelEn())) {
            skuId = SKUIDConstants.GROOMER_QUALIFICATION_CERTIFICATE_B;
        } else if (QualificationCertificateLevelEnum.C.code().equals(gqc.getLevelEn())) {
            skuId = SKUIDConstants.GROOMER_QUALIFICATION_CERTIFICATE_C;
        } else {
            throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "只有A、B、C级资格证书可以缴费");
        }*/

        if (Objects.equals("6", gqc.getCertificateType())) {
            skuId = SKUIDConstants.GROOMER_QUALIFICATION_CERTIFICATE_PDG;
        }  else {
            throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "系统错误");
        }
        //sku列表
        List<OrderSkuVo> skuVoList = Lists.newArrayList();
        //添加证书费SKU
        skuVoList.add(OrderSkuVo.builder()
                .skuId(skuId)
                .num(1)
                .businessList(Stream.of(SingleIdOrderBusinessVo.builder()
                                .id(businessRequest.getId())
                                .build())
                        .collect(Collectors.toList()))
                .build());
        return skuVoList;
    }

    @Override
    public void processBusinessPrePay(OrderApplyRequest orderRequest, SingleIdOrderBusinessVo businessData, OrderSkuVo skuVo) {

    }

    @Override
    public void findChargingItemBusinessTableId(OrderApplyRequest orderRequest, OrderSkuVo skuVo, List<ChargingItemVo> itemList) {
        //获取业务信息
        SingleIdOrderBusinessVo businessData = (SingleIdOrderBusinessVo) skuVo.getBusinessList().get(0);
        logger.info("findChargingItemBusinessTableId businessData : {}", JSONObjectUtils.toJsonString(businessData));
        GroomerQualificationCertificate gqc = groomerQualificationCertificateService.get(businessData.getId());
        logger.info("findChargingItemBusinessTableId : gqc {}", JSONObjectUtils.toJsonString(gqc));
        itemList.forEach(item -> item.setBusinessIds(gqc.getId()));
    }
}
