package com.cku.oa.ipaddress.web;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

import com.cku.oa.ipaddress.entity.IpAddress;
import com.cku.oa.ipaddress.entity.IpBlackList;
import com.cku.oa.ipaddress.service.IpAddressService;
import com.cku.oa.ipaddress.service.IpBlackListService;
import com.thinkgem.jeesite.common.config.Global;
import com.thinkgem.jeesite.common.persistence.Page;
import com.thinkgem.jeesite.common.utils.IdGen;
import com.thinkgem.jeesite.common.utils.StringUtils;
import com.thinkgem.jeesite.common.web.BaseController;

/**
 * ip映射表Controller
 * @author ip映射表
 * @version 2019-10-18
 */
@Controller
@RequestMapping(value = "${adminPath}/ipaddress/ipAddress")
public class IpAddressController extends BaseController {

	@Autowired
	private IpAddressService ipAddressService;
	
	@Autowired
	private IpBlackListService ipBlackListService;
	
	@ModelAttribute
	public IpAddress get(@RequestParam(required=false) String id) {
		IpAddress entity = null;
		if (StringUtils.isNotBlank(id)){
			entity = ipAddressService.get(id);
		}
		if (entity == null){
			entity = new IpAddress();
		}
		return entity;
	}
	
	@RequiresPermissions("ipaddress:ipAddress:view")
	@RequestMapping(value = {"list", ""})
	public String list(IpAddress ipAddress, HttpServletRequest request, HttpServletResponse response, Model model) {
		Page<IpAddress> page = ipAddressService.findPage(new Page<IpAddress>(request, response), ipAddress); 
		model.addAttribute("page", page);
		return "oa/ipaddress/ipAddressList";
	}

	@RequiresPermissions("ipaddress:ipAddress:view")
	@RequestMapping(value = "form")
	public String form(IpAddress ipAddress, Model model) {
		model.addAttribute("ipAddress", ipAddress);
		return "oa/ipaddress/ipAddressForm";
	}

	@RequiresPermissions("ipaddress:ipAddress:edit")
	@RequestMapping(value = "save")
	public String save(IpAddress ipAddress, Model model, RedirectAttributes redirectAttributes) {
		if (!beanValidator(model, ipAddress)){
			return form(ipAddress, model);
		}
		ipAddressService.save(ipAddress);
		addMessage(redirectAttributes, "保存ip映射表成功");
		return "redirect:"+Global.getAdminPath()+"/ipaddress/ipAddress/?repage";
	}

	@RequiresPermissions("ipaddress:ipAddress:edit")
	@RequestMapping(value = "saveBlack")
	public String saveBlack(IpAddress ipAddress, Model model, RedirectAttributes redirectAttributes) {
//		if (!beanValidator(model, ipAddress)){
//			return form(ipAddress, model);
//		}
		IpBlackList ipBlackList = new IpBlackList();
		ipBlackList.setIp(ipAddress.getIp());
		ipBlackList.setStatus("0");
		ipBlackList.setId(IdGen.uuid());
		ipBlackListService.insert(ipBlackList);
		addMessage(redirectAttributes, "添加黑名单成功");
		return "redirect:"+Global.getAdminPath()+"/ipaddress/ipAddress/?repage";
	}
	
	@RequiresPermissions("ipaddress:ipAddress:edit")
	@RequestMapping(value = "delete")
	public String delete(IpAddress ipAddress, RedirectAttributes redirectAttributes) {
		ipAddressService.delete(ipAddress);
		addMessage(redirectAttributes, "删除ip映射表成功");
		return "redirect:"+Global.getAdminPath()+"/ipaddress/ipAddress/?repage";
	}

}