/**
 * Copyright &copy; 2012-2014 <a href="https://github.com/thinkgem/jeesite">JeeSite</a> All rights reserved.
 */
package com.cku.oa.handler.service;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Calendar;
import java.util.Date;
import java.util.List;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;

import com.cku.oa.handler.entity.HandlerShow;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.cku.core.ZAException;
import com.cku.oa.groomer.service.GroomerQualificationCertificateService;
import com.cku.oa.handler.dao.HandlerQualificationCertificateDao;
import com.cku.oa.handler.dao.HandlerRegisterDao;
import com.cku.oa.handler.entity.HandlerQualificationCertificate;
import com.cku.oa.handler.entity.HandlerRegister;
import com.cku.oa.sys.code.SysCodeUtil;
import com.cku.oa.sys.entity.BaseFile;
import com.cku.oa.sys.service.ExpressQueueService;
import com.cku.oa.sys.service.FileService;
import com.cku.oa.sys.service.RemindService;
import com.cku.oa.sys.util.Img2Base64Util;
import com.cku.oa.sys.zalog.SysContext;
import com.thinkgem.jeesite.common.persistence.Page;
import com.thinkgem.jeesite.common.service.CrudService;
import com.thinkgem.jeesite.common.utils.DateUtils;
import com.thinkgem.jeesite.common.utils.excel.ExportExcel;

/**
 * 资格证书Service
 * @author 柴雪腾
 * @version 2016-08-08
 */
@Service
@Transactional(readOnly = true)
public class HandlerQualificationCertificateService extends CrudService<HandlerQualificationCertificateDao, HandlerQualificationCertificate> {
	@Autowired
	public RemindService remindService;
	@Autowired
	public HandlerRegisterDao handlerRegisterDao;
	@Autowired
	public GroomerQualificationCertificateService groomerQualificationCertificateService;
	@Autowired
	public ExpressQueueService expressQueueService;
	@Autowired
	private FileService fileService;
	@Autowired
	private HandlerShowService handlerShowService;
	
	public HandlerQualificationCertificate get(String id) {
		return super.get(id);
	}
	
	public List<HandlerQualificationCertificate> findList(HandlerQualificationCertificate handlerQualificationCertificate) {
		return super.findList(handlerQualificationCertificate);
	}
	
	public Page<HandlerQualificationCertificate> findPage(Page<HandlerQualificationCertificate> page, HandlerQualificationCertificate handlerQualificationCertificate) {
		return super.findPage(page, handlerQualificationCertificate);
	}
	
	@Transactional(readOnly = false)
	public void save(HandlerQualificationCertificate handlerQualificationCertificate) {
		if(handlerQualificationCertificate.getIsNewRecord()){
			handlerQualificationCertificate.setPrintState("0");
			handlerQualificationCertificate.setPaymentState("1");
			handlerQualificationCertificate.setReviewState("0");
			handlerQualificationCertificate.setProccessState("0");
			super.save(handlerQualificationCertificate);
		}else{
			super.save(handlerQualificationCertificate);
		}
	}
	
	@Transactional(readOnly = false)
	public void delete(HandlerQualificationCertificate handlerQualificationCertificate) {
		super.delete(handlerQualificationCertificate);
	}
	
	//获取会员的最新资格证书等级
	public HandlerQualificationCertificate getLevel(String memberCode) {
		List<HandlerQualificationCertificate> list = dao.getLevel(memberCode);
		if (list.size()>0) {
			String level = list.get(0).getCertificateLevelEn();
			if ("MASTER".equals(level)) {//如果是教师资格证书
				return list.get(0);
			}else{//不存在教师级证书 返回最大的级别
				return	list.get(list.size()-1);
			}
		}
		return null;
	}

	/**
	 * 生成资格证书号
	 * @Author chaixueteng
	 * @2016年8月3日下午1:40:03
	 */
	@Transactional(readOnly = false)
	public void createCode(String id) {
		String certificateCode=null;
		HandlerQualificationCertificate hqc = super.get(id);
		String memberCode = hqc.getMemberCode();
		String level = hqc.getCertificateLevelEn();
		if ("1".equals(hqc.getCertificateType())) {
			if (level.equals("MASTER")) {
				certificateCode = SysCodeUtil.getTrainerDogHandlerQualificationCertificateCode("M");
			}else{
				certificateCode=SysCodeUtil.getTrainerDogHandlerQualificationCertificateCode(level);
			}
		} else {
			if (level.equals("MASTER")) {
				certificateCode = SysCodeUtil.getHandlerQualificationCertificateCode("M");
			} else {
				certificateCode = SysCodeUtil.getHandlerQualificationCertificateCode(level);
			}
		}
		HandlerQualificationCertificate handlerQualificationCertificate = new HandlerQualificationCertificate();
		handlerQualificationCertificate.setId(id);
		handlerQualificationCertificate.setCertificateCode(certificateCode);
		handlerQualificationCertificate.setIssueDate(new Date()); 
		handlerQualificationCertificate.setProccessState("1");
		handlerQualificationCertificate.setProccessTime(new Date());
		dao.createCode(handlerQualificationCertificate);
		remindService.addRemind("您的资格证书已经生成，请注意查收邮寄证书。", memberCode);
		remindService.addMemberRemind("您的资格证书已经生成，请注意查收邮寄证书。", memberCode);
	}

	/**
	 * 批量提醒
	 * @Author chaixueteng
	 * @2016年8月3日下午4:27:51
	 */
	@Transactional(readOnly = false)
	public void reminder(String ids)throws ZAException  {
		String[] id = ids.split(",");
		for (int i = 0; i < id.length; i++) {
			HandlerQualificationCertificate  gqc= dao.get(id[i]);
			String handlerRegisterId = gqc.getRegisterId();
			String memberCode = gqc.getMemberCode();
			HandlerRegister register = handlerRegisterDao.get(handlerRegisterId);
			HandlerShow show = handlerShowService.getShow(register.getShowCode());
			String showName = show.getShowName();
			String paymentState = gqc.getPaymentState();
			//未申领的才提醒
			if ("1".equals(paymentState)) {
				Date date = new Date();
				Date gradeTime = register.getGradeTime();//录入成绩的时间
				Calendar ca = Calendar.getInstance();
				ca.setTime(gradeTime);
		        ca.add(Calendar.DATE, 180);// num为增加的天数，可以改变的
		        Date date2 = ca.getTime();
		        int day = groomerQualificationCertificateService.getDay(date,date2);
				remindService.addMemberRemind("您的"+showName.trim()+"考试通过，请在"+day+"天之内申请领取资格证书，过期无效。", memberCode);
			}
		}
	}

	/**
	 * 培训资格证书导出(全部)
	 * 
	 * 
	 * @throws IOException 
	 * @Author chaixueteng
	 * @2016年8月3日下午4:49:12
	 */
	public void export(HandlerQualificationCertificate handlerQualificationCertificate,HttpServletResponse response) throws IOException {
		List<HandlerQualificationCertificate> HQCList=dao.getCertificateList(handlerQualificationCertificate);
		for (HandlerQualificationCertificate HQC : HQCList) {
			HQC.setGender("male".equals(HQC.getGender())?"男":"女");
			HQC.setName(HQC.getName());
		}
		new ExportExcel("", HandlerQualificationCertificate.class, 2)
		.setDataList(HQCList).write(response, "培训资格证书.xlsx").dispose();
	}

	/**
	 * save
	 * @Author chaixueteng
	 * @2016年8月24日下午3:05:39
	 */
	@Transactional(readOnly = false)
	public void saveCertificate(HandlerQualificationCertificate hqc) {
		dao.saveCertificate(hqc);
	}
	
	/**
	 * 重置打印
	 * @Author chaixueteng
	 * @2016年8月25日下午6:18:23
	 */
	@Transactional(readOnly = false)
	public void resetPrint(String id) {
		HandlerQualificationCertificate handlerQualificationCertificate = super.get(id);
		handlerQualificationCertificate.setPrintState("0");
		dao.resetPrint(handlerQualificationCertificate);
		
	}
	
	/**
	 * 打印
	 * @Author chaixueteng
	 * @2016年8月25日下午6:28:06
	 */
	@Transactional(readOnly = false)
	public HandlerQualificationCertificate print(String id) {
		HandlerQualificationCertificate hd = super.get(id);
		SysContext sysContext = new SysContext(null,null,null);
		sysContext.noStateExecute(sysContext,"牵犬师资格证书打印",hd.getMemberCode(),"handler_qualification_certificate",hd.getId(),hd.getRunningNumber(),(str)->{});
		hd.setPrintState("1");
		dao.resetPrint(hd);
		HandlerQualificationCertificate handlerQualificationCertificate = dao.print(id);
		Date takeCertificateDate = handlerQualificationCertificate.getTakeCertificateDate();
		Date issueDate = handlerQualificationCertificate.getIssueDate();
		String taskDate = DateUtils.formatDate(takeCertificateDate, "yyyy年M月d日");
		String issDate = DateUtils.formatDate(issueDate, "yyyy年M月d日");
		handlerQualificationCertificate.setTaskDate(taskDate);
		handlerQualificationCertificate.setIssDate(issDate);
		//推送消息
		expressQueueService.push(hd.getMemberCode(), hd.getRunningNumber(), "牵犬师资格证书", hd.getCertificateCode(),null); // GYH2 TODO
		//加载图片
		if (handlerQualificationCertificate.getMember().getAvatar() != null
				&& handlerQualificationCertificate.getMember().getAvatar().startsWith("http")) {
			handlerQualificationCertificate.setAvatarBase64(handlerQualificationCertificate.getMember().getAvatar());
		} else {
			ByteArrayOutputStream outPut = null;
			try {
				BaseFile file = fileService.get(handlerQualificationCertificate.getMember().getAvatar());
				if (file != null) {
					outPut = new ByteArrayOutputStream();
					fileService.fileDownload(file,outPut);
					handlerQualificationCertificate.setAvatarBase64(
							"data:" + file.getType() + ";base64," + Img2Base64Util.getImgStr(outPut.toByteArray()));
				}
			} catch (Exception e) {
				e.printStackTrace();
			} finally {
				try {
					if (outPut != null) {
						outPut.close();
					}
				} catch (IOException e) {
					e.printStackTrace();
				}
			}
		}
		return handlerQualificationCertificate;
	}

	/**
	 * 培训资格证书申请数
	 * @Author chaixueteng
	 * @2016年8月31日下午1:44:25
	 */
	public int getHandlerQualificationCount(){
		return dao.getHandlerQualificationCount();
	}
	
	/**
	 * 定时任务 每天凌晨1点执行删除(逻辑)180天未申领的资格证书
	 * @Author chaixueteng
	 * @2016年9月5日下午7:20:54
	 */
	@Transactional(readOnly = false)
	public int deleteQualificationCertificate(){
		int count = 0;
		HandlerQualificationCertificate hqc = new HandlerQualificationCertificate();
		hqc.setPaymentState("1");
		hqc.setDelFlag("0");
		List<HandlerQualificationCertificate> List = dao.findAllList(hqc);
		Calendar calendar = Calendar.getInstance();//日历对象
		for (HandlerQualificationCertificate H : List) {
			if (H.getHandlerRegister()!=null) {
				Date gradeTime = H.getHandlerRegister().getGradeTime();
				String paymentState = H.getPaymentState();
				if (gradeTime!=null&&StringUtils.isNotBlank(paymentState)&&"1".equals(paymentState)) {
					calendar.setTime(gradeTime);//设置当前日期
					calendar.add(Calendar.DATE, 180);//天数+180
					long timeInMillis = calendar.getTimeInMillis();
					long time = new Date().getTime();
					if (timeInMillis<time) {//超过180未申领 就删除该资格证书
						dao.delete(H);
						count=count+1;
					}
				}
			}
		}
		return count;
	}

	/**
	 * 根据报名id查询资格证书
	 * @Author chaixueteng
	 * @2016年9月29日下午4:48:00
	 */
	public HandlerQualificationCertificate getRegister(String id) {
		return dao.getRegister(id);
	}

	//获取会员的最新资格证书等级
	public HandlerQualificationCertificate getPartnerDogLevel(String memberCode) {
		List<HandlerQualificationCertificate> list = dao.getPartnerDogLevel(memberCode);
		if (list.size()>0) {
			String level = list.get(0).getCertificateLevelEn();
			if ("MASTER".equals(level)) {//如果是教师资格证书
				return list.get(0);
			}else{//不存在教师级证书 返回最大的级别
				return	list.get(list.size()-1);
			}
		}
		return null;
	}

	/**
	 * 训练师资格证书打印
	 * @Author chaixueteng
	 * @2016年8月25日下午6:28:06
	 */
	@Transactional(readOnly = false)
	public HandlerQualificationCertificate trainerPartnerPrint(String id) {
		HandlerQualificationCertificate hd = super.get(id);
		SysContext sysContext = new SysContext(null,null,null);
		sysContext.noStateExecute(sysContext, "训练师资格证书打印", hd.getMemberCode(), "handler_qualification_certificate", hd.getId(), hd.getRunningNumber(), (str) -> {
		});
		hd.setPrintState("1");
		dao.resetPrint(hd);
		HandlerQualificationCertificate handlerQualificationCertificate = dao.print(id);
		if (StringUtils.isNotBlank(handlerQualificationCertificate.getReviewer())) {

		}
		Date takeCertificateDate = handlerQualificationCertificate.getTakeCertificateDate();
		Date issueDate = handlerQualificationCertificate.getIssueDate();
		String taskDate = DateUtils.formatDate(takeCertificateDate, "yyyy年M月d日");
		String issDate = DateUtils.formatDate(issueDate, "yyyy年M月d日");
		handlerQualificationCertificate.setTaskDate(taskDate);
		handlerQualificationCertificate.setIssDate(issDate);
		//推送消息
		expressQueueService.push(hd.getMemberCode(), hd.getRunningNumber(), "训练师伴侣犬资格证书", hd.getCertificateCode(),null); // GYH2 TODO
		//加载图片
		if (handlerQualificationCertificate.getMember().getAvatar() != null
				&& handlerQualificationCertificate.getMember().getAvatar().startsWith("http")) {
			handlerQualificationCertificate.setAvatarBase64(handlerQualificationCertificate.getMember().getAvatar());
		} else {
			ByteArrayOutputStream outPut = null;
			try {
				BaseFile file = fileService.get(handlerQualificationCertificate.getMember().getAvatar());
				if (file != null) {
					outPut = new ByteArrayOutputStream();
					fileService.fileDownload(file,outPut);
					handlerQualificationCertificate.setAvatarBase64(
							"data:" + file.getType() + ";base64," + Img2Base64Util.getImgStr(outPut.toByteArray()));
				}
			} catch (Exception e) {
				e.printStackTrace();
			} finally {
				try {
					if (outPut != null) {
						outPut.close();
					}
				} catch (IOException e) {
					e.printStackTrace();
				}
			}
		}
		return handlerQualificationCertificate;
	}

	/**
	 * 查询
	 * @param handlerQualificationCertificate
	 * @return
	 */
	public List<HandlerQualificationCertificate> findTrainerListByCertificate(HandlerQualificationCertificate handlerQualificationCertificate){
		List<HandlerQualificationCertificate> trainerListByCertificate = dao.findTrainerListByCertificate(handlerQualificationCertificate);
		return trainerListByCertificate;
	}
}