package com.cku.oa.groomer.service;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.servlet.http.HttpServletRequest;

import org.restlet.engine.util.DateUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.ui.Model;

import com.cku.core.RESTResponse;
import com.cku.core.ZAErrorCode;
import com.cku.core.ZAException;
import com.cku.oa.finance.entity.PaymentChargingItem;
import com.cku.oa.finance.service.PaymentChargingItemService;
import com.cku.oa.groomer.dao.GroomerQualificationCertificateDao;
import com.cku.oa.groomer.dao.InternationalGroomerCertificateDao;
import com.cku.oa.groomer.entity.ApplyCertificateVo;
import com.cku.oa.groomer.entity.GroomerDiploma;
import com.cku.oa.groomer.entity.GroomerQualificationCertificate;
import com.cku.oa.groomer.entity.I18nApplyListVo;
import com.cku.oa.groomer.entity.InternationalGroomerCertificate;
import com.cku.oa.sys.dao.user.MemberDao;
import com.cku.oa.sys.entity.user.Member;
import com.cku.oa.sys.service.ExpressQueueService;
import com.cku.oa.sys.util.MemberUtil;
import com.cku.oa.sys.zalog.SysContext;
import com.thinkgem.jeesite.common.persistence.Page;
import com.thinkgem.jeesite.common.service.CrudService;
import com.thinkgem.jeesite.common.utils.Collections3;
import com.thinkgem.jeesite.common.utils.StringUtils;
import com.thinkgem.jeesite.modules.sys.entity.Dict;
import com.thinkgem.jeesite.modules.sys.service.DictService;
import com.thinkgem.jeesite.modules.sys.utils.UserUtils;

/**
 * 国际美容师管理Service
 *
 * @author wangjie
 * @version 2019-07-29
 */
@Service
@Transactional(readOnly = true)

public class InternationalGroomerCertificateService
		extends CrudService<InternationalGroomerCertificateDao, InternationalGroomerCertificate> {

	@Autowired
	private MemberDao memberDao;
	@Autowired
	private ExpressQueueService expressQueueService;
	@Autowired
	private DictService dictService;
	@Autowired
	private GroomerQualificationCertificateDao groomerQualificationCertificateDao;
	@Autowired
	private GroomerDiplomaService groomerDiplomaService;
	@Autowired
	private PaymentChargingItemService paymentChargingItemService;

	public InternationalGroomerCertificate get(String id) {
		return super.get(id);
	}

	public List<InternationalGroomerCertificate> findList(
			InternationalGroomerCertificate internationalGroomerCertificate) {
		return super.findList(internationalGroomerCertificate);
	}

	public Page<InternationalGroomerCertificate> findPage(Page<InternationalGroomerCertificate> page,
			InternationalGroomerCertificate internationalGroomerCertificate) {
		internationalGroomerCertificate.setPage(page);
		List<InternationalGroomerCertificate> list = findList(internationalGroomerCertificate);
		for (InternationalGroomerCertificate data : list) {
			Member member = memberDao.getByMemberCode(data.getMemberCode());
			if ("ISPG".equals(data.getCertificateType())) {
				data.setEndDate(member.getGroomerEndDate());
			} else {
				data.setEndDate(member.getMemberEndDate());
			}
		}
		page.setList(list);
		return page;
	}

	@Transactional(readOnly = false)
	public void save(InternationalGroomerCertificate internationalGroomerCertificate) {
		super.save(internationalGroomerCertificate);
	}

	@Transactional(readOnly = false)
	public void delete(InternationalGroomerCertificate internationalGroomerCertificate) {
		super.delete(internationalGroomerCertificate);
	}

	@Transactional(readOnly = false)
	public String print(String id, Model model) {
		InternationalGroomerCertificate groomerCertificate = get(id);
		if (groomerCertificate == null) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "查询不到证书，无法打印");
		}
		if (StringUtils.isBlank(groomerCertificate.getCertificateCode())) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "证书号为空，无法打印");
		}
		if (StringUtils.isBlank(groomerCertificate.getCnName())) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "中文名为空，无法打印");
		}
		if (groomerCertificate.getIssueDate() == null) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "签发日期为空，无法打印");
		}

		if (StringUtils.isBlank(groomerCertificate.getReviewState())
				|| !"1".equals(groomerCertificate.getReviewState())) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "审核未通过，无法打印");
		}
		if (StringUtils.isBlank(groomerCertificate.getPaymentState())
				|| !"2".equals(groomerCertificate.getPaymentState())) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "证书未交费，无法打印");
		}
		Member member = memberDao.getByMemberCode(groomerCertificate.getMemberCode());
		if (member == null) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "会员不存在，无法打印");
		}
		if (member == null) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "会员不存在，无法打印");
		}
		if (StringUtils.isBlank(member.getAvatar())) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "会员照片不存在，无法打印");
		}
		// 英文名
		groomerCertificate.setEnName(member.getNameEn());
		if (StringUtils.isBlank(groomerCertificate.getEnName())) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "英文名为空，无法打印");
		}
		// 审核人
		if (StringUtils.isBlank(groomerCertificate.getReviewer()) || "系统审核".equals(groomerCertificate.getReviewer())) {
			groomerCertificate.setReviewer("");
			List<GroomerQualificationCertificate> groomerQualificationCertificateList = groomerQualificationCertificateDao
					.getByMemberCode(groomerCertificate.getMemberCode());
			if (Collections3.isEmpty(groomerQualificationCertificateList)) {
				throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "审核人为空，无法打印");
			} else {
				for (GroomerQualificationCertificate data : groomerQualificationCertificateList) {
					if (StringUtils.isNotBlank(data.getReviewer())) {
						groomerCertificate.setReviewer(data.getReviewer());
						break;
					}
				}
			}
		}
		if (StringUtils.isBlank(groomerCertificate.getReviewer())) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "审核人为空，无法打印");
		}
		groomerCertificate.setImg(member.getAvatar());
		groomerCertificate.setPrintState("1");
		dao.updatePrintType(groomerCertificate);

		SysContext sysContext = new SysContext(null, null, null);
		sysContext.noStateExecute(sysContext, "国际宠物美容师证书打印", groomerCertificate.getMemberCode(),
				"international_groomer_certificate", groomerCertificate.getId(), groomerCertificate.getRunningNumber(),
				(str) -> {
				});
		expressQueueService.push(groomerCertificate.getMemberCode(), groomerCertificate.getRunningNumber(), "国际宠物美容师证书",
				groomerCertificate.getCertificateCode(), null); // GYH2 TODO

		model.addAttribute("groomerCertificate", groomerCertificate);
		if (groomerCertificate.getCertificateType().equals("ISPG")) {
			return "oa/groomer/ISPGPrint";
		} else {
			return "oa/groomer/IPGPrint";
		}

	}

	/**
	 * 国际高级宠物美容师资格证书 CKU-ISPG-20190001（年份+序号），依次递增 国际宠物美容师资格认证书
	 * CKU-IPG-20190001（年份+序号），依次递增 根据名字返回对应的递增证书码
	 *
	 * @param name
	 * @return
	 */

	public synchronized String getcertificateCode(String name) {
		StringBuilder certificateNumPrefix = new StringBuilder().append("CKU-").append(name).append("-")
				.append(Calendar.getInstance().get(Calendar.YEAR));
		Integer maxNum = dao.selectMaxCertificateNum(certificateNumPrefix.toString()) + 1;
		certificateNumPrefix.append(String.format("%04d", maxNum));
		return certificateNumPrefix.toString();
	}

	@Transactional(readOnly = false)

	public void updateDict(Integer num, String name) {
		Dict d = new Dict();
		d.setType("certificate_code_default");
		if ("国际高级宠物美容师资格证书".equals(name))
			d.setDescription("CKU-ISPG-");
		if ("国际宠物美容师资格认证书".equals(name))
			d.setDescription("CKU-IPG-");
		List<Dict> lst = dictService.findList(d);
		if (lst != null && lst.size() == 1)
			d = lst.get(0);
		d.setValue(num.toString());
		dictService.save(d);
	}

	@Transactional(readOnly = false)
	public void physicsDelete(String memberCode) {
		dao.physicsDelete(memberCode);
	}

	// @Transactional(readOnly = false)
	// public InternationalGroomerCertificate physicsByMemberCode(String memberCode)
	// {
	// return dao.getByMemcode(memberCode);
	// }

	/**
	 * 国际证书申请列表
	 * 
	 * @param request
	 * @return
	 */
	public RESTResponse getApplyList(HttpServletRequest request) {
		Member member = UserUtils.getLoginMember();
		// 查询是否申领
		InternationalGroomerCertificate ipg = dao.getEntityByMemberCode(member.getMemberCode(), "IPG");
		InternationalGroomerCertificate ispg = dao.getEntityByMemberCode(member.getMemberCode(), "ISPG");

		List<I18nApplyListVo> resultList = new ArrayList<>();
		// 已申领
		if (ipg != null || ispg != null) {
			// 国际证书
			I18nApplyListVo ipgVo = new I18nApplyListVo();
			ipgVo.setKey(ipg != null ? ipg.getCertificateType() : "");
			ipgVo.setUrl("/static/images/WechatIMG89.jpeg");
			ipgVo.setValue(ipg != null ? ipg.getCertificateCode() : "");
			resultList.add(ipgVo);
			// 国际高级证书
			I18nApplyListVo ispgVo = new I18nApplyListVo();
			ispgVo.setKey(ispg != null ? ispg.getCertificateType() : "");
			ispgVo.setUrl("/static/images/WechatIMG88.jpeg");
			ispgVo.setValue(ispg != null ? ispg.getCertificateCode() : "");
			resultList.add(ispgVo);
		} else { // 未申领
			Dict entity = new Dict();
			entity.setType("groomer_certificate_type");
			List<Dict> typeList = dictService.findList(entity);
			for (Dict dict : typeList) {
				I18nApplyListVo vo = new I18nApplyListVo();
				vo.setKey(dict.getValue());
				vo.setUrl(dict.getRemarks());
				vo.setValue(dict.getLabel());
				// 暂时展示高级宠物美容师
				vo.setShow(true);
				resultList.add(vo);
			}
		}
		return new RESTResponse("data", resultList);
	}

	/**
	 * 申领
	 * 
	 * @param request
	 * @return
	 */

	@Transactional(readOnly = false)
	public RESTResponse applyCertificate(HttpServletRequest request) {
		// 申请类型 IPG:普通 ISPG:高级
		String certificateType = request.getParameter("certificateType");
		// 验证时候是会员
		Member member = UserUtils.getLoginMember();
		// 验证是否可申领
		Map<String, String> map = isQualified(certificateType, member);
		if (map.get("rc").equals("-1")) {
			return new RESTResponse("data", map);
		}
		// 验证是否已申领
		InternationalGroomerCertificate temp = dao.getEntityByMemberCode(member.getMemberCode(), certificateType);
		if (temp != null) {
			throw new ZAException(ZAErrorCode.ZA_ERC_PAYMENTRECORD_MEMBERMONEY_STATE, "证书已申领");
		}
		// 申领
		InternationalGroomerCertificate entity = new InternationalGroomerCertificate();
		entity.setCertificateType(certificateType);
		// 生成CertificateCode
		entity.setCertificateCode(this.getcertificateCode(certificateType));
		entity.setMemberCode(member.getMemberCode());
		entity.setCnName(member.getName());
		entity.setPaymentState("2"); // 未缴费
		entity.setReviewState("1"); // 未审核
		entity.setReviewer("系统审核");
		entity.setReviewTime(new Date());
		entity.setPaymentTime(new Date());
		entity.setPrintState("0"); // 未打印
		entity.setCreateBy(member.getUser());
		entity.setCreateDate(new Date());
		entity.setDelFlag("0");
		entity.setApplyTime(new Date());
		entity.setTotalPrice("0");
		entity.setPaymentWay("25");

		// 生成申领记录
		this.save(entity);
		return new RESTResponse("data", this.convertI18nResultVo(member, entity));
	}

	public ApplyCertificateVo convertI18nResultVo(Member member, InternationalGroomerCertificate entity) {
		ApplyCertificateVo vo = new ApplyCertificateVo();
		vo.setMemberCode(entity.getMemberCode());
		vo.setCnName(vo.getCnName());
		vo.setMemberType(member.getMemberType());
		vo.setEndDate(DateUtils.format(member.getMemberEndDate(), "yyyy-MM-dd"));
		vo.setCertificateType(entity.getCertificateType());
		vo.setCertificateCode(entity.getCertificateCode());
		vo.setApplyCertificate("ISPG".equals(entity.getCertificateType()) ? "国际高级宠物美容师资格证" : "国际宠物美容师资格证");
		// 返回ChargingItemId
		PaymentChargingItem paymentChargingItem = paymentChargingItemService
				.getByShortName(entity.getCertificateType());
		vo.setChargingItemId(paymentChargingItem.getId());
		vo.setPrice(new BigDecimal(paymentChargingItem.getPrice()));
		return vo;
	}

	/**
	 * 根据证书类型判断是否可申领
	 * 
	 * @param certificateType
	 * @return
	 */
	public Map<String, String> isQualified(String certificateType, Member member) {
		Map<String, String> map = new HashMap<>();
		map.put("rc", "0");
		map.put("msg", "OK");
		switch (certificateType.toUpperCase()) {
		case "IPG":
			// 《国际宠物美容师资格认证书》申领条件
			// 1.申领者须为有效的CKU会员
			// 2.2019年7月1日之前获得《CKU宠物造型师/金牌造型师资格证书》者可直接申领
			map.put("rc", "-1");
			map.put("msg", "暂不支持申领");
			return map;
		case "ISPG":
			// 《国际高级宠物美容师资格证书》申领条件
			// 1.申领者须为有效的CKU美容师正式会员
			if (!MemberUtil.isActiveGroomer(member)) {
				map.put("rc", "-1");
				map.put("msg", "申请国际高级美容师资格证书须为CKUGC有效会员,请先完成CKUGC会员续费后再次申请!");
				return map;
			}
			// 2.拥有《CKU美容师资格证书》（教师级、A级、B级或C级）者可直接申领
			GroomerDiploma diploma = groomerDiplomaService.getDiplomaByMemberCode(member.getMemberCode());
			if (diploma == null) {
				map.put("rc", "-1");
				map.put("msg", "您暂不具备申领《国际高级美容师资格证书》资格，如有疑问致电协会客服咨询!");
				return map;
			}
		default:
			return map;
		}
	}

	@Transactional(readOnly = false)

	public Map customSelectMemberEndDate(String sql) {
		return dao.customSelectMemberEndDate(sql);
	}

	@Transactional(readOnly = false)
	public void restPrint(String id, Model model) {
		InternationalGroomerCertificate groomerCertificate = get(id);
		if (groomerCertificate == null) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "id错误，无法充值");
		}
		groomerCertificate.setPrintState("0");
		dao.updatePrintType(groomerCertificate);
	}

	public Integer countMemberCertificate(String memberCode, String certificateType) {
		return dao.countMemberCertificate(memberCode, certificateType);
	}

	@Transactional(readOnly = false)
	public void saveCertificate(InternationalGroomerCertificate internationalGroomerCertificate) {
		if (StringUtils.isNotBlank(internationalGroomerCertificate.getCertificateCode())) {
			super.save(internationalGroomerCertificate);
		} else {
			internationalGroomerCertificate.preInsert();
			dao.insertCertificate(internationalGroomerCertificate);
		}
	}
}
