package com.cku.oa.groomer.service;

import java.util.List;
import java.util.Objects;

import com.cku.core.ZAErrorCode;
import com.cku.core.ZAException;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.thinkgem.jeesite.common.persistence.Page;
import com.thinkgem.jeesite.common.service.CrudService;
import com.cku.oa.groomer.entity.GroomerCertificateChangeRule;
import com.cku.oa.groomer.dao.GroomerCertificateChangeRuleDao;

/**
 * 美容资格证书换发规则Service
 *
 * @author yuanshuai
 * @version 2024-02-18
 */
@Service
@Transactional(readOnly = true)
public class GroomerCertificateChangeRuleService extends CrudService<GroomerCertificateChangeRuleDao, GroomerCertificateChangeRule> {

	public GroomerCertificateChangeRule get(String id) {
		return super.get(id);
	}

	public List<GroomerCertificateChangeRule> findList(GroomerCertificateChangeRule groomerCertificateChangeRule) {
		return super.findList(groomerCertificateChangeRule);
	}

	public Page<GroomerCertificateChangeRule> findPage(Page<GroomerCertificateChangeRule> page, GroomerCertificateChangeRule groomerCertificateChangeRule) {
		return super.findPage(page, groomerCertificateChangeRule);
	}

	@Transactional(readOnly = false)
	public void save(GroomerCertificateChangeRule groomerCertificateChangeRule) {
		super.save(groomerCertificateChangeRule);
	}

	@Transactional(readOnly = false)
	public void delete(GroomerCertificateChangeRule groomerCertificateChangeRule) {
		super.delete(groomerCertificateChangeRule);
	}

	/**
	 * 根据参数获取规则
	 *
	 * @author yuanshuai
	 * @since 2024/2/19 16:00
	 */
	public GroomerCertificateChangeRule findRuleByCondition(Integer certificateCate, Integer certificateSource, String certificateLevel) {
		if (Objects.isNull(certificateCate)
				|| Objects.isNull(certificateSource)
				|| StringUtils.isBlank(certificateLevel)) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "参数有误");
		}
		return dao.findRuleByCondition(certificateCate, certificateSource, certificateLevel);
	}
}