package com.cku.oa.groomer.service;

import com.cku.core.ZAErrorCode;
import com.cku.core.ZAException;
import com.cku.oa.groomer.dao.CurriculumDao;
import com.cku.oa.groomer.entity.Curriculum;
import com.cku.oa.groomer.entity.GroomerCourse;
import com.cku.restful.v1.dog.vo.CurriculumVO;
import com.thinkgem.jeesite.common.persistence.Page;
import com.thinkgem.jeesite.common.service.CrudService;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.ArrayList;
import java.util.List;

/**
 *
 * @author cxt
 * @version 2017-06-19
 */
@Service
@Transactional
public class CurriculumService extends CrudService<CurriculumDao, Curriculum> {

    @Autowired
    private GroomerCourseService groomerCourseService;
    //查重
    public void ISrepeat(Curriculum curriculum){
        List<Curriculum> list = this.findList(new Curriculum());
        list.stream().filter((e)->{
            return e.getCurriculumIndex().equals(curriculum.getCurriculumIndex());
        }).forEach(e->{
            if(e!=null && !e.getId().equals(curriculum.getId())){
                throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "序号不允许重复！");
            }
        });
    }

    public List<CurriculumVO> findListByApp(HttpServletRequest request, HttpServletResponse response){
        Curriculum curriculum = new Curriculum();
        curriculum.setRecommend("1");
        Page<Curriculum> page = this.findPage(new Page<Curriculum>(request, response), curriculum);
        List<CurriculumVO> lists = new ArrayList<>();
        page.getList().forEach(e->{
            CurriculumVO curriculumVO = new CurriculumVO();
            BeanUtils.copyProperties(e, curriculumVO);
            if(StringUtils.isNotBlank(curriculumVO.getCurriculumPicture())){
                String path = request.getContextPath();
                String imgPath = request.getScheme()+"://"+request.getServerName()+":"+request.getServerPort()+path+"/api/v1/file/image/"+curriculumVO.getCurriculumPicture();
                curriculumVO.setCurriculumPicture(imgPath);
            }
            //
            //查询课程id
            if(StringUtils.isNotBlank(curriculumVO.getCurriculumType()) && StringUtils.isNotBlank(curriculumVO.getCurriculumJump())){
                //查询课程id
                GroomerCourse courseByCode = groomerCourseService.getCourseByCode(curriculumVO.getCurriculumJump());
                curriculumVO.setCourseId(courseByCode.getId());
            }
            lists.add(curriculumVO);
        });
        return lists;
    }

    public List<GroomerCourse>  getGroomerCourse(Curriculum curriculum){
        GroomerCourse groomerCourse = new GroomerCourse();
        groomerCourse.setCode(curriculum.getCurriculumJump());
        List<GroomerCourse> list = groomerCourseService.findList(groomerCourse);
        return list;
    }
}