/**
 * Copyright &copy; 2012-2014 <a href="https://github.com/thinkgem/jeesite">JeeSite</a> All rights reserved.
 */
package com.cku.oa.finance.web;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.shiro.SecurityUtils;
import org.apache.shiro.authz.UnauthenticatedException;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

import com.thinkgem.jeesite.common.config.Global;
import com.thinkgem.jeesite.common.persistence.Page;
import com.thinkgem.jeesite.common.web.BaseController;
import com.thinkgem.jeesite.common.utils.StringUtils;
import com.cku.oa.finance.entity.PaymentChargingItem;
import com.cku.oa.finance.service.PaymentChargingItemService;

/**
 * 收费项目Controller
 * @author lyy
 * @version 2016-07-21
 */
@Controller
@RequestMapping(value = "${adminPath}/finance/paymentChargingItem")
public class PaymentChargingItemController extends BaseController {

	@Autowired
	private PaymentChargingItemService paymentChargingItemService;
	
	@ModelAttribute
	public PaymentChargingItem get(@RequestParam(required=false) String id) {
		PaymentChargingItem entity = null;
		if (StringUtils.isNotBlank(id)){
			entity = paymentChargingItemService.get(id);
		}
		if (entity == null){
			entity = new PaymentChargingItem();
		}
		return entity;
	}
	
	@RequiresPermissions("finance:paymentChargingItem:view")
	@RequestMapping(value = {"list", ""})
	public String list(PaymentChargingItem paymentChargingItem, HttpServletRequest request, HttpServletResponse response, Model model) {
		Page<PaymentChargingItem> page = paymentChargingItemService.findPage(new Page<PaymentChargingItem>(request, response), paymentChargingItem); 
		model.addAttribute("page", page);
		return "oa/finance/paymentChargingItemList";
	}

	@RequiresPermissions("finance:paymentChargingItem:view")
	@RequestMapping(value = "form")
	public String form(PaymentChargingItem paymentChargingItem, Model model) {
		model.addAttribute("paymentChargingItem", paymentChargingItem);
		return "oa/finance/paymentChargingItemForm";
	}
	@RequiresPermissions("finance:paymentChargingItem:view")
	@RequestMapping(value = "view")
	public String view(PaymentChargingItem paymentChargingItem, Model model) {
		model.addAttribute("paymentChargingItem", paymentChargingItem);
		return "oa/finance/paymentChargingItemView";
	}
	@RequiresPermissions("finance:paymentChargingItem:view")
	@RequestMapping(value = "save")
	public String save(PaymentChargingItem paymentChargingItem, Model model, RedirectAttributes redirectAttributes) {
		boolean hasPermission = false;
		if(!StringUtils.isEmpty(paymentChargingItem.getId())){
			hasPermission = SecurityUtils.getSubject().isPermitted("finance:paymentChargingItem:edit");
		}else{
			hasPermission = SecurityUtils.getSubject().isPermitted("finance:paymentChargingItem:add");
		}
		if(hasPermission){
			if (!beanValidator(model, paymentChargingItem)){
				return form(paymentChargingItem, model);
			}
			paymentChargingItemService.save(paymentChargingItem);
			addMessage(redirectAttributes, "保存收费项目成功");
		}else{
			throw new UnauthenticatedException();
		}

		return "redirect:"+Global.getAdminPath()+"/finance/paymentChargingItem/?repage";
	}
	
	@RequiresPermissions("finance:paymentChargingItem:delete")
	@RequestMapping(value = "delete")
	public String delete(PaymentChargingItem paymentChargingItem, RedirectAttributes redirectAttributes) {
		paymentChargingItemService.delete(paymentChargingItem);
		addMessage(redirectAttributes, "删除收费项目成功");
		return "redirect:"+Global.getAdminPath()+"/finance/paymentChargingItem/?repage";
	}

}