/**
 * Copyright &copy; 2012-2014 <a href="https://github.com/thinkgem/jeesite">JeeSite</a> All rights reserved.
 */
package com.cku.oa.finance.service;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.cku.oa.finance.dao.PaymentOrderDao;
import com.cku.oa.finance.entity.PaymentOrder;
import com.thinkgem.jeesite.common.utils.DateUtils;

/**
 * 订单Service
 * 
 * @author lyy
 * @version 2016-08-04
 */
@Service
public class UnpayedOrderDeleteTaskService {

	private Logger logger = LoggerFactory.getLogger(UnpayedOrderDeleteTaskService.class);

	@Autowired
	private PaymentOrderDao dao;

	@Autowired
	private PaymentOrderService service;

	public int unpayedOrderDelete() {
		logger.info("计划任务-删除订单-开始");
		int count = 0;
		Date date = new Date();
		try {
			// 设置时间为当前日期0时0分0秒
			date = new SimpleDateFormat("yyyy-MM-dd").parse(DateUtils.getDate());
		} catch (ParseException e1) {
			e1.printStackTrace();
		}
		List<PaymentOrder> orders = dao.findUnpayedOrderByDate(date);
		for (PaymentOrder order : orders) {
			try {
				service.removeOrderTask(order);

				count++;
			} catch (Exception e) {
				e.printStackTrace();
			}
		}
		logger.info("计划任务-删除订单-结束");
		return count;
	}

}