package com.cku.oa.finance.service;

import java.util.List;

import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.cku.oa.finance.dao.PaymentPayLogDao;
import com.cku.oa.finance.entity.PaymentPayLog;
import com.thinkgem.jeesite.common.persistence.Page;
import com.thinkgem.jeesite.common.service.CrudService;

/**
 * 支付记录日志Service
 *
 * @author yuanshuai
 * @version 2018-08-10
 */
@Service
@Transactional(readOnly = true)
public class PaymentPayLogService extends CrudService<PaymentPayLogDao, PaymentPayLog> {

    public PaymentPayLog get(String id) {
        return super.get(id);
    }

    public List<PaymentPayLog> findByOrderId(String orderId) {
        return dao.getByOrderId(orderId);
    }

    public List<PaymentPayLog> findList(PaymentPayLog paymentPayLog) {
        return super.findList(paymentPayLog);
    }

    public Page<PaymentPayLog> findPage(Page<PaymentPayLog> page, PaymentPayLog paymentPayLog) {
        return super.findPage(page, paymentPayLog);
    }

    @Transactional(readOnly = false)
    public void save(PaymentPayLog paymentPayLog) {
        super.save(paymentPayLog);
    }


    /**
     * @Description： 保存支付日志
     * @author: yuanshuai
     * @date: 2018/8/10 17:24
     */
    @Transactional(readOnly = false)
    public void savePayLog(String orderId, String paymentWay) {
        List<PaymentPayLog> list = findByOrderId(orderId);
        PaymentPayLog paymentPayLog;
        if (list != null && list.size() > 0) {
            paymentPayLog = list.get(0);
        } else {
            paymentPayLog = new PaymentPayLog();
            paymentPayLog.setOrderId(orderId);
            paymentPayLog.setPayState("0");
        }
        paymentPayLog.setPayType(paymentWay);
        save(paymentPayLog);
    }

    /**
     * @Description： 更改订单号
     * @author: yuanshuai
     * @date: 2018/8/13 9:50
     */
    @Transactional(readOnly = false)
    public void updatePayInfo(String orderId, String transactionId, String payInfo) {
        List<PaymentPayLog> list = findByOrderId(orderId);
        PaymentPayLog paymentPayLog;
        if (list != null && list.size() > 0) {
            paymentPayLog = list.get(0);
        } else {
            paymentPayLog = new PaymentPayLog();
            paymentPayLog.setOrderId(orderId);
        }
        paymentPayLog.setTransactionId(transactionId);
        paymentPayLog.setPayInfo(payInfo);
        paymentPayLog.setPayState("1");
        paymentPayLog.preUpdate();
        dao.update(paymentPayLog);
    }
    
    /**
     * @Description： 更改订单号
     * @author: yuanshuai
     * @date: 2018/8/13 9:50
     */
    @Transactional(readOnly = false)
    public void updatePayInfo(String orderId, String transactionId, String payInfo,String payType) {
        List<PaymentPayLog> list = findByOrderId(orderId);
        PaymentPayLog paymentPayLog;
        if (list != null && list.size() > 0) {
            paymentPayLog = list.get(0);
        } else {
            paymentPayLog = new PaymentPayLog();
            paymentPayLog.setOrderId(orderId);
        }
        paymentPayLog.setTransactionId(transactionId);
        paymentPayLog.setPayInfo(payInfo);
        paymentPayLog.setPayState("1");
        paymentPayLog.setPayType(payType);
        paymentPayLog.preUpdate();
        dao.update(paymentPayLog);
    }

    /**
     * @Description： 修改支付状态
     * @author: yuanshuai
     * @date: 2018/8/13 14:12
     */
    @Transactional(readOnly = false)
    public void updatePayState(String orderId, String payState, String error) {
        PaymentPayLog paymentPayLog = new PaymentPayLog();
        paymentPayLog.setOrderId(orderId);
        paymentPayLog.setPayState(payState);
        paymentPayLog.setError(error);
        paymentPayLog.preUpdate();
        dao.updatePayState(paymentPayLog);
    }
    
    /**
     * 
     * @param orderId
     * @param payState
     */
    @Transactional(readOnly = false)
    public void updatePayType(String orderId, String payType) {
        PaymentPayLog log = new PaymentPayLog();
        log.setPayType(payType);
        log.setOrderId(orderId);
        log.preUpdate();
        dao.updatePayType(log);
    }

}