package com.cku.oa.finance.service;

import com.cku.core.ZAException;
import com.cku.oa.finance.dao.PaymentOnAccountDao;
import com.cku.oa.finance.entity.PaymentOnAccount;
import com.cku.oa.finance.entity.PaymentRecord;
import com.cku.oa.sys.code.SysCodeUtil;
import com.cku.oa.sys.service.user.MemberService;
import com.thinkgem.jeesite.common.persistence.Page;
import com.thinkgem.jeesite.common.service.CrudService;
import com.thinkgem.jeesite.common.utils.StringUtils;
import com.thinkgem.jeesite.modules.sys.utils.UserUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.List;

/**
 * 资金挂账Service
 * @author lyy
 * @version 2016-08-16
 */
@Service
@Transactional(readOnly = true)
public class PaymentOnAccountService extends CrudService<PaymentOnAccountDao, PaymentOnAccount> {
	@Autowired
	private MemberService memberService;
	@Autowired
	private PaymentRecordService paymentRecordService;
	@Autowired
	private PaymentOnAccountDao paymentOnAccountDao;

	public PaymentOnAccount get(String id) {
		return super.get(id);
	}

	public List<PaymentOnAccount> findList(PaymentOnAccount paymentOnAccount) {
		return super.findList(paymentOnAccount);
	}

	public Page<PaymentOnAccount> findPage(Page<PaymentOnAccount> page, PaymentOnAccount paymentOnAccount) {
		return super.findPage(page, paymentOnAccount);
	}

	@Transactional(readOnly = false)
	public void save(PaymentOnAccount paymentOnAccount) {
		super.save(paymentOnAccount);
	}

	/**
	 * 资金挂账录入
	 * @param paymentOnAccount
	 */
	@Transactional(readOnly = false)
	public void saveOnAccount(PaymentOnAccount paymentOnAccount){
//		Member member = memberService.getByMemberCode(paymentOnAccount.getMemberCode());
//		if(member!=null){
		paymentOnAccount.setIsChange("0");
		paymentOnAccount.setBalance(paymentOnAccount.getMoney());
		paymentOnAccount.setLog(UserUtils.getUser().getName()+":挂账"+paymentOnAccount.getMoney()+"元。");
		paymentOnAccount.preInsert();
		dao.insert(paymentOnAccount);
//		}else{
//			throw new ZAException(-1,"无此会员");
//		};
	}

	/**
	 * 挂账转入
	 *
	 *
	 * @param paymentOnAccount
	 */
	@Transactional(readOnly = false)
	public void changeAccount(PaymentOnAccount paymentOnAccount) throws ZAException{
		PaymentOnAccount old = new PaymentOnAccount(paymentOnAccount.getId());
		old = dao.get(old);
		//TODO 这种在内存里计算钱，还没有做好数据库事务锁的方式是极其危险的行为
		//TODO 暂时没有时间修改，我先放过，稍后必须处理这段代码  fanhuibin
		BigDecimal oldBalance = new BigDecimal(old.getBalance());
		BigDecimal nowBalance = new BigDecimal(paymentOnAccount.getMoney());
		if(oldBalance.compareTo(nowBalance)>=0){
			SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
			paymentOnAccount.setLog(paymentOnAccount.getLog()+"<br/>"+UserUtils.getUser().getName()+"：会员号("+paymentOnAccount.getMemberCode()+")转入"+paymentOnAccount.getMoney()+"元。"+format.format(paymentOnAccount.getAddTime())+(StringUtils.isNotBlank(paymentOnAccount.getProccessRemarks())?"备注:"+paymentOnAccount.getProccessRemarks():"备注:无"));
			paymentOnAccount.setBalance(nowBalance.toString());
			if(oldBalance.compareTo(nowBalance)==0){
				paymentOnAccount.setIsChange("1");
			}else{
				paymentOnAccount.setIsChange("0");
			}
			dao.changeAccount(paymentOnAccount);
			String runningNum = SysCodeUtil.getPayRunningNumber();
			memberService.memberRecharge(paymentOnAccount.getMemberCode(),paymentOnAccount.getMoney(),null,runningNum);
			PaymentRecord insertRecord = new PaymentRecord();
			insertRecord.setMemberCode(paymentOnAccount.getMemberCode());
			insertRecord.setPaymentAmount(paymentOnAccount.getMoney());
			insertRecord.setPrice(paymentOnAccount.getMoney());
			insertRecord.setChargingItemId("0");
			insertRecord.setChargingItemNum(1);
			insertRecord.setPaymentRemarks("转账转入"+UserUtils.getUser().getName()+"：会员号("+paymentOnAccount.getMemberCode()+")转入"+paymentOnAccount.getMoney()+"元。"+format.format(paymentOnAccount.getAddTime())+(StringUtils.isNotBlank(paymentOnAccount.getProccessRemarks())?"备注:"+paymentOnAccount.getProccessRemarks():"备注:无"));
			insertRecord.setPaymentWay(paymentOnAccount.getPaymentWay());
			insertRecord.setPaymentTime(paymentOnAccount.getAddTime());
			insertRecord.setRunningNumber(runningNum);
			insertRecord.setPaymentState("2");
			paymentRecordService.newRecord(insertRecord);
		}else{
			throw new ZAException(-1,"扣款金额大于余额！");
		}

	}
	@Transactional(readOnly = false)
	public void delete(PaymentOnAccount paymentOnAccount) {
		super.delete(paymentOnAccount);
	}
	public String findTotalMoney() {
		String total = paymentOnAccountDao.findTotalMoney();
		return total;
	}


}