package com.cku.oa.dog.web;

import com.cku.core.RESTResponse;
import com.cku.core.ZAException;
import com.cku.oa.dog.entity.DogStickerApply;
import com.cku.oa.dog.service.DogStickerApplyService;
import com.cku.restful.v1.dog.service.RestDogStickerApplyService;
import com.cku.util.ServletUtils;
import com.thinkgem.jeesite.common.config.Global;
import com.thinkgem.jeesite.common.persistence.Page;
import com.thinkgem.jeesite.common.utils.StringUtils;
import com.thinkgem.jeesite.common.web.BaseController;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;

/**
 * 等级贴纸申请Controller
 *
 * @author lgl
 * @version 2018-11-21
 */
@Controller
@RequestMapping(value = "${adminPath}/dog/dogStickerApply")
public class DogStickerApplyController extends BaseController {

    @Autowired
    private DogStickerApplyService dogStickerApplyService;
    @Autowired
    private RestDogStickerApplyService restDogStickerApplyService;
    private static final String REPAGE = "redirect:" + Global.getAdminPath() + "/dog/dogStickerApply/?repage";

    private static final String AUTHORITY_PRDFIX = "dog:dogStickerApply:";

    @ModelAttribute
    public DogStickerApply get(@RequestParam(required = false) String id) {
        DogStickerApply entity = null;
        if (StringUtils.isNotBlank(id)) {
            entity = dogStickerApplyService.get(id);
        }
        if (entity == null) {
            entity = new DogStickerApply();
        }
        return entity;
    }

    @RequiresPermissions(AUTHORITY_PRDFIX + "view")
    @RequestMapping(value = {"list", ""})
    public String list(DogStickerApply dogStickerApply, HttpServletRequest request, HttpServletResponse response, Model model) {
        Page<DogStickerApply> page = dogStickerApplyService.findPage(new Page<DogStickerApply>(request, response), dogStickerApply);
        for (DogStickerApply po : page.getList()) {
            po.setAlreadyHaveClass(dogStickerApplyService.getStickerClass(po.getAlreadyHaveClass()));
            po.setApplyClass(dogStickerApplyService.getStickerClass(po.getApplyClass()));
            po.setBusinessStates(dogStickerApplyService.getBusinessStates(po));
        }
        model.addAttribute("page", page);
        return "oa/dog/dogstickerapply/dogStickerApplyList";
    }

    @RequiresPermissions(AUTHORITY_PRDFIX + "view")
    @RequestMapping(value = "form")
    public String form(DogStickerApply dogStickerApply, Model model) {
        model.addAttribute("dogStickerApply", dogStickerApply);
        return "oa/dog/dogstickerapply/dogStickerApplyForm";
    }

    @RequiresPermissions(AUTHORITY_PRDFIX + "print")
    @RequestMapping(value = "printSticker")
    public String printSticker(DogStickerApply dogStickerApply, Model model, RedirectAttributes redirectAttributes) {
        try {
            return dogStickerApplyService.printSticker(dogStickerApply.getId(),model);
        } catch (ZAException e) {
            logger.warn("打印出错",e);
            addMessage(redirectAttributes, "打印出错:"+e.getMessage());
            return REPAGE;
        }
    }


    @RequiresPermissions(AUTHORITY_PRDFIX + "print")
    @RequestMapping(value = "resetPrintSticker")
    public String resetPrintSticker(DogStickerApply dogStickerApply, Model model) {
        dogStickerApplyService.resetPrintSticker(dogStickerApply);
        return REPAGE;
    }

    @RequiresPermissions(AUTHORITY_PRDFIX + "print")
    @RequestMapping(value = "printRegisterCard")
    public String printRegisterCard(DogStickerApply dogStickerApply, Model model, RedirectAttributes redirectAttributes) {
        try {
            return dogStickerApplyService.printRegisterCard(dogStickerApply,model);
        } catch (ZAException e) {
            logger.warn("打印出错",e);
            addMessage(redirectAttributes, "打印出错:"+e.getMessage());
            return REPAGE;
        }
    }


    @RequiresPermissions(AUTHORITY_PRDFIX + "print")
    @RequestMapping(value = "resetPrintRegisterCard")
    public String resetPrintRegisterCard(DogStickerApply dogStickerApply, Model model) {
        dogStickerApplyService.resetPrintRegisterCard(dogStickerApply);
        return REPAGE;
    }

    @RequestMapping(value = "save", method = RequestMethod.POST)
    public void post(HttpServletRequest request, HttpServletResponse response) throws IOException {
        RESTResponse result = new RESTResponse();
        try{
            result = dogStickerApplyService.post(request);
        }catch (Exception e){
            result.setRc(1);
            result.setMsg(e.getMessage());
        }
        ServletUtils.writeResponse(response, result);
    }
}