/**
 * Copyright &copy; 2012-2014 <a href="https://github.com/thinkgem/jeesite">JeeSite</a> All rights reserved.
 */
package com.cku.oa.dog.web;

import com.cku.core.ResultDto;
import com.cku.core.ZAErrorCode;
import com.cku.core.ZAException;
import com.cku.oa.dog.entity.Dog;
import com.cku.oa.dog.entity.DogDna;
import com.cku.oa.dog.service.DogDnaService;
import com.cku.oa.dog.service.DogService;
import com.thinkgem.jeesite.common.config.Global;
import com.thinkgem.jeesite.common.persistence.Page;
import com.thinkgem.jeesite.common.utils.StringUtils;
import com.thinkgem.jeesite.common.web.BaseController;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

/**
 * 犬DNAController
 *
 * @author lgl
 * @version 2016-08-08
 */
@Controller
@RequestMapping(value = "${adminPath}/dna/dogDna")
public class DogDnaController extends BaseController {

	@Autowired
	private DogDnaService dogDnaService;
	@Autowired
	private DogService dogService;

	@ModelAttribute
	public DogDna get(@RequestParam(required = false) String id) {
		DogDna entity = null;
		if (StringUtils.isNotBlank(id)) {
			entity = dogDnaService.get(id);
		}
		if (entity == null) {
			entity = new DogDna();
		}
		return entity;
	}

	@RequiresPermissions("dna:dogDna:view")
	@RequestMapping(value = {"list", ""})
	public String list(DogDna dogDna, HttpServletRequest request, HttpServletResponse response, Model model) {
		Page<DogDna> page = dogDnaService.findPage(new Page<>(request, response), dogDna);
		model.addAttribute("page", page);
		return "oa/dog/dna/dogDnaList";
	}

	@RequiresPermissions("dna:dogDna:view")
	@RequestMapping(value = "viewForm")
	public String viewForm(DogDna dogDna, Model model) {
		model.addAttribute("dogDna", dogDna);
		model.addAttribute("isView", 1);
		return "oa/dog/dna/dogDnaForm";
	}

	@RequiresPermissions("dna:dogDna:edit")
	@RequestMapping(value = "editForm")
	public String editForm(DogDna dogDna, Model model) {
		Dog dog = dogService.get(dogDna.getDogId());
		dogDna.setDogBreed(dog.getDogBreed());
		model.addAttribute("dogDna", dogDna);
		model.addAttribute("isView", 0);
		return "oa/dog/dna/dogDnaForm";
	}

	@RequiresPermissions("dna:dogDna:edit")
	@RequestMapping(value = "save")
	@ResponseBody
	public ResultDto<String> save(DogDna dogDna) {
		try {
			restBeanValidator(dogDna);
			dogDnaService.buildAndSave(dogDna);
		} catch (ZAException e) {
			e.printStackTrace();
			return ResultDto.error(ZAErrorCode.ZA_VALID_FAILED, "保存DNA信息失败：" + e.getMessage());
		}
		return ResultDto.success("保存DNA信息成功");
	}

	@RequiresPermissions("dna:dogDna:active")
	@GetMapping(value = "active")
	@ResponseBody
	public ResultDto<String> active(DogDna dogDna) {
		try {
			dogDnaService.active(dogDna);
		} catch (ZAException e) {
			e.printStackTrace();
			return ResultDto.error(ZAErrorCode.ZA_VALID_FAILED, "激活DNA信息失败：" + e.getMessage());
		}
		return ResultDto.success("激活DNA信息成功");
	}

	@RequiresPermissions("dna:dogDna:del")
	@RequestMapping(value = "delete")
	public String delete(DogDna dogDna, RedirectAttributes redirectAttributes) {
		try {
			dogDnaService.delete(dogDna);
			addMessage(redirectAttributes, "删除DNA信息成功");
		} catch (ZAException e) {
			addMessage(redirectAttributes, "删除DNA信息失败：" + e.getMessage());
		}
		return "redirect:" + Global.getAdminPath() + "/dna/dogDna/?repage&dogId=" + dogDna.getDogId();
	}

}