package com.cku.oa.dog.service.dogamphimixis;

import com.cku.core.ZAErrorCode;
import com.cku.core.ZAException;
import com.cku.oa.dog.dao.DogDao;
import com.cku.oa.dog.dao.DogPedigreeCertifiedChangeDao;
import com.cku.oa.dog.dao.dogamphimixis.DogAmphimixisProveDao;
import com.cku.oa.dog.entity.Dog;
import com.cku.oa.dog.entity.dogamphimixis.DogAmphimixisProve;
import com.cku.oa.dog.service.DogTypeService;
import com.thinkgem.jeesite.common.persistence.Page;
import com.thinkgem.jeesite.common.service.CrudService;
import com.thinkgem.jeesite.common.utils.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 换发配种证明Service
 *
 * @author cxt
 * @version 2016-09-10
 */
@Service
@Transactional(readOnly = true)
public class DogAmphimixisProveService extends
		CrudService<DogAmphimixisProveDao, DogAmphimixisProve> {

	@Autowired
	public DogDao dogDao;
	@Autowired
	public DogPedigreeCertifiedChangeDao dogPedigreeCertifiedChangeDao;
	@Autowired
	public DogAmphimixisProveDao dogAmphimixisProveDao;
	@Autowired
	public DogTypeService dogTypeService;

	public DogAmphimixisProve get(String id) {
		return super.get(id);
	}

	public List<DogAmphimixisProve> findList(
			DogAmphimixisProve dogAmphimixisProve) {
		return super.findList(dogAmphimixisProve);
	}

	public Page<DogAmphimixisProve> findPage(Page<DogAmphimixisProve> page,
			DogAmphimixisProve dogAmphimixisProve) {
		return super.findPage(page, dogAmphimixisProve);
	}

	@Transactional(readOnly = false)
	public void save(DogAmphimixisProve dogAmphimixisProve) throws ZAException {
		String fdogPedigreeCertified = dogAmphimixisProve
				.getFdogPedigreeCertified();
		String mdogPedigreeCertified = dogAmphimixisProve
				.getMdogPedigreeCertified();
		String[] numberBirthArr = dogAmphimixisProve.getNumberBirths().split(",");
		Integer numberBirths = Integer.parseInt(numberBirthArr[0])+Integer.parseInt(numberBirthArr[1]);
		if(numberBirths <= 0){
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "本胎数量应大于零");
		}
		String[] numberRegisteredDogsArr = dogAmphimixisProve.getNumberRegisteredDogs().split(",");
		Integer numberRegisteredDogs = Integer.parseInt(numberRegisteredDogsArr[0])+Integer.parseInt(numberRegisteredDogsArr[1]);
		if(numberRegisteredDogs <= 0){
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "登记犬数应大于零");
		}

		Dog fdog = StringUtils.isBlank(fdogPedigreeCertified)?null:dogDao.getByPedigreeCertifiedCode(fdogPedigreeCertified);
		Dog mdog = StringUtils.isBlank(mdogPedigreeCertified)?null:dogDao.getByPedigreeCertifiedCode(mdogPedigreeCertified);
		if (fdog == null || mdog == null) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "无犬只信息,请查询求证后填写");
		}
		String fgender = fdog.getGender();
		String mgender = mdog.getGender();
		if (!fgender.equals("1")) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED,
					"请填写性别为公的同种犬只证书号");
		}
		if (!mgender.equals("2")) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED,
					"请填写性别为母的同种犬只证书号");
		}
		if (!dogTypeService.isSameType(dogAmphimixisProve.getDogBreed(),
				fdog.getDogBreed())) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "公犬种不符");
		}
		if (!dogTypeService.isSameType(dogAmphimixisProve.getDogBreed(),
				mdog.getDogBreed())) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "母犬种不符");
		}
		// 如果已经存在，更新，如果不存在，插入
		List<DogAmphimixisProve> list = dao.getByFmDog(dogAmphimixisProve
				.getFmdogBreedCertifiedCode());
		if (list.size() > 0) {
			dogAmphimixisProve.setId(list.get(0).getId());
			// 根据配种证明号更新犬表父犬血统证书号、母犬血统证书号、繁殖人
			dogAmphimixisProveDao.updateDogByFmdogBreedCertifiedCode(
					dogAmphimixisProve.getFmdogBreedCertifiedCode(),
					fdogPedigreeCertified, mdogPedigreeCertified,
					dogAmphimixisProve.getBreeder());
		}
		super.save(dogAmphimixisProve);
		String changeId = dogAmphimixisProve.getChangeId();
		if (changeId != null || !"".equals(changeId)) {
			dogPedigreeCertifiedChangeDao.updateFm(
					dogAmphimixisProve.getFmdogBreedCertifiedCode(), changeId);
		}
	}

	@Transactional(readOnly = false)
	public void delete(DogAmphimixisProve dogAmphimixisProve) {
		super.delete(dogAmphimixisProve);
	}

	/**
	 *
	 * @description: 根据配种证明号查询信息
	 * @author: laiguanglong
	 * @date: 2016年10月29日 下午3:42:53
	 */
	public Object getByFmdogBreedCertifiedCode(String fmdogBreedCertifiedCode) {
		Map<String, Object> map = new HashMap<String, Object>();
		List<DogAmphimixisProve> list = dao.getByFmDog(fmdogBreedCertifiedCode);
		DogAmphimixisProve dogAmphimixisProve = null;
		if (list.size() > 0) {
			dogAmphimixisProve = list.get(0);
		}
		map.put("dogAmphimixisProve", dogAmphimixisProve);
		return map;
	}

	/**
	 * 编辑回显
	 *
	 * @Author chaixueteng
	 * @2016年9月12日下午7:26:47
	 */
	public DogAmphimixisProve getByfmdog(String fmdogBreedCertifiedCode) {
		List<DogAmphimixisProve> byFmDog = dao
				.getByFmDog(fmdogBreedCertifiedCode);
		return byFmDog.get(0);
	}

	/**
	 * 根据配种证明号查询配种信息
	 *
	 * @Author chaixueteng
	 * @2016年9月13日下午6:25:21
	 */
	public DogAmphimixisProve getMsg(String fmdogBreedCertifiedCode) {
		List<DogAmphimixisProve> byFmDog = dao
				.getByFmDog(fmdogBreedCertifiedCode);
		if(byFmDog.size()==0){
			return null;
		}
		return byFmDog.get(0);
	}

	/**
	 * 根据配犬证明号查询犬只信息
	 *
	 * @Author chaixueteng
	 * @2016年9月21日上午10:52:17
	 */
	public Map<String, String> getFM(String fmdogBreedCertifiedCode) {
		Map<String, String> map = new HashMap<String, String>();
		List<DogAmphimixisProve> byFmDog = dao
				.getByFmDog(fmdogBreedCertifiedCode);
		if (byFmDog.size() > 0) {
			map.put("rc", "0");
			DogAmphimixisProve dap = byFmDog.get(0);
			map.put("fdogPedigreeCertified", dap.getFdogPedigreeCertified());
			map.put("mdogPedigreeCertified", dap.getMdogPedigreeCertified());
			Dog fdog = StringUtils.isBlank(dap.getFdogPedigreeCertified())?null:dogDao.getByPedigreeCertifiedCode(dap
					.getFdogPedigreeCertified());
			Dog mdog = StringUtils.isBlank(dap.getMdogPedigreeCertified())?null:dogDao.getByPedigreeCertifiedCode(dap
					.getMdogPedigreeCertified());
			if (fdog != null) {
				map.put("fdogName", fdog.getNameEn());
			}
			if (mdog != null) {
				map.put("mdogName", mdog.getNameEn());
			}
		} else {
			map.put("rc", "1");
			map.put("error", "无数据!");
		}
		return map;
	}

	public void checkCertified(String dogPedigreeCertified, String a,
			String dogBreed) throws ZAException {
		if ("1".equals(a)) {
			Dog fdog = StringUtils.isBlank(dogPedigreeCertified)?null:dogDao.getByPedigreeCertifiedCode(dogPedigreeCertified);
			if (fdog == null) {
				throw new ZAException(ZAErrorCode.ZA_VALID_FAILED,
						"无犬只信息,请查询求证后填写");
			} else {
				String fgender = fdog.getGender().trim();
				if (!fgender.equals("1")) {
					throw new ZAException(ZAErrorCode.ZA_VALID_FAILED,
							"请填写性别为公的同种犬只证书号");
				}
				if (!dogTypeService.isSameType(dogBreed, fdog.getDogBreed())) {
					throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "公犬种不符");
				}
			}
		} else {
			Dog mdog = StringUtils.isBlank(dogPedigreeCertified)?null:dogDao.getByPedigreeCertifiedCode(dogPedigreeCertified);
			if (mdog == null) {
				throw new ZAException(ZAErrorCode.ZA_VALID_FAILED,
						"无犬只信息,请查询求证后填写");
			} else {
				String mgender = mdog.getGender();
				if (!mgender.equals("2")) {
					throw new ZAException(ZAErrorCode.ZA_VALID_FAILED,
							"请填写性别为母的同种犬只证书号");
				}
				if (!dogTypeService.isSameType(dogBreed, mdog.getDogBreed())) {
					throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "母犬种不符");
				}
			}
		}
	}

}