package com.cku.oa.dog.service;

import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

import net.sf.json.JSONObject;

import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.cku.core.ZAErrorCode;
import com.cku.core.ZAException;
import com.cku.oa.dog.dao.DogBreedCertifiedDao;
import com.cku.oa.dog.dao.DogDao;
import com.cku.oa.dog.entity.Dog;
import com.cku.oa.dog.entity.DogBreedCertified;
import com.cku.oa.dog.entity.DogBreedPrint;
import com.cku.oa.dog.entity.DogDna;
import com.cku.oa.finance.entity.PaymentOrder;
import com.cku.oa.finance.service.PaymentOrderService;
import com.cku.oa.show.dao.ChildShowsDao;
import com.cku.oa.sys.code.SysCodeUtil;
import com.cku.oa.sys.service.ExpressQueueService;
import com.cku.oa.sys.service.LoginServerService;
import com.cku.oa.sys.zalog.SysContext;
import com.cku.util.Debugger;
import com.thinkgem.jeesite.common.persistence.Page;
import com.thinkgem.jeesite.common.service.CrudService;

/**
 * 繁育证书Service
 * @author zhuoHeng
 * @version 2016-08-22
 */
@Service
@Transactional(readOnly = true)
public class DogBreedCertifiedService extends CrudService<DogBreedCertifiedDao, DogBreedCertified> {

    @Autowired
    public ChildShowsDao childShowsDao;
    @Autowired
	private ExpressQueueService expressQueueService;
    @Autowired
	private PaymentOrderService paymentOrderService;
    @Autowired 
    private DogDao dogDao;
    @Autowired 
    private LoginServerService loginServerService;
    
    /**
     * 获取单条记录并查询犬只存在成绩的赛事名称
     */
	public DogBreedCertified get(String id) {
	    DogBreedCertified dogBreedCertified = super.get(id);
	    if(Objects.nonNull(dogBreedCertified)) {
	    	List<String> showNames = childShowsDao.getShowsNameOfBreed(dogBreedCertified.getDog().getPedigreeCertifiedCode());
		    dogBreedCertified.setChildShowsList(showNames);	
	    }
		return dogBreedCertified;
	}
	
	public List<DogBreedCertified> findList(DogBreedCertified dogBreedCertified) {
    	if(StringUtils.isBlank(dogBreedCertified.getDogBreed())){
    		//根据当前登录端查询犬种
    		dogBreedCertified.getSqlMap().put("dogBreedMap", loginServerService.dataScopeFilter());
    	}else{
    		dogBreedCertified.getSqlMap().put("dogBreedMap", " ='"+dogBreedCertified.getDogBreed()+"'");
    	}
		return super.findList(dogBreedCertified);
	}
	
	public Page<DogBreedCertified> findPage(Page<DogBreedCertified> page, DogBreedCertified dogBreedCertified) {
    	if(StringUtils.isBlank(dogBreedCertified.getDogBreed())){
    		//根据当前登录端查询犬种
    		dogBreedCertified.getSqlMap().put("dogBreedMap", loginServerService.dataScopeFilter());
    	}else{
    		dogBreedCertified.getSqlMap().put("dogBreedMap", " ='"+dogBreedCertified.getDogBreed()+"'");
    	}
		return super.findPage(page, dogBreedCertified);
	}
	
	@Transactional(readOnly = false)
	public void save(DogBreedCertified dogBreedCertified) {
		super.save(dogBreedCertified);
	}
	
	@Transactional(readOnly = false)
	public void delete(DogBreedCertified dogBreedCertified) {
		//已缴费的订单不允许删除
		if("2".equals(dogBreedCertified.getPaymentState())){
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "该订单已缴费，不允许删除");
		}
		super.delete(dogBreedCertified);
	}

	/**
	 * 
	 * @Description：保存繁育证书信息
	 * @author: zhuoHeng
	 * @version: 2016年8月23日 下午5:47:33
	 */
	@Transactional(readOnly = false)
    public void edit(DogBreedCertified dogBreedCertified) {
        dogBreedCertified.setUpdateDate(new Date());
        dao.edit(dogBreedCertified);
    }

	/**
	 * 
	 * @Description：更改繁育证书处理状态并生成繁育证书编号
	 * @author: zhuoHeng
	 * @version: 2016年8月24日 上午11:47:14
	 */
	@Transactional(readOnly = false)
    public void changeProcessState(DogBreedCertified dogBreedCertified)throws ZAException {
        DogBreedCertified breedCertified = super.get(dogBreedCertified.getId());
        SysContext sysContext = new SysContext(breedCertified.getPaymentState(),breedCertified.getReviewState(),
                breedCertified.getProcessState()==null?"0":breedCertified.getProcessState());
        sysContext.updateData(sysContext,"新生犬登记",breedCertified.getDog().getMemberCode(),"dog_breed_certified",breedCertified.getId(),breedCertified.getRunningNumber(),(str)->{});
        //付款状态为已缴费、审核状态为通过、存在比赛成绩或繁育成绩，方可进行状态处理
        if("2".equals(breedCertified.getPaymentState())&&"1".equals(breedCertified.getReviewState())&&
                breedCertified.getBreedResults()!=null&&!"".equals(breedCertified.getBreedResults())){
            if(breedCertified.getDogId()!=null&&!"".equals(breedCertified.getDogId())){
                //生成繁育证书号
                dogBreedCertified.setBreedCertifiedCode(SysCodeUtil.getBreedCertifiedCode(breedCertified.getDog().getDogBreed())); 
                dogBreedCertified.setProcessState("1");
                dogBreedCertified.setProcessTime(new Date());
                dogBreedCertified.setPrintState("0");
                dogBreedCertified.setUpdateDate(new Date());
                dao.changeProcessState(dogBreedCertified);
            } else {
                throw new ZAException(-1, "当前数据缺少犬只信息");
            }
        } else {
            throw new ZAException(-1, "数据为[已缴费][审核通过][已完成繁殖成绩上传]才可进行此操作");
        }
    }
	
    /**
     * 
     * @description: 获取已付款待审核的繁育证书登录申请记录数
     * @author: laiguanglong
     * @date: 2016年8月29日 下午4:52:58
     */
	public int getAuditCount(){
		DogBreedCertified dogBreedCertified = new DogBreedCertified();
		//已付款
		dogBreedCertified.setPaymentState("2");
		//未审核
		dogBreedCertified.setReviewState("0");
		return dao.listCount(dogBreedCertified);
	}
	
	/**
	 * 
	 * @description: 根据犬id查询繁育证书申请记录
	 * @author: laiguanglong
	 * @date: 2016年8月30日 下午6:16:18
	 */
	public DogBreedCertified getByDogId(String dogId){
		return dao.getByDogId(dogId);
	}

	/**
	 * 
	 * @Description：获取繁育证书打印所需信息
	 * @author: zhuoHeng
	 * @version: 2016年9月2日 上午10:42:11
	 */
    public String getPrintMessage(String fmdogBreedCertifiedCode,String dogId) {
        Map<String, Object> map = new HashMap<String, Object>();
        DogBreedPrint dogBreedPrint = dao.getPrintMessage(fmdogBreedCertifiedCode);
        DogDna dogDna = dao.getDogDnaMessage(dogId);
        Dog dog = dogDao.get(dogId);
        map.put("breedCertifiedCode", dogBreedPrint==null?"":dogBreedPrint.getBreedCertifiedCode());
        map.put("maleDogName", dog==null?"":dog.getFdogPedigreeCertified());
        map.put("femaleDogName", dog==null?"":dog.getMdogPedigreeCertified());
        map.put("femaleDogOwner", dog==null?"":dog.getBreeder());
        map.put("addRess", dogBreedPrint==null?"":dogBreedPrint.getAddRess());
        map.put("dnaCode", dogDna==null?"":dogDna.getDnaCode());
        map.put("dnaResult", dogDna==null?"":dogDna.getDnaResult().replaceAll("	", ","));
        return JSONObject.fromObject(map).toString();
    }
    
    /**
     * 
     * @Description：繁育证书打印状态维护、推送待邮寄证书信息
     * @author: zhuoHeng
     * @version: 2016年9月5日 下午1:35:57
     */
    @Transactional(readOnly = false)
	public void print(DogBreedCertified dogBreedCertified) {
    	DogBreedCertified model = super.get(dogBreedCertified.getId());
		dogBreedCertified.setPrintState("1");
		dogBreedCertified.setPrintTime(new Date());
		dao.print(dogBreedCertified);
		expressQueueService.push(model.getDog().getMemberCode(), model.getRunningNumber(), "繁育证书", model.getBreedCertifiedCode(),"19"); //GYH1 modified
		SysContext sysContext = new SysContext(null,null,null);
		sysContext.noStateExecute(sysContext,"繁育证书打印",dogBreedCertified.getDog().getMemberCode(),"dog_breed_certified",dogBreedCertified.getId(),dogBreedCertified.getRunningNumber(),(str)->{});
		
	}
    
    /**
     * 
     * @Description：重置打印状态
     * @author: zhuoHeng
     * @version: 2016年9月5日 下午3:21:54
     */
    @Transactional(readOnly = false)
    public void resetPrint(DogBreedCertified dogBreedCertified) {
    	dogBreedCertified.setPrintState("0");
	    dao.resetPrintState(dogBreedCertified);
    }
    /**
     * 
     * @Description：添加繁育证书订单业务信息
     * @author: zhuoHeng
     * @version: 2016年9月5日 下午7:14:04
     */
    @Transactional(readOnly = false)
	public void add(DogBreedCertified dogBreedCertified) throws ZAException{
		dogBreedCertified.setCreateDate(new Date());
		dogBreedCertified.setReviewState("0");
		dogBreedCertified.setReviewTime(new Date());
		dogBreedCertified.setPaymentState("2");
		PaymentOrder paymentOrder = paymentOrderService.getByOrderCode(dogBreedCertified.getRunningNumber());
		dogBreedCertified.setPaymentTime(paymentOrder.getCreateDate());
		dogBreedCertified.setProcessState("0");
		//根据血统证书号查询该犬是否存在繁育数据
		DogBreedCertified breedCertified = dao.getByDogId(dogBreedCertified.getDogId());
		Debugger.doAssert(breedCertified==null, -1, "该犬只已存在繁育数据！");
		dogBreedCertified.setIsNewRecord(Boolean.TRUE);
		super.save(dogBreedCertified);
	}
    /**
     * 
     * @Description：繁育证书审核功能
     * @author: zhuoHeng
     * @version: 2016年10月11日 下午6:20:43
     */
    @Transactional(readOnly = false)
	public void changeStatus(DogBreedCertified dogBreedCertified) throws ZAException{
    	DogBreedCertified dogBreedCertifiedModel = super.get(dogBreedCertified.getId());
	    String reviewState = dogBreedCertifiedModel.getReviewState();
	    //特殊处理，因犬主变更审核不通过的数据可以修改为审核通过，此处将审核未通过的状态当成未审核来处理，以迎合状态机公用
	    if("2".equals(dogBreedCertifiedModel.getReviewState())){
	    	reviewState = "0";
	    }
	    SysContext sysContext = new SysContext(dogBreedCertifiedModel.getPaymentState(),reviewState,
	    		dogBreedCertifiedModel.getProcessState()==null?"0":dogBreedCertifiedModel.getProcessState());
	    if("1".equals(dogBreedCertified.getReviewState())){
            sysContext.confirmSuccess(sysContext,"繁育证书",dogBreedCertifiedModel.getDog().getMemberCode(),"dog_breed_certified",dogBreedCertifiedModel.getId(),dogBreedCertifiedModel.getRunningNumber(),(str)->{
                if(dogBreedCertifiedModel.getDogId()!=null&&!"".equals(dogBreedCertifiedModel.getDogId())){
                	dogBreedCertified.setReviewRemarks("");
                } else {
                    throw new ZAException(-1, "未找到有效的血统证书号");
                }
                
            });
        } else if("2".equals(dogBreedCertified.getReviewState())){
            sysContext.confirmFail(sysContext,"繁育证书",dogBreedCertified.getReviewRemarks(),dogBreedCertifiedModel.getDog().getMemberCode(),"dog_breed_certified",dogBreedCertifiedModel.getId(),dogBreedCertifiedModel.getRunningNumber(),(str)->{
            	
            });
        }
	    dogBreedCertified.setReviewTime(new Date());
        dao.changeStatus(dogBreedCertified);
	}
}