/**
 * Copyright &copy; 2012-2014 <a href="https://github.com/thinkgem/jeesite">JeeSite</a> All rights reserved.
 */
package com.cku.oa.dog.entity;

import java.util.Date;

import org.hibernate.validator.constraints.Length;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.thinkgem.jeesite.common.persistence.DataEntity;

/**
 * DNA双亲比对审核表Entity
 * @author xx
 * @version 2024-04-25
 */
public class DogDnaParentsCompareAudit extends DataEntity<DogDnaParentsCompareAudit> {
	
	private static final long serialVersionUID = 1L;
	private String dogDnaParentsCompareId;		// 双亲对比记录ID
	private String fdogPedigreeCertified;		// 父犬血统证书号
	private String mdogPedigreeCertified;		// 母犬血统证书号
	private String fdogMemberCode;		// 父犬主会员号
	private String fdogMemberName;		// 父犬主会员
	private String fdogReviewState;		// 父犬主审核状态 0未审核 1同意 2不同意
	private Date fdogReviewTime;		// 父犬主审核时间
	private String fdogReviewRemarks;		// 父犬主审核意见
	private String fdogReviewUserId;		// 父犬主审核人ID
	private String mdogMemberCode;		// 母犬主会员号
	private String mdogMemberName;		// 母犬主会员
	private String mdogReviewState;		// 母犬主审核状态 0未审核 1同意 2不同意
	private Date mdogReviewTime;		// 母犬主审核时间
	private String mdogReviewRemarks;		// 母犬主审核意见
	private String mdogReviewUserId;		// 母犬主审核人ID
	
	public DogDnaParentsCompareAudit() {
		super();
	}

	public DogDnaParentsCompareAudit(String id){
		super(id);
	}
	
	public String getFdogMemberName() {
		return fdogMemberName;
	}

	public void setFdogMemberName(String fdogMemberName) {
		this.fdogMemberName = fdogMemberName;
	}

	public String getMdogMemberName() {
		return mdogMemberName;
	}

	public void setMdogMemberName(String mdogMemberName) {
		this.mdogMemberName = mdogMemberName;
	}

	@Length(min=0, max=32, message="双亲对比记录ID长度必须介于 0 和 32 之间")
	public String getDogDnaParentsCompareId() {
		return dogDnaParentsCompareId;
	}

	public void setDogDnaParentsCompareId(String dogDnaParentsCompareId) {
		this.dogDnaParentsCompareId = dogDnaParentsCompareId;
	}
	
	@Length(min=0, max=100, message="父犬血统证书号长度必须介于 0 和 100 之间")
	public String getFdogPedigreeCertified() {
		return fdogPedigreeCertified;
	}

	public void setFdogPedigreeCertified(String fdogPedigreeCertified) {
		this.fdogPedigreeCertified = fdogPedigreeCertified;
	}
	
	@Length(min=0, max=100, message="母犬血统证书号长度必须介于 0 和 100 之间")
	public String getMdogPedigreeCertified() {
		return mdogPedigreeCertified;
	}

	public void setMdogPedigreeCertified(String mdogPedigreeCertified) {
		this.mdogPedigreeCertified = mdogPedigreeCertified;
	}
	
	@Length(min=0, max=50, message="父犬主会员号长度必须介于 0 和 50 之间")
	public String getFdogMemberCode() {
		return fdogMemberCode;
	}

	public void setFdogMemberCode(String fdogMemberCode) {
		this.fdogMemberCode = fdogMemberCode;
	}
	
	@Length(min=0, max=1, message="父犬主审核状态 0未审核 1同意 2不同意长度必须介于 0 和 1 之间")
	public String getFdogReviewState() {
		return fdogReviewState;
	}

	public void setFdogReviewState(String fdogReviewState) {
		this.fdogReviewState = fdogReviewState;
	}
	
	@JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
	public Date getFdogReviewTime() {
		return fdogReviewTime;
	}

	public void setFdogReviewTime(Date fdogReviewTime) {
		this.fdogReviewTime = fdogReviewTime;
	}
	
	@Length(min=0, max=100, message="父犬主审核意见长度必须介于 0 和 100 之间")
	public String getFdogReviewRemarks() {
		return fdogReviewRemarks;
	}

	public void setFdogReviewRemarks(String fdogReviewRemarks) {
		this.fdogReviewRemarks = fdogReviewRemarks;
	}
	
	@Length(min=0, max=50, message="父犬主审核人ID长度必须介于 0 和 50 之间")
	public String getFdogReviewUserId() {
		return fdogReviewUserId;
	}

	public void setFdogReviewUserId(String fdogReviewUserId) {
		this.fdogReviewUserId = fdogReviewUserId;
	}
	
	@Length(min=0, max=50, message="母犬主会员号长度必须介于 0 和 50 之间")
	public String getMdogMemberCode() {
		return mdogMemberCode;
	}

	public void setMdogMemberCode(String mdogMemberCode) {
		this.mdogMemberCode = mdogMemberCode;
	}
	
	@Length(min=0, max=1, message="母犬主审核状态 0未审核 1同意 2不同意长度必须介于 0 和 1 之间")
	public String getMdogReviewState() {
		return mdogReviewState;
	}

	public void setMdogReviewState(String mdogReviewState) {
		this.mdogReviewState = mdogReviewState;
	}
	
	@JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
	public Date getMdogReviewTime() {
		return mdogReviewTime;
	}

	public void setMdogReviewTime(Date mdogReviewTime) {
		this.mdogReviewTime = mdogReviewTime;
	}
	
	@Length(min=0, max=100, message="母犬主审核意见长度必须介于 0 和 100 之间")
	public String getMdogReviewRemarks() {
		return mdogReviewRemarks;
	}

	public void setMdogReviewRemarks(String mdogReviewRemarks) {
		this.mdogReviewRemarks = mdogReviewRemarks;
	}
	
	@Length(min=0, max=50, message="母犬主审核人ID长度必须介于 0 和 50 之间")
	public String getMdogReviewUserId() {
		return mdogReviewUserId;
	}

	public void setMdogReviewUserId(String mdogReviewUserId) {
		this.mdogReviewUserId = mdogReviewUserId;
	}
	
}