/**
 * Copyright &copy; 2012-2014 <a href="https://github.com/thinkgem/jeesite">JeeSite</a> All rights reserved.
 */
package com.cku.oa.dog.entity;

import com.cku.oa.finance.entity.PaymentChargingItem;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.thinkgem.jeesite.common.persistence.DataEntity;
import org.hibernate.validator.constraints.Length;
import org.hibernate.validator.constraints.NotBlank;

import java.util.Date;

/**
 * 出生证明Entity
 *
 * @author lgl
 * @version 2016-08-04
 */
public class DogBirthCertificate extends DataEntity<DogBirthCertificate> {

	private static final long serialVersionUID = 1L;
	private String birthCerRegCode; // 出生证明登记编号
	private String pedigreeCertified; // 血统证书号
	private String dogOwenr; // 犬主人
	private String memberCode; // 会员号
	private String secondDogOwner; // 第二犬主
	private String secondOwnerMemberCode; // 第二犬主会员号
	private String breederMemberCode; // 繁殖人会员号
	private String breeder; // 繁殖人
	private String secondBreederMemberCode; // 第二繁殖人会员号
	private String secondBreeder; // 第二繁殖人
	private String tempMemberCode; // 临时会员号
	private String tempUserName; // 临时用户名
	private String dogEnName; // 英文姓名
	private String dogGender; // 性别
	private String dogBreed; // 种类
	private Date dogBirthday; // 出生日期
	private String sameBatchNum; // 同胎犬数
	private String identificationFlag; // 身份识别标志
	private String cabPassport; // 宠爱护照号
	private String cabRegisterCode; // 宠爱登记卡号
	private String colorFlag; // 颜色及标志
	private String colorFlagEn; // 颜色及标志

	private String dna; // dna
	private String fdogPedigreeCertified; // 父犬血统证书号
	private String mdogPedigreeCertified; // 母犬血统证书号
	private String fmdogBreedCertifiedCode; // 父母犬配犬证明号
	private String operator; // 操作人
	private String price; // 单价
	private String deduction; // 抵扣
	private String addUser; // 添加用户
	private String urgent; // 是否加急
	private Date chipInjectDate; // 芯片注入时间
	private String snCode; // 识别码
	private String businessBan; // 业务禁止：0正常；1禁止繁殖(禁止提交配种证明，出生纸；禁止报名比赛；禁止办理出口血统证书)
	private String showBan; // 赛事禁止 ：0正常；1禁止赛事
	private String printType; // 打印类型
	private String classPrintStatus; // 等级贴纸打印状态1：未打印，9：已打印
	private Date sendDate; // 邮寄日期
	private String regetNewBirthCode; // 重领新出生纸编号。该字段有值表示该记录已重领
	private String regetOldBirthCode; // 重领旧出生纸编号。该字段有值表示该记录由出生纸重领业务生成
	private String reviewState; // 审核状态
	private Date reviewTime; // 审核时间
	private String reviewRemarks; // 审核的意见
	private String runningNumber; // 流水号
	private String paymentState; // 付款的状态
	private Date paymentTime; // 付款时间
	private Date processTime; // 流程变更的时间
	private String processState; // 流程状态
	private Date beginCreateDate; // 开始 create_date
	private Date endCreateDate; // 结束 create_date

	private String breedCnName; // 犬种类中文名称
	private String paymentChargingItemId; // 收费项id

	private String agency; // 办事处，用于筛选记录
	private DogChipChange dogChipChange;// 芯片变更记录表
	private DogChip dogChip; // 犬只芯片表
	private Dog dog; // 犬只表
	private String newbornPrintType;// 配种证明表中的打印类型（自主、协会）

	private String token; // 宠爱宝访问令牌
	private String businessState; // 业务状态
	private String reGetType; // 重领类型
	private String ecertFlag; // 电子证书标记位：0否；1是

	private PaymentChargingItem paymentChargingItem; // 出生纸收费项
	private String dogOwnerSite; // 狗主人会员类型
	private String couponCode; // 优惠劵
	private String dogBreedCnName;
	private String activitionState;// 激活状态
	private String cabPassportLike;// 护照号模糊查询字段
	private String printStatus;// 打印状态
	private String upperStatus;// 上架状态
	private String stickerNo; // 等级贴纸号码
	private String upperReview; // dog_activation '上架审核状态：未审核0；通过1；未通过2',
	private String state;// dog_activation'上架状态：0未上架；1已上架',
	private String isAll;// 是否整窝办理：是：1 、否：0,

	private String firstStatus; // 置顶功能 空或者1是未置顶，2是已置顶

	private String reviewStateExclud; // 排除的审核状态
	private boolean classPrintFlag;

	private String kinGetDna;
	private String callName;    //呼名
	
	private String fMemberCode; 
	private String MMemberCode; 
	
	public String getfMemberCode() {
		return fMemberCode;
	}

	public void setfMemberCode(String fMemberCode) {
		this.fMemberCode = fMemberCode;
	}

	public String getMMemberCode() {
		return MMemberCode;
	}

	public void setMMemberCode(String mMemberCode) {
		MMemberCode = mMemberCode;
	}

	public String getSecondBreederMemberCode() {
		return secondBreederMemberCode;
	}

	public void setSecondBreederMemberCode(String secondBreederMemberCode) {
		this.secondBreederMemberCode = secondBreederMemberCode;
	}

	public String getSecondBreeder() {
		return secondBreeder;
	}

	public void setSecondBreeder(String secondBreeder) {
		this.secondBreeder = secondBreeder;
	}

	public boolean isClassPrintFlag() {
		return classPrintFlag;
	}

	public void setClassPrintFlag(boolean classPrintFlag) {
		this.classPrintFlag = classPrintFlag;
	}

	private String noseId; // 鼻纹ID-第三方

	public String getNoseId() {
		return noseId;
	}

	public void setNoseId(String noseId) {
		this.noseId = noseId;
	}

	public String getReviewStateExclud() {
		return reviewStateExclud;
	}

	public void setReviewStateExclud(String reviewStateExclud) {
		this.reviewStateExclud = reviewStateExclud;
	}

	public String getStickerNo() {
		return stickerNo;
	}

	public void setStickerNo(String stickerNo) {
		this.stickerNo = stickerNo;
	}

	public String getFirstStatus() {
		return firstStatus;
	}

	public void setFirstStatus(String firstStatus) {
		this.firstStatus = firstStatus;
	}

	public String getIsAll() {
		return isAll;
	}

	public void setIsAll(String isAll) {
		this.isAll = isAll;
	}

	public String getUpperReview() {
		return upperReview;
	}

	public void setUpperReview(String upperReview) {
		this.upperReview = upperReview;
	}

	public String getState() {
		return state;
	}

	public void setState(String state) {
		this.state = state;
	}

	public String getUpperStatus() {
		return upperStatus;
	}

	public void setUpperStatus(String upperStatus) {
		this.upperStatus = upperStatus;
	}

	public String getActivitionState() {
		return activitionState;
	}

	public void setActivitionState(String activitionState) {
		this.activitionState = activitionState;
	}

	public String getClassPrintStatus() {
		return classPrintStatus;
	}

	public void setClassPrintStatus(String classPrintStatus) {
		this.classPrintStatus = classPrintStatus;
	}

	public String getPrintStatus() {
		return printStatus;
	}

	public void setPrintStatus(String printStatus) {
		this.printStatus = printStatus;
	}

	public String getCabPassportLike() {
		return cabPassportLike;
	}

	public void setCabPassportLike(String cabPassportLike) {
		this.cabPassportLike = cabPassportLike;
	}

	public String getDogBreedCnName() {
		return dogBreedCnName;
	}

	public void setDogBreedCnName(String dogBreedCnName) {
		this.dogBreedCnName = dogBreedCnName;
	}

	public String getDogOwnerSite() {
		return dogOwnerSite;
	}

	public void setDogOwnerSite(String dogOwnerSite) {
		this.dogOwnerSite = dogOwnerSite;
	}

	public Dog getDog() {
		return dog;
	}

	public void setDog(Dog dog) {
		this.dog = dog;
	}

	public DogBirthCertificate() {
		super();
	}

	public DogBirthCertificate(String id) {
		super(id);
	}

	public DogChip getDogChip() {
		return dogChip;
	}

	public void setDogChip(DogChip dogChip) {
		this.dogChip = dogChip;
	}

	public DogChipChange getDogChipChange() {
		return dogChipChange;
	}

	public void setDogChipChange(DogChipChange dogChipChange) {
		this.dogChipChange = dogChipChange;
	}

	@Length(min = 0, max = 255, message = "出生证明登记编号长度必须介于 0 和 255 之间")
	public String getBirthCerRegCode() {
		return birthCerRegCode;
	}

	public void setBirthCerRegCode(String birthCerRegCode) {
		this.birthCerRegCode = birthCerRegCode;
	}

	@Length(min = 0, max = 255, message = "血统证书号长度必须介于 0 和 255 之间")
	public String getPedigreeCertified() {
		return pedigreeCertified;
	}

	public void setPedigreeCertified(String pedigreeCertified) {
		this.pedigreeCertified = pedigreeCertified;
	}

	@Length(min = 0, max = 50, message = "犬主人长度必须介于 0 和 50 之间")
	public String getDogOwenr() {
		return dogOwenr;
	}

	public void setDogOwenr(String dogOwenr) {
		this.dogOwenr = dogOwenr;
	}

	@Length(min = 0, max = 50, message = "会员号长度必须介于 0 和 50 之间")
	public String getMemberCode() {
		return memberCode;
	}

	public void setMemberCode(String memberCode) {
		this.memberCode = memberCode;
	}

	@Length(min = 0, max = 50, message = "第二犬主长度必须介于 0 和 50 之间")
	public String getSecondDogOwner() {
		return secondDogOwner;
	}

	public void setSecondDogOwner(String secondDogOwner) {
		this.secondDogOwner = secondDogOwner;
	}

	@Length(min = 0, max = 50, message = "第二犬主会员号长度必须介于 0 和 50 之间")
	public String getSecondOwnerMemberCode() {
		return secondOwnerMemberCode;
	}

	public void setSecondOwnerMemberCode(String secondOwnerMemberCode) {
		this.secondOwnerMemberCode = secondOwnerMemberCode;
	}

	@Length(min = 0, max = 50, message = "繁殖人会员号长度必须介于 0 和 50 之间")
	public String getBreederMemberCode() {
		return breederMemberCode;
	}

	public void setBreederMemberCode(String breederMemberCode) {
		this.breederMemberCode = breederMemberCode;
	}

	@Length(min = 0, max = 50, message = "繁殖人长度必须介于 0 和 50 之间")
	public String getBreeder() {
		return breeder;
	}

	public void setBreeder(String breeder) {
		this.breeder = breeder;
	}

	@Length(min = 0, max = 50, message = "临时会员号长度必须介于 0 和 50 之间")
	public String getTempMemberCode() {
		return tempMemberCode;
	}

	public void setTempMemberCode(String tempMemberCode) {
		this.tempMemberCode = tempMemberCode;
	}

	@Length(min = 0, max = 50, message = "临时用户名长度必须介于 0 和 50 之间")
	public String getTempUserName() {
		return tempUserName;
	}

	public void setTempUserName(String tempUserName) {
		this.tempUserName = tempUserName;
	}

	@NotBlank
	@Length(min = 0, max = 255, message = "英文姓名长度必须介于 0 和 255 之间")
	public String getDogEnName() {
		return dogEnName;
	}

	public void setDogEnName(String dogEnName) {
		this.dogEnName = dogEnName;
	}

	@Length(min = 0, max = 10, message = "性别长度必须介于 0 和 10 之间")
	public String getDogGender() {
		return dogGender;
	}

	public void setDogGender(String dogGender) {
		this.dogGender = dogGender;
	}

	@Length(min = 0, max = 50, message = "种类长度必须介于 0 和 50 之间")
	public String getDogBreed() {
		return dogBreed;
	}

	public void setDogBreed(String dogBreed) {
		this.dogBreed = dogBreed;
	}

	@JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
	public Date getDogBirthday() {
		return dogBirthday;
	}

	public void setDogBirthday(Date dogBirthday) {
		this.dogBirthday = dogBirthday;
	}

	@Length(min = 0, max = 50, message = "同胎犬数长度必须介于 0 和 50 之间")
	public String getSameBatchNum() {
		return sameBatchNum;
	}

	public void setSameBatchNum(String sameBatchNum) {
		this.sameBatchNum = sameBatchNum;
	}

	@Length(min = 0, max = 255, message = "身份识别标志长度必须介于 0 和 255 之间")
	public String getIdentificationFlag() {
		return identificationFlag;
	}

	public void setIdentificationFlag(String identificationFlag) {
		this.identificationFlag = identificationFlag;
	}

	public String getCabPassport() {
		return cabPassport;
	}

	public void setCabPassport(String cabPassport) {
		this.cabPassport = cabPassport;
	}

	public String getCabRegisterCode() {
		return cabRegisterCode;
	}

	public void setCabRegisterCode(String cabRegisterCode) {
		this.cabRegisterCode = cabRegisterCode;
	}

	@NotBlank
	@Length(min = 0, max = 50, message = "颜色及标志长度必须介于 0 和 50 之间")
	public String getColorFlag() {
		return colorFlag;
	}

	public void setColorFlag(String colorFlag) {
		this.colorFlag = colorFlag;
	}

	@Length(min = 0, max = 255, message = "dna长度必须介于 0 和 255 之间")
	public String getDna() {
		return dna;
	}

	public void setDna(String dna) {
		this.dna = dna;
	}

	@Length(min = 0, max = 100, message = "父犬血统证书号长度必须介于 0 和 100 之间")
	public String getFdogPedigreeCertified() {
		return fdogPedigreeCertified;
	}

	public void setFdogPedigreeCertified(String fdogPedigreeCertified) {
		this.fdogPedigreeCertified = fdogPedigreeCertified;
	}

	@Length(min = 0, max = 100, message = "母犬血统证书号长度必须介于 0 和 100 之间")
	public String getMdogPedigreeCertified() {
		return mdogPedigreeCertified;
	}

	public void setMdogPedigreeCertified(String mdogPedigreeCertified) {
		this.mdogPedigreeCertified = mdogPedigreeCertified;
	}

	@Length(min = 0, max = 100, message = "父母犬配犬证明号长度必须介于 0 和 100 之间")
	public String getFmdogBreedCertifiedCode() {
		return fmdogBreedCertifiedCode;
	}

	public void setFmdogBreedCertifiedCode(String fmdogBreedCertifiedCode) {
		this.fmdogBreedCertifiedCode = fmdogBreedCertifiedCode;
	}

	@Length(min = 0, max = 255, message = "操作人长度必须介于 0 和 255 之间")
	public String getOperator() {
		return operator;
	}

	public void setOperator(String operator) {
		this.operator = operator;
	}

	public String getPrice() {
		return price;
	}

	public void setPrice(String price) {
		this.price = price;
	}

	@Length(min = 0, max = 11, message = "抵扣长度必须介于 0 和 11 之间")
	public String getDeduction() {
		return deduction;
	}

	public void setDeduction(String deduction) {
		this.deduction = deduction;
	}

	@Length(min = 0, max = 50, message = "添加用户长度必须介于 0 和 50 之间")
	public String getAddUser() {
		return addUser;
	}

	public void setAddUser(String addUser) {
		this.addUser = addUser;
	}

	@Length(min = 0, max = 10, message = "是否加急长度必须介于 0 和 10 之间")
	public String getUrgent() {
		return urgent;
	}

	public void setUrgent(String urgent) {
		this.urgent = urgent;
	}

	@JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
	public Date getChipInjectDate() {
		return chipInjectDate;
	}

	public void setChipInjectDate(Date chipInjectDate) {
		this.chipInjectDate = chipInjectDate;
	}

	@Length(min = 0, max = 100, message = "识别码长度必须介于 0 和 100 之间")
	public String getSnCode() {
		return snCode;
	}

	public void setSnCode(String snCode) {
		this.snCode = snCode;
	}

	public String getBusinessBan() {
		return businessBan;
	}

	public void setBusinessBan(String businessBan) {
		this.businessBan = businessBan;
	}

	public String getPrintType() {
		return printType;
	}

	public void setPrintType(String printType) {
		this.printType = printType;
	}

	public Date getSendDate() {
		return sendDate;
	}

	public void setSendDate(Date sendDate) {
		this.sendDate = sendDate;
	}

	public String getRegetNewBirthCode() {
		return regetNewBirthCode;
	}

	public void setRegetNewBirthCode(String regetNewBirthCode) {
		this.regetNewBirthCode = regetNewBirthCode;
	}

	public String getRegetOldBirthCode() {
		return regetOldBirthCode;
	}

	public void setRegetOldBirthCode(String regetOldBirthCode) {
		this.regetOldBirthCode = regetOldBirthCode;
	}

	@Length(min = 0, max = 20, message = "审核状态长度必须介于 0 和 20 之间")
	public String getReviewState() {
		return reviewState;
	}

	public void setReviewState(String reviewState) {
		this.reviewState = reviewState;
	}

	@JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
	public Date getReviewTime() {
		return reviewTime;
	}

	public void setReviewTime(Date reviewTime) {
		this.reviewTime = reviewTime;
	}

	@Length(min = 0, max = 255, message = "审核的意见长度必须介于 0 和 255 之间")
	public String getReviewRemarks() {
		return reviewRemarks;
	}

	public void setReviewRemarks(String reviewRemarks) {
		this.reviewRemarks = reviewRemarks;
	}

	@Length(min = 0, max = 100, message = "流水号长度必须介于 0 和 100 之间")
	public String getRunningNumber() {
		return runningNumber;
	}

	public void setRunningNumber(String runningNumber) {
		this.runningNumber = runningNumber;
	}

	@Length(min = 0, max = 20, message = "付款的状态长度必须介于 0 和 20 之间")
	public String getPaymentState() {
		return paymentState;
	}

	public void setPaymentState(String paymentState) {
		this.paymentState = paymentState;
	}

	@JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
	public Date getPaymentTime() {
		return paymentTime;
	}

	public void setPaymentTime(Date paymentTime) {
		this.paymentTime = paymentTime;
	}

	@JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
	public Date getProcessTime() {
		return processTime;
	}

	public void setProcessTime(Date processTime) {
		this.processTime = processTime;
	}

	@Length(min = 0, max = 20, message = "流程状态长度必须介于 0 和 20 之间")
	public String getProcessState() {
		return processState;
	}

	public void setProcessState(String processState) {
		this.processState = processState;
	}

	public Date getBeginCreateDate() {
		return beginCreateDate;
	}

	public void setBeginCreateDate(Date beginCreateDate) {
		this.beginCreateDate = beginCreateDate;
	}

	public Date getEndCreateDate() {
		return endCreateDate;
	}

	public void setEndCreateDate(Date endCreateDate) {
		this.endCreateDate = endCreateDate;
	}

	public String getBreedCnName() {
		return breedCnName;
	}

	public void setBreedCnName(String breedCnName) {
		this.breedCnName = breedCnName;
	}

	public String getPaymentChargingItemId() {
		return paymentChargingItemId;
	}

	public void setPaymentChargingItemId(String paymentChargingItemId) {
		this.paymentChargingItemId = paymentChargingItemId;
	}

	public String getAgency() {
		return agency;
	}

	public void setAgency(String agency) {
		this.agency = agency;
	}

	public String getNewbornPrintType() {
		return newbornPrintType;
	}

	public void setNewbornPrintType(String newbornPrintType) {
		this.newbornPrintType = newbornPrintType;
	}

	public PaymentChargingItem getPaymentChargingItem() {
		return paymentChargingItem;
	}

	public void setPaymentChargingItem(PaymentChargingItem paymentChargingItem) {
		this.paymentChargingItem = paymentChargingItem;
	}

	public String getToken() {
		return token;
	}

	public void setToken(String token) {
		this.token = token;
	}

	public String getBusinessState() {
		return businessState;
	}

	public void setBusinessState(String businessState) {
		this.businessState = businessState;
	}

	public String getReGetType() {
		return reGetType;
	}

	public void setReGetType(String reGetType) {
		this.reGetType = reGetType;
	}

	public String getEcertFlag() {
		return ecertFlag;
	}

	public void setEcertFlag(String ecertFlag) {
		this.ecertFlag = ecertFlag;
	}

	public String getCouponCode() {
		return couponCode;
	}

	public void setCouponCode(String couponCode) {
		this.couponCode = couponCode;
	}

	public String getShowBan() {
		return showBan;
	}

	public void setShowBan(String showBan) {
		this.showBan = showBan;
	}

	public String getKinGetDna() {
		return kinGetDna;
	}

	public void setKinGetDna(String kinGetDna) {
		this.kinGetDna = kinGetDna;
	}

	public String getCallName() {
		return callName;
	}

	public void setCallName(String callName) {
		this.callName = callName;
	}
	
	public String getColorFlagEn() {
		return colorFlagEn;
	}

	public void setColorFlagEn(String colorFlagEn) {
		this.colorFlagEn = colorFlagEn;
	}

	@Override
	public String toString() {
		return "DogBirthCertificate [birthCerRegCode=" + birthCerRegCode + ", pedigreeCertified=" + pedigreeCertified
				+ ", memberCode=" + memberCode + ", identificationFlag=" + identificationFlag
				+ ", fmdogBreedCertifiedCode=" + fmdogBreedCertifiedCode + ", addUser=" + addUser + "]";
	}



}