/**
 * Copyright &copy; 2012-2014 <a href="https://github.com/thinkgem/jeesite">JeeSite</a> All rights reserved.
 */
package com.cku.oa.dog.dao.dogamphimixis;

import java.util.List;

import org.apache.ibatis.annotations.Param;

import com.cku.oa.dog.entity.dogamphimixis.DogAmphimixisProve;
import com.thinkgem.jeesite.common.persistence.CrudDao;
import com.thinkgem.jeesite.common.persistence.annotation.MyBatisDao;

/**
 * 换发配种证明DAO接口
 * 
 * @author cxt
 * @version 2016-09-10
 */
@MyBatisDao
public interface DogAmphimixisProveDao extends CrudDao<DogAmphimixisProve> {
	// 配犬证明号重复校验
	List<DogAmphimixisProve> getByFmDog(
			@Param("fmdogBreedCertifiedCode") String fmdogBreedCertifiedCode);

	// 根据配种证明号更新犬表父犬血统证书号、母犬血统证书号、繁殖人
	void updateDogByFmdogBreedCertifiedCode(
			@Param("fmdogBreedCertifiedCode") String fmdogBreedCertifiedCode,
			@Param("fdogPedigreeCertified") String fdogPedigreeCertified,
			@Param("mdogPedigreeCertified") String mdogPedigreeCertified,
			@Param("breeder") String breeder);
}