package com.cku.oa.breeder.service;

import com.cku.core.ZAErrorCode;
import com.cku.core.ZAException;
import com.cku.oa.breeder.dao.BannerDao;
import com.cku.oa.breeder.entity.Banner;
import com.cku.oa.constant.Constants;
import com.thinkgem.jeesite.common.persistence.Page;
import com.thinkgem.jeesite.common.service.CrudService;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;
import java.util.Objects;

/**
 * 繁育人BannerService
 *
 * @author lgl
 * @version 2017-10-11
 */
@Service
@Transactional(readOnly = true)
public class BannerService extends CrudService<BannerDao, Banner> {

	public Banner get(String id) {
		return super.get(id);
	}

	public List<Banner> findList(Banner banner) {
		return super.findList(banner);
	}

	public Page<Banner> findPage(Page<Banner> page, Banner banner) {
		return super.findPage(page, banner);
	}

	@Transactional(readOnly = false)
	public void save(Banner banner) {
		if (banner.getType() != null) {
			if (Objects.equals(banner.getType(), Constants.STRING_ZERO)) {
				banner.setProgramId(null);
			} else {
				if (StringUtils.isBlank(banner.getProgramId())) {
					throw new ZAException(ZAErrorCode.ZA_ERROR, "类型为小程序时,小程序Id不能为空");
				}
			}
		}
		super.save(banner);
	}

	@Transactional(readOnly = false)
	public void delete(Banner banner) {
		super.delete(banner);
	}

}