package com.cku.catx.member.web;

import com.cku.core.ResultDto;
import com.cku.core.ZAErrorCode;
import com.cku.core.ZAException;
import com.cku.oa.finance.dao.PaymentOrderDao;
import com.cku.oa.finance.service.PaymentOrderService;
import com.cku.oa.sys.entity.user.IEnum;
import com.cku.oa.sys.entity.user.Member;
import com.cku.oa.sys.entity.user.MemberCardTypeEnum;
import com.cku.oa.sys.service.UserService;
import com.cku.oa.sys.service.user.MemberService;
import com.thinkgem.jeesite.common.config.Global;
import com.thinkgem.jeesite.common.persistence.Page;
import com.thinkgem.jeesite.common.utils.StringUtils;
import com.thinkgem.jeesite.common.web.BaseController;
import com.thinkgem.jeesite.modules.sys.service.SystemService;
import com.thinkgem.jeesite.modules.sys.utils.UserUtils;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

/**
 * 宠爱天下会员管理
 */
@Controller
@RequestMapping(value = "${adminPath}/catx/member")
public class CATXMemberController extends BaseController {

	@Autowired
	private MemberService memberService;

	@ModelAttribute
	public Member get(@RequestParam(required = false) String id) {
		Member entity = null;
		if (StringUtils.isNotBlank(id)) {
			entity = memberService.get(id);
		}
		if (entity == null) {
			entity = new Member();
		}
		return entity;
	}

	@RequiresPermissions("catx:member:view")
	@RequestMapping(value = {"list", ""})
	public String list(Member member, HttpServletRequest request, HttpServletResponse response, Model model) {
		member.setCreateBy(UserUtils.getLoginUser());
		Page<Member> page = memberService.findPage(new Page<>(request, response), member);
		model.addAttribute("page", page);
		return "oa/catx/member/memberList";
	}

	@RequiresPermissions("catx:member:add")
	@RequestMapping(value = "addForm")
	public String form(Member member, Model model) {
		model.addAttribute("member", member);
		return "oa/catx/member/memberAddForm";
	}

	@RequiresPermissions("catx:member:add")
	@RequestMapping(value = "save")
	@ResponseBody
	public ResultDto<String> save(Member member, Model model) {
		ResultDto<String> result = ResultDto.success("ok");
		try {
			member.setName(StringEscapeUtils.unescapeHtml4(member.getName()));
			if (!beanValidator(model, member)) {
				throw new ZAException(ZAErrorCode.ZA_ERROR, "参数校验失败");
			}
			// 进行实名验证
			memberService.authenticationVild(member);
			member.setMemberType(IEnum.getMessage(MemberCardTypeEnum.class, member.getMemberCardType()));
			memberService.save(member);
			result.setMsg("保存成功");
		} catch (Exception ex) {
			ex.printStackTrace();
			result = ResultDto.error(ZAErrorCode.ZA_ERROR, ex.getMessage());
		}
		return result;
	}

	@RequiresPermissions("catx:member:del")
	@RequestMapping(value = "delete")
	public String delete(Member member, RedirectAttributes redirectAttributes) {
		if (member.getMemberEndDate() != null) {
			addMessage(redirectAttributes, "未缴费会员才可删除");
			return "redirect:" + Global.getAdminPath() + "/catx/member/?repage";
		}
		memberService.delete(member);
		addMessage(redirectAttributes, "删除用户会员信息表成功");
		return "redirect:" + Global.getAdminPath() + "/catx/member/?repage";
	}
}