package com.cku.cab.editor.handlervenue.web;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

import com.thinkgem.jeesite.common.config.Global;
import com.thinkgem.jeesite.common.persistence.Page;
import com.thinkgem.jeesite.common.web.BaseController;
import com.thinkgem.jeesite.common.utils.StringUtils;
import com.cku.cab.editor.handlervenue.entity.HandlerVenue;
import com.cku.cab.editor.handlervenue.service.HandlerVenueService;

/**
 * 培训场馆Controller
 * @author zhuoHeng
 * @version 2016-11-25
 */
@Controller
@RequestMapping(value = "${adminPath}/handlervenue/handlerVenue")
public class HandlerVenueController extends BaseController {

	@Autowired
	private HandlerVenueService handlerVenueService;
	
	@ModelAttribute
	public HandlerVenue get(@RequestParam(required=false) String id) {
		HandlerVenue entity = null;
		if (StringUtils.isNotBlank(id)){
			entity = handlerVenueService.get(id);
		}
		if (entity == null){
			entity = new HandlerVenue();
		}
		return entity;
	}
	
	@RequiresPermissions("handlervenue:handlerVenue:view")
	@RequestMapping(value = {"list", ""})
	public String list(HandlerVenue handlerVenue, HttpServletRequest request, HttpServletResponse response, Model model) {
		Page<HandlerVenue> page = handlerVenueService.findPage(new Page<HandlerVenue>(request, response), handlerVenue); 
		model.addAttribute("page", page);
		return "editor/handlervenue/handlerVenueList";
	}

	@RequiresPermissions("handlervenue:handlerVenue:view")
	@RequestMapping(value = "form")
	public String form(HandlerVenue handlerVenue, Model model) {
		model.addAttribute("handlerVenue", handlerVenue);
		return "editor/handlervenue/handlerVenueForm";
	}

	@RequiresPermissions("handlervenue:handlerVenue:edit")
	@RequestMapping(value = "save")
	public String save(HandlerVenue handlerVenue, Model model, RedirectAttributes redirectAttributes) {
		if (!beanValidator(model, handlerVenue)){
			return form(handlerVenue, model);
		}
		handlerVenueService.save(handlerVenue);
		addMessage(redirectAttributes, "保存培训场馆成功");
		return "redirect:"+Global.getAdminPath()+"/handlervenue/handlerVenue/?repage";
	}
	
	@RequiresPermissions("handlervenue:handlerVenue:edit")
	@RequestMapping(value = "delete")
	public String delete(HandlerVenue handlerVenue, RedirectAttributes redirectAttributes) {
		handlerVenueService.delete(handlerVenue);
		addMessage(redirectAttributes, "删除培训场馆成功");
		return "redirect:"+Global.getAdminPath()+"/handlervenue/handlerVenue/?repage";
	}

}