package com.cku.cab.editor.ckuhotel.web;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

import com.thinkgem.jeesite.common.config.Global;
import com.thinkgem.jeesite.common.persistence.Page;
import com.thinkgem.jeesite.common.web.BaseController;
import com.thinkgem.jeesite.common.utils.StringUtils;
import com.cku.cab.editor.ckuhotel.entity.CkuHotel;
import com.cku.cab.editor.ckuhotel.service.CkuHotelService;
import com.cku.core.RESTResponse;
import com.cku.util.ServletUtils;

/**
 * 美容培训酒店Controller
 * @author zhuoHeng
 * @version 2016-11-29
 */
@Controller
@RequestMapping(value = "api/v1/ckuHotel")
public class RestCkuHotelController extends BaseController {

	@Autowired
	private CkuHotelService ckuHotelService;
	
	/**
	 * 
	 * @Description：美容培训酒店接口
	 * @author: zhuoHeng
	 * @version: 2016年11月29日 上午10:10:13
	 */
	@RequestMapping(value = "/ckuHotel", method = RequestMethod.GET)
	@ResponseBody
	public void getList(HttpServletRequest request, HttpServletResponse response)
			throws Exception {
		RESTResponse result = ckuHotelService.getHotel(request);
		ServletUtils.writeResponse(response, result);
	}

}