<%@ page contentType="text/html;charset=UTF-8" %>
<%@ include file="/WEB-INF/views/include/taglib.jsp"%>
<html>
<head>
	<title>用户会员信息表管理</title>
	<meta name="decorator" content="default"/>
	<script type="text/javascript">
		$(document).ready(function() {
			
		});
		function page(n,s){
			$("#pageNo").val(n);
			$("#pageSize").val(s);
			$("#searchForm").submit();
        	return false;
        }
	</script>
</head>
<body>
	<ul class="nav nav-tabs">
		<li class="active"><a href="${ctxDc}/user/member/">会员列表</a></li>
	</ul>
	<form:form id="searchForm" modelAttribute="member" action="${ctxDc}/user/member/" method="post" class="breadcrumb form-search">
		<input id="pageNo" name="pageNo" type="hidden" value="${page.pageNo}"/>
		<input id="pageSize" name="pageSize" type="hidden" value="${page.pageSize}"/>
		<ul class="ul-form">
			<li><label>会员号/姓名：</label>
				<form:input path="memberCode" htmlEscape="false" maxlength="100" class="input-small"/>
			</li>
			<li>
				<label>电话：</label>
				<form:input path="mobile" htmlEscape="false" maxlength="100" class="input-small"/>
			</li>
			<li>
				<label>证件号：</label>
				<form:input path="cardNo" htmlEscape="false" maxlength="100" class="input-small"/>
			</li>
			<li>
				<label>犬舍名称：</label>
				<form:input path="kennel.name" htmlEscape="false" maxlength="100" class="input-small"/>
			</li>
			<li>
				<label>安全手机：</label>
				<form:input path="safeMobile" htmlEscape="false" maxlength="100" class="input-small"/>
			</li>
			<li>
				<label>会员类型：</label>
				<form:select path="memberType" class="input-small">
					<form:option value="">全部</form:option>
					<form:options items="${fns:getDictList('user_member_type')}" itemLabel="label" itemValue="value" htmlEscape="false"/>
				</form:select>
			</li>
			<li>
				<label>缴费状态：</label>
				<form:select path="paymentState" class="input-small">
					<form:option value="all">全部</form:option>
					<form:options items="${fns:getDictList('user_payment_state')}" itemLabel="label" itemValue="value" htmlEscape="false"/>
				</form:select>
			</li>
<%--			<li>
				<label>审核状态：</label>
				<form:select path="reviewState" class="input-small">
					<form:option value="">全部</form:option>
					<form:options items="${fns:getDictList('diploma_review_state')}" itemLabel="label" itemValue="value" htmlEscape="false"/>
				</form:select>
			</li>--%>
			<li class="btns"><input id="btnSubmit" class="btn btn-primary" type="submit" value="查询"/></li>
			<li class="clearfix"></li>
		</ul>
	</form:form>
	<sys:message content="${message}"/>
	<table id="contentTable" class="table table-striped table-bordered table-condensed">
		<thead>
			<tr>
				<th>会员编号</th>
				<th>姓名</th>
				<th>电话</th>
				<th>安全手机</th>
				<th>会员类型</th>
				<th>犬舍信息</th>
				<th>缴费状态</th>
				<th>冻结状态</th>
				<th>余额</th>
				<th>管理</th>
			</tr>
		</thead>
		<tbody>
		<c:forEach items="${page.list}" var="member">
			<tr>
				<td>
					${fns:escapeHtml(member.memberCode) }
				</td>
				<td>
					${fns:escapeHtml(member.name)}
					<c:if test="${!empty member.kennelAlliance}">
						<img width="16px" height="16px" src="${ctxStatic }/images/you.gif"/>
					</c:if>
					<c:if test="${!empty member.groomerType}">
						<img width="16px" height="16px" src="${ctxStatic }/images/G.jpg"/>
					</c:if>
					<c:if test="${!empty member.tcbKennel}">
						<img width="16px" height="16px" src="${ctxStatic }/images/tao.jpg"/>
					</c:if>
				</td>
				<td>
					${fns:escapeHtml(member.mobile)}
				</td>
				<td>
					${fns:escapeHtml(member.safeMobile)}
				</td>
				<td>
					${fns:getDictLabels(member.memberType, 'user_member_type', '')}
				</td>
				<td>
					<c:if test="${not empty member.kennel.id && member.memberType eq 'professional'&& (member.freezeFlag=='0' || empty member.freezeFlag)}">
							<a href="#">${fns:escapeHtml(member.kennel.name)}</a>
					</c:if>
				</td>
				<td style="color:${member.paymentState=='2'?'#090':'#F00'}">
					${fns:getDictLabels(member.paymentState, 'user_payment_state', '未缴费')}
				</td>
				<td>
					<c:if test="${member.freezeFlag=='0' || empty member.freezeFlag}">
						<font style="color:green">未冻结</font>
					</c:if>
					<c:if test="${member.freezeFlag=='1' }">
							<font style="color:red">已冻结</font>
					</c:if>
				</td>
				<td>
					${member.accountBalance }
				</td>
				<td>
    					<a href="${ctxDc}/user/member/view?id=${member.id}">查看</a>
				</td>
			</tr>
		</c:forEach>
		</tbody>
	</table>
	<div class="pagination">${page}</div>
</body>
</html>