<%@ page contentType="text/html;charset=UTF-8" %>
<%@ include file="/WEB-INF/views/include/taglib.jsp"%>
<html>
<head>
	<title>犬只DNA存档管理</title>
	<meta name="decorator" content="default"/>
	<script type="text/javascript">
		$(document).ready(function() {
			//悬浮提示插件
			$(document).tooltip();
		});
		function page(n,s){
			$("#pageNo").val(n);
			$("#pageSize").val(s);
			$("#searchForm").submit();
        	return false;
        }
	</script>
	<!-- 悬浮提示插件 -->
	<link rel="stylesheet" href="${ctxStatic}/jquery-ui/1.12.0/jquery-ui.min.css">
	<script src="${ctxStatic}/jquery-ui/1.12.0/jquery-ui.min.js"></script>
</head>
<body>
	<ul class="nav nav-tabs">
		<li class="active"><a  href="${ctxPartner}/dna/list">位点分析</a></li>
		<li ><a href="${ctxPartner}/dna/listBlood">DNA血样留存</a></li>
	</ul>
	<form:form id="searchForm" modelAttribute="dogDnaArchive" action="${ctxPartner}/dna/list" method="post" class="breadcrumb form-search">
		<input id="pageNo" name="pageNo" type="hidden" value="${page.pageNo}"/>
		<input id="pageSize" name="pageSize" type="hidden" value="${page.pageSize}"/>
		<ul class="ul-form">
            <li><label>会员号/姓名：</label>
                <form:input path="paymentMemberCode" htmlEscape="false" maxlength="64" class="input-medium"/>
            </li>
            <li><label style="width: 140px;">血统证书号：</label>
                <form:input path="pedigreeCertified" htmlEscape="false" maxlength="64" class="input-medium"/>
            </li>
            <li><label style="width: 140px;">芯片号：</label>
                <form:input path="chipCode" htmlEscape="false" maxlength="64" class="input-medium"/>
            </li>
               <li><label style="width: 140px;">登记卡编号：</label>
                <form:input path="birthCode" htmlEscape="false" maxlength="64" class="input-medium"/>
            </li>
            <li class="btns"><input id="btnSubmit" class="btn btn-primary" type="submit" value="查询"/></li>
        </ul>
		</ul>
        <ul class="ul-form">
			<c:if test= "${orgType ne 'hospital' }">
	            <li class="btns" style="float:right"><a  class="btn btn-primary"  href="${ctxPartner}/dna/form" >申请</a></li>
	            <li class="clearfix"></li>
            </c:if>
        </ul>
		<ul class="ul-form">	

	</form:form>
	<sys:message content="${message}"/>
	<table id="contentTable" class="table table-striped table-bordered table-condensed">
		<thead>
			<tr>
				<th>血统证书编号</th>
				<th>芯片号</th>
				<th>登记卡编号</th>
				<th>犬种</th>
				<th>犬名</th>
				<th>犬主</th>
				<th>会员号</th>
				<th>是否完成</th>
				<th>缴费</th>
				<th>操作</th>
			</tr>
		</thead>
		<tbody>
		<c:forEach items="${page.list}" var="dogDnaArchive">
			<tr>
				<td>
					${fns:escapeHtml(dogDnaArchive.pedigreeCertifiedCode)}
				</td>
				<td>
					${fns:escapeHtml(dogDnaArchive.chipCode)}
				</td>
				<td>
					${fns:escapeHtml(dogDnaArchive.birthCode)}
				</td>
				<td>
					${fns:escapeHtml(dogDnaArchive.dogBreed)}
				</td>
				<td>
					${fns:escapeHtml(dogDnaArchive.dogName)}
				</td>
				<td>
					${fns:escapeHtml(dogDnaArchive.memberName)}
				</td>
				<td>${fns:escapeHtml(dogDnaArchive.paymentMemberCode)}</td>
				<td>
					<c:if test="${dogDnaArchive.typeYes=='2' }">
						是
					</c:if>
					<c:if test="${dogDnaArchive.typeYes=='1' }">
						否
					</c:if>
					<c:if test="${dogDnaArchive.typeYes=='' or  dogDnaArchive.typeYes==null }">
						-
					</c:if>
				</td>

				<td>
					<c:if test="${dogDnaArchive.paymentState=='1' }">
						<a style="color:red;" href="${ctxPartner}/dna/toOrder?id=${dogDnaArchive.id}&type=1">缴费</a>
					</c:if>
					<c:if test="${dogDnaArchive.paymentState=='2' }">
						<font style="color:green;">${fns:getDictLabel(dogDnaArchive.paymentState, 'user_payment_state', '')}</font>
					</c:if>
				</td>
				<td>
					<c:if test="${dogDnaArchive.paymentState=='1' }">
						<a href="${ctxPartner}/dna/delete?id=${dogDnaArchive.id}&type=1" onclick="return confirmx('确认要删除该犬只DNA存档吗？', this.href)">删除</a>
					</c:if>
					<%--<c:if test="${dogDnaArchive.typeYes=='1'}">--%>
						<a href="${ctxPartner}/dna/editFrom?type=1&id=${dogDnaArchive.id}">编辑</a>
					<%--</c:if>--%>
				</td>
			</tr>
		</c:forEach>
		</tbody>
	</table>
	<div class="pagination">${page}</div>
</body>
</html>