<%@ page contentType="text/html;charset=UTF-8" %>
<%@ include file="/WEB-INF/views/include/taglib.jsp"%>
<html>
<head>
	<title>用户会员信息表管理</title>
	<meta name="decorator" content="default"/>
	<script type="text/javascript">
		$(document).ready(function() {
			
		});
		function page(n,s){
			$("#pageNo").val(n);
			$("#pageSize").val(s);
			$("#searchForm").submit();
        	return false;
        }
	</script>
</head>
<body>
	<ul class="nav nav-tabs">
		<li class="active"><a href="${ctx}/sys/user/member/">网站用户与会员关联</a></li>
	</ul>
	<form:form id="searchForm" modelAttribute="member" action="${ctx}/sys/user/member/bind" method="post" class="breadcrumb form-search">
		<input id="pageNo" name="pageNo" type="hidden" value="${page.pageNo}"/>
		<input id="pageSize" name="pageSize" type="hidden" value="${page.pageSize}"/>
		<ul class="ul-form">
			<li><label>姓名/会员编号：</label>
				<form:input path="memberCode" htmlEscape="false" maxlength="100" class="input-small"/>
			</li>
			<li><label>网站帐号：</label>
				<form:input path="user.loginName" htmlEscape="false" maxlength="100" class="input-small"/>
			</li>
			<li><label>登录手机号：</label>
				<form:input path="mobile" htmlEscape="false" maxlength="100" class="input-small"/>
			</li>
			<li class="btns"><input id="btnSubmit" class="btn btn-primary" type="submit" value="查询"/> 
			<shiro:hasPermission name="sys:user:member:bind"><input class="btn btn-primary" type="button" value="会员绑定" onclick="editBindRelation()"/></shiro:hasPermission></li>
			<li class="clearfix"></li>
		</ul>
	</form:form>
	<sys:message content="${message}"/>
	<table id="contentTable" class="table table-striped table-bordered table-condensed">
		<thead>
			<tr>
				<th>会员编号</th>
				<th>登录手机号</th>
				<th>网站帐号</th>
				<th>姓名</th>
				<th>会员类型</th>
				<th>状态</th>
				<th>管理</th>
			</tr>
		</thead>
		<tbody>
		<c:forEach items="${page.list}" var="member">
			<tr>
				<td>
					${fns:escapeHtml(member.memberCode) }
				</td>
				<td>
					${fns:escapeHtml(empty member.loginMobile?"——————":member.loginMobile)}
				</td>
				<td>
					${fns:escapeHtml(empty member.user.loginName?"——————":member.user.loginName)}
				</td>
				<td>
					${fns:escapeHtml(member.name)}
				</td>
				<td>
					${fns:getDictLabels(member.memberCardType, 'member_card_type', '')}
				</td>
				<td>
					<c:if test="${not empty member.user.loginName}">
						<c:if test="${member.user.loginFlag eq 1}">
							激活
						</c:if>
						<c:if test="${empty member.user.loginFlag || member.user.loginFlag eq 0}">
							禁用
						</c:if>
					</c:if>
					<c:if test="${empty member.user.loginName}"> —— </c:if>
				</td>

				<td>
					<shiro:hasPermission name="sys:user:member:edit">
						<a href="###" onclick="editBindRelation('${member.id}');">调整绑定关系</a>
					</shiro:hasPermission>
					<shiro:hasPermission name="sys:user:member:resetPassword">
						<a href="###" onclick="passwordReset('${member.id}');">重置密码</a>
					</shiro:hasPermission>
					<shiro:hasPermission name="sys:user:member:state">
						<c:if test="${member.user.loginFlag eq 1}">
							<a href="${ctx}/sys/user/member/login/state?id=${member.id}" onclick="return confirmx('确认要禁用该会员的网站帐号吗？', this.href)">禁用</a>
						</c:if>
						<c:if test="${empty member.user.loginFlag || member.user.loginFlag eq 0}">
							<a href="${ctx}/sys/user/member/login/state?id=${member.id}" onclick="return confirmx('确认要激活该会员的网站帐号？', this.href)">激活</a>
						</c:if>
					</shiro:hasPermission>
					<shiro:hasPermission name="sys:user:member:resetCardLimit">
							<a href="${ctx}/sys/user/member/card/reset?id=${member.id}" onclick="return confirmx('确认要重置身份验证次数吗？', this.href)">重置身份验证次数</a>
					</shiro:hasPermission>
				</td>
			</tr>
		</c:forEach>
		</tbody>
	</table>
	<div class="pagination">${page}</div>
	<div id="bindForm" style="display:none;padding-top:20px;">
		<form id="inputForm"  action="#" method="post" class="form-horizontal">
			<div class="control-group">
				<label class="control-label">会员编号：</label>
				<div class="controls">
					<input type="text" id="bindMemberCode" name="memberCode"  maxlength="60" class="input-xlarge " readonly="readonly"/>
					<span class="help-inline"><font color="red">*</font> </span>
				</div>
			</div>
			<div class="control-group">
				<label class="control-label">网站登录帐号：</label>
				<div class="controls">
					<input type="text" id="bindLoginName"  maxlength="60" class="input-xlarge "/>
					<span class="help-inline"><font color="red">*</font> </span>
				</div>
			</div>
		</form>
	</div>
	
	<script type="text/javascript">
		function editBindRelation(id){
			parent.layer.open({
				type: 2,
				title: ['修改绑定关系', 'font-size:18px;text-align: center;'],
				shadeClose: false,
				shade: [0.8, '#393D49'],
				maxmin: false, //开启最大化最小化按钮
				area: ['600px', '400px'],
				content: "${ctx}/sys/user/member/edit/bind/form?id="+id
			});
			return false;
		}
		
		function bindUserCallback(data){
			window.location.reload();
		}
		
		function passwordReset(id){
			parent.layer.open({
				type: 2,
				title: ['重置密码', 'font-size:18px;text-align: center;'],
				shadeClose: false,
				shade: [0.8, '#393D49'],
				maxmin: false, //开启最大化最小化按钮
				area: ['600px', '400px'],
				content: "${ctx}/sys/user/member/password/resetForm?id="+id
			});
			return false;
		}
		
		function passwordResetCallback(data){
			window.location.reload();
		}
		
	</script>
</body>
</html>