<%@ page contentType="text/html;charset=UTF-8" %>
<%@ include file="/WEB-INF/views/include/taglib.jsp"%>
<html>
<head>
	<title>俱乐部充值</title>
	<meta name="decorator" content="default"/>
	<script type="text/javascript">
		$(document).ready(function() {
			//$("#name").focus();
			$("#inputForm").validate({
				submitHandler: function(form){
					
						loading('正在提交，请稍等...');
						form.submit(); 
				},
				errorContainer: "#messageBox",
				errorPlacement: function(error, element) {
					$("#messageBox").text("输入有误，请先更正。");
					if (element.is(":checkbox")||element.is(":radio")||element.parent().is(".input-append")){
						error.appendTo(element.parent().parent());
					} else {
						error.insertAfter(element);
					}
				}
			});
			$("#paymentShow span:first-child").remove();
			$("#paymentWay2").attr("checked","true");
		});
	</script>
</head>
<body>
	<ul class="nav nav-tabs">
		<li><a href="${ctx}/shop/shopMember/moneyList">俱乐部账户收支信息</a></li>
		<li><a href="${ctx}/shop/shopMember/list">俱乐部账户</a></li>
		<li class="active"><a href="${ctx}/shop/shopMember/form">俱乐部充值</a></li>
		<li><a href="${ctx}/shop/shopMember/refund">俱乐部退款</a></li>
	</ul><br/>
	<form:form id="inputForm" modelAttribute="shopMember" action="${ctx}/shop/shopMember/recharge" method="post" class="form-horizontal">
		<div class="control-group">
			<label class="control-label">会员号：</label>
			<div class="controls">
				<input name="memberCode" id="memberCode" type="text" htmlEscape="false" maxlength="100" class="form-control" required title="会员号不能为空！"/>
                <span class="input-group-btn">
                <button class="btn btn-default" type="button" id="memberCodeBtn" onclick="searchUser()">查</button>
                <font id="paymentState" ></font>
                </span>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">俱乐部名称：</label>
			<div class="controls">
				<input type="text" readonly="readonly" id="memberName"  htmlEscape="false" maxlength="100" class="form-control" required title="会员名称不能为空！"/>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">联系人：</label>
			<div class="controls">
				<input type="text" readonly="readonly" id="contact"  htmlEscape="false" maxlength="100" class="form-control" required title="会员名称不能为空！"/>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">余额：</label>
			<div class="controls">
				<input type="text" readonly="readonly"  id="shopMoney"   class="form-control" >
			</div>
		</div>

		<div class="control-group">
			<label class="control-label">缴费金额：</label>
			<div class="controls">
				<input id="paymentAmount" type="number"  name="paymentAmount" min="0" step="0.01" class="form-control" required >
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">缴费方式：</label>
			<div class="controls" id="paymentShow">
				<form:radiobuttons path="paymentWay" items="${fns:getDictList('payment_way')}" itemLabel="label" itemValue="value" htmlEscape="false" class="required" title="缴费方式不能为空！"/>
			</div>
		</div>
		<%-- <div class="control-group">
			<label class="control-label">缴费时间：</label>
			<div class="controls">
				<input name="paymentTime" type="text" readonly="readonly" maxlength="20" class="form-control Wdate "
					   value="<fmt:formatDate value="${member.paymentTime}" pattern="yyyy-MM-dd HH:mm:ss"/>"
					   onclick="WdatePicker({dateFmt:'yyyy-MM-dd HH:mm:ss',isShowClear:true});" required title="缴费时间不能为空！"/>
			</div>
		</div> --%>
		<div class="control-group">
			<label class="control-label">支付宝订单号：</label>
			<div class="controls">
				<input type="text" name="outTradeNo" class="form-control">
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">备注说明：</label>
			<div class="controls">
				<textarea name="paymentRemarks" class="form-control"></textarea>
			</div>
		</div>
		<div class="form-actions">
			<shiro:hasPermission name="shop:shopMember:recharge"><input id="btnSubmit" class="btn btn-primary" type="submit" value="保 存"/>&nbsp;</shiro:hasPermission>
			<input id="btnCancel" class="btn" type="button" value="返 回" onclick="history.go(-1)"/>
		</div>
	</form:form>
	<script>
		//打开查询用户的弹窗
		function searchUser(){
			var memberCode = $("#memberCode").val();
			if(util.isVal(memberCode)==""){
				return;
			}
			$.ajax({
				type: "POST",
				url:"${ctx}/shop/shopMember/searchShopUser",
				dataType:"json",
				data:{memberCode:memberCode},
				async: false,
				error: function(request, textStatus, errorThrown) {
					alert("系统错误，请联系管理员！");
				},
				success: function(data) {
					if(data.rc=="0"){
						$("#memberCode").val(data.memberCode);
						$("#memberName").val(data.memberName);
						$("#contact").val(data.contact);
						$("#shopMoney").val(data.shopMoney);
					}
				}
			});
		}
	</script>
</body>
</html>