<%@ page contentType="text/html;charset=UTF-8" %>
<%@ include file="/WEB-INF/views/include/taglib.jsp"%>
<html>
<head>
	<title>犬舍联盟管理</title>
	<meta name="decorator" content="default"/>
	<script type="text/javascript">
		$(document).ready(function() {
			//悬浮提示插件
			$(document).tooltip();
		});
		function page(n,s){
			$("#pageNo").val(n);
			$("#pageSize").val(s);
			$("#searchForm").submit();
        	return false;
        }
	</script>
	<!-- 悬浮提示插件 -->
	<link rel="stylesheet" href="${ctxStatic}/jquery-ui/1.12.0/jquery-ui.min.css">
	<script src="${ctxStatic}/jquery-ui/1.12.0/jquery-ui.min.js"></script>
</head>
<body>
	<ul class="nav nav-tabs">
		<li class="active"><a href="${ctx}/kennel/kennelAlliance/">犬舍联盟列表</a></li>
		<shiro:hasPermission name="kennel:kennelAlliance:add"><li><a href="${ctx}/kennel/kennelAlliance/form">犬舍联盟添加</a></li></shiro:hasPermission>
	</ul>
	<form:form id="searchForm" modelAttribute="kennelAlliance" action="${ctx}/kennel/kennelAlliance/" method="post" class="breadcrumb form-search">
		<input id="pageNo" name="pageNo" type="hidden" value="${page.pageNo}"/>
		<input id="pageSize" name="pageSize" type="hidden" value="${page.pageSize}"/>
		<ul class="ul-form">
			<li><label>会员号/姓名：</label>
				<form:input path="memberCode" htmlEscape="false" maxlength="64" class="input-medium"/>
			</li>
			<li><label>套餐：</label>
				<form:select path="combo" class="input-medium">
					<form:option value="" label="全部"/>
					<form:option value="12000" label="12000"/>
					<form:option value="6000" label="6000"/>
				</form:select>
			</li>
			<li><label>有效：</label>
				<form:select path="valid" class="input-medium">
					<form:option value="" label="全部"/>
					<form:option value="0" label="是"/>
					<form:option value="1" label="否"/>
				</form:select>
			</li>
			<li class="btns"><input id="btnSubmit" class="btn btn-primary" type="submit" value="查询"/></li>
			<li class="clearfix"></li>
		</ul>
	</form:form>
	<sys:message content="${message}"/>
	<table id="contentTable" class="table table-striped table-bordered table-condensed">
		<thead>
			<tr>
				<th>会员号</th>
				<th>姓名</th>
				<th>截至时间</th>
				<th>电话</th>
				<th>犬舍信息</th>
				<th>有效</th>
				<th>套餐</th>
				<th>经办人</th>
				<th>操作</th>
			</tr>
		</thead>
		<tbody>
		<c:forEach items="${page.list}" var="kennelAlliance">
			<tr>
				<td><a href="${ctx}/kennel/kennelAlliance/form?id=${kennelAlliance.id}" title="${fns:escapeHtml(kennelAlliance.member.name)}">
					${kennelAlliance.memberCode}
				</a></td>
				<td>
					${fns:escapeHtml(kennelAlliance.member.name)}
				</td>
				<td>
					<fmt:formatDate value="${kennelAlliance.endDate}" pattern="yyyy-MM-dd"/>
				</td>
				<td>
					${fns:escapeHtml(kennelAlliance.member.mobile)}
				</td>
				<td>
					${fns:escapeHtml(kennelAlliance.kennel.name)}
				</td>
				<td>
					<c:if test="${kennelAlliance.valid=='0'}">有效</c:if>
					<c:if test="${kennelAlliance.valid=='1'}">无效</c:if>
				</td>
				<td>
					${fns:escapeHtml(kennelAlliance.combo)}
				</td>
				<td>
					${fns:escapeHtml(kennelAlliance.operator)}
				</td>
				<td>
				<shiro:hasPermission name="kennel:kennelAlliance:edit">
    				<a href="${ctx}/kennel/kennelAlliance/form?id=${kennelAlliance.id}">编辑</a>
				</shiro:hasPermission>
				<shiro:hasPermission name="kennel:kennelAlliance:pay">
					<c:if test="${kennelAlliance.valid=='1'}">
    				<a onclick="util.pay('${kennelAlliance.id}','kennel_alliance@kennel','1','${kennelAlliance.combo}','${fns:escapeHtml(kennelAlliance.memberCode)}')">
    				缴费</a>
    				</c:if>
				</shiro:hasPermission>
				<shiro:hasPermission name="kennel:kennelAlliance:delete">
					<a href="${ctx}/kennel/kennelAlliance/delete?id=${kennelAlliance.id}" onclick="return confirmx('确认要删除该犬舍联盟吗？', this.href)">删除</a>
				</shiro:hasPermission>
				</td>
			</tr>
		</c:forEach>
		</tbody>
	</table>
	<div class="pagination">${page}</div>
</body>
</html>