<%@ page contentType="text/html;charset=UTF-8" %>
<%@ include file="/WEB-INF/views/include/taglib.jsp"%>
<html>
<head>
	<title>活动管理</title>
	<meta name="decorator" content="default"/>
	<script type="text/javascript">
		$(document).ready(function() {
			
		});
		function page(n,s){
			$("#pageNo").val(n);
			$("#pageSize").val(s);
			$("#searchForm").submit();
        	return false;
        }
	</script>
</head>
<body>
	<ul class="nav nav-tabs">
		<li class="active"><a href="${ctx}/handler/handlerShow/">活动管理</a></li>
		<shiro:hasPermission name="handler:handlerRegister:view"><li><a href="${ctx}/handler/handlerRegister/">报名管理</a></li></shiro:hasPermission>
	</ul>
	<form:form id="searchForm" modelAttribute="handlerShow" action="${ctx}/handler/handlerShow/" method="post" class="breadcrumb form-search">
		<input id="pageNo" name="pageNo" type="hidden" value="${page.pageNo}"/>
		<input id="pageSize" name="pageSize" type="hidden" value="${page.pageSize}"/>
		<ul class="ul-form">
			<li><label>活动名称：</label>
				<form:input path="showName" htmlEscape="false" maxlength="100" class="input-medium"/>
			</li>
			<li><label>活动编号：</label>
				<form:input path="showCode" htmlEscape="false" maxlength="100" class="input-medium"/>
			</li>
			<li><label>活动地点：</label>
				<form:select id="showAddress" path="showAddress" class="input-medium required" >
	                	<form:option value="" label="全部"></form:option>
	                	<form:options items="${showAddressList}"  htmlEscape="false"/>
	               </form:select>
			</li>
			<li>
				<label>活动类别：</label>
				<form:select path="showType" class="input-xlarge required">
					<form:option value="" label=""/>
					<form:options items="${fns:getDictList('handler_show_type')}" itemLabel="label" itemValue="value" htmlEscape="false"/>
				</form:select>
			</li>
			<li class="btns"><input id="btnSubmit" class="btn btn-primary" type="submit" value="查询"/>
			  <shiro:hasPermission name="handler:handlerShow:add"><a href="${ctx}/handler/handlerShow/form"><input class="btn btn-primary" type="button" value="活动录入"/></a></shiro:hasPermission>
			</li>
			<li class="clearfix"></li>
		</ul>
	</form:form>
	<sys:message content="${message}"/>
	<table id="contentTable" class="table table-striped table-bordered table-condensed">
		<thead>
			<tr>
				<th>活动编号</th>
				<th>活动类别</th>
				<th>活动名称</th>
				<th>活动地点</th>
				<th>开始时间</th>
				<th>结束时间</th>
				<th>截止时间</th>
				<th>报名费</th>
				<th>报名状态</th>
				<th>操作</th>
				<shiro:hasPermission name="handler:handlerShow:register"><th>报名</th></shiro:hasPermission>
			</tr>
		</thead>
		<tbody>
		<c:forEach items="${page.list}" var="handlerShow">
			<tr>
				<td>
					${fns:escapeHtml(handlerShow.showCode)}
				</td>
				<td>
					${fns:getDictLabel(handlerShow.showType, 'handler_show_type', '')}
				</td>
				<td>
					${fns:escapeHtml(handlerShow.showName)}
				</td>
				<td>
					${fns:escapeHtml(handlerShow.showAddress)}
				</td>
				<td>
					<fmt:formatDate value="${handlerShow.startTime}" pattern="yyyy-MM-dd"/>
				</td>
				<td>
					<fmt:formatDate value="${handlerShow.endTime}" pattern="yyyy-MM-dd"/>
				</td>
				<td>
					<fmt:formatDate value="${handlerShow.registerEndTime}" pattern="yyyy-MM-dd HH:mm:ss"/>
				</td>
				<td>
					${fns:escapeHtml(handlerShow.fee)}
				</td>
				<td>
					<c:choose>
						<c:when test="${handlerShow.registerEndTime > date && handlerShow.registerNumFlag}">
							<font color="green">开放</font>
						</c:when>
						<c:otherwise>
							<font color="red">关闭</font>
						</c:otherwise>
					</c:choose>
				</td>
				<td>
				    <a href="${ctx}/handler/handlerShow/view?id=${fns:escapeHtml(handlerShow.id)}">查看</a>
				<shiro:hasPermission name="handler:handlerShow:edit">
    				<a href="${ctx}/handler/handlerShow/edit?id=${fns:escapeHtml(handlerShow.id)}">编辑</a>
   				</shiro:hasPermission>
   				<shiro:hasPermission name="handler:handlerShow:delete">
					<a href="${ctx}/handler/handlerShow/delete?id=${fns:escapeHtml(handlerShow.id)}" onclick="return confirmx('确认要删除该活动吗？', this.href)">删除</a>
				</shiro:hasPermission>
				</td>
				<shiro:hasPermission name="handler:handlerShow:register"><td>
		    		<a href="${ctx}/handler/handlerShow/registerForm?id=${fns:escapeHtml(handlerShow.id)}" >报名</a>
				</td></shiro:hasPermission>
			</tr>
		</c:forEach>
		</tbody>
	</table>
	<div class="pagination">${page}</div>
</body>
</html>